/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import levelsets.filter.MorphologicalOperator;

public class UnsetPixel
extends MorphologicalOperator {
    public UnsetPixel(boolean[][] mask) {
        super(mask);
    }

    @Override
    protected final void processPosition(int x, int y, WritableRaster raster, Raster in) {
        in.getPixel(x, y, this.pixel);
        if (this.pixel[0] == 0) {
            return;
        }
        boolean unsetPixel = true;
        block0: for (int i = 0; i < this.mask.length; ++i) {
            for (int j = 0; j < this.mask[0].length; ++j) {
                if (!this.mask[i][j]) continue;
                in.getPixel(i + x + 1 - this.center, j + y + 1 - this.center, this.pixel);
                if (this.pixel[0] != 0) continue;
                unsetPixel = false;
                continue block0;
            }
        }
        if (unsetPixel) {
            this.pixel[2] = 0;
            this.pixel[1] = 0;
            this.pixel[0] = 0;
        } else {
            this.pixel[2] = 255;
            this.pixel[1] = 255;
            this.pixel[0] = 255;
        }
        raster.setPixel(x, y, this.pixel);
    }

    @Override
    protected final void processPosition(int x, int y, int width, short[] source, short[] target) {
        if (source[x + y * width] == 0) {
            return;
        }
        boolean unsetPixel = true;
        block0: for (int i = 0; i < this.mask.length; ++i) {
            for (int j = 0; j < this.mask[0].length; ++j) {
                if (!this.mask[i][j] || source[i + x + 1 - this.center + (j + y + 1 - this.center) * width] != 0) continue;
                unsetPixel = false;
                continue block0;
            }
        }
        target[x + y * width] = unsetPixel ? 0 : 255;
    }
}

