/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;

public class Save_DF3
implements PlugIn {
    private String[] types = null;

    public void run(String args) {
        double max;
        boolean stretchContrastIsNegotiable = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (null == imp) {
            IJ.error((String)"You have no images open.");
            return;
        }
        if (imp.getStackSize() <= 1) {
            IJ.error((String)"This is not an image stack.");
            return;
        }
        switch (imp.getType()) {
            case 0: 
            case 3: {
                this.types = new String[]{"8-bit unsigned integer"};
                max = 255.0;
                stretchContrastIsNegotiable = true;
                break;
            }
            case 1: {
                this.types = new String[]{"8-bit unsigned integer", "16-bit unsigned integer"};
                max = 65535.0;
                stretchContrastIsNegotiable = true;
                break;
            }
            default: {
                this.types = new String[]{"8-bit unsigned integer", "16-bit unsigned integer", "32-bit unsigned integer"};
                max = 3.4028234663852886E38;
            }
        }
        GenericDialog gd = new GenericDialog("Save df3 file");
        gd.addChoice("Choose_data_output_format :", this.types, this.types[this.types.length - 1]);
        gd.addCheckbox("Create_POV-Ray_scene :", false);
        if (stretchContrastIsNegotiable) {
            gd.addCheckbox("Stretch_contrast :", true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save as ...", imp.getTitle(), ".df3");
        String directory = sd.getDirectory();
        String name = sd.getFileName();
        if (name == null || name == "") {
            IJ.error((String)"No filename selected.");
            return;
        }
        int type = gd.getNextChoiceIndex();
        long typeScale = 1L;
        int typeLength = 0;
        switch (type) {
            case 0: {
                typeLength = 1;
                typeScale = 255L;
                break;
            }
            case 1: {
                typeLength = 2;
                typeScale = 65535L;
                break;
            }
            case 2: {
                typeLength = 4;
                typeScale = 0xFFFFFFFFL;
            }
        }
        String fileName = directory + name;
        boolean createPov = gd.getNextBoolean();
        boolean stretchContrast = stretchContrastIsNegotiable ? gd.getNextBoolean() : true;
        ImageStack stack = imp.getStack();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int length = width * height;
        int depth = stack.getSize();
        double min = 0.0;
        if (stretchContrast) {
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            for (int z = 1; z <= depth; ++z) {
                IJ.showProgress((int)z, (int)depth);
                IJ.showStatus((String)("Identifying contrast range: " + z + "/" + depth));
                ImageProcessor ips = stack.getProcessor(z);
                for (int i = 0; i < length; ++i) {
                    double v = ips.getf(i);
                    if (v < min) {
                        min = v;
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
            }
        }
        try {
            byte[] bytes;
            FileOutputStream file = new FileOutputStream(fileName, false);
            byte[] header = new byte[]{(byte)(width >> 8), (byte)width, (byte)(height >> 8), (byte)height, (byte)(depth >> 8), (byte)depth};
            file.write(header);
            double d = (double)typeScale / (max - min);
            for (int z = 1; z <= depth; ++z) {
                IJ.showProgress((int)z, (int)depth);
                IJ.showStatus((String)("Writing: " + z + "/" + depth));
                ImageProcessor ips = stack.getProcessor(z);
                bytes = new byte[typeLength * length];
                block21: for (int i = 0; i < length; ++i) {
                    int j = typeLength * i;
                    long pixel = Math.min(typeScale, Math.max(0L, (long)(((double)ips.getf(i) - min) * d)));
                    switch (type) {
                        case 0: {
                            bytes[j] = (byte)pixel;
                            continue block21;
                        }
                        case 1: {
                            bytes[j] = (byte)(pixel >> 8);
                            bytes[j + 1] = (byte)pixel;
                            continue block21;
                        }
                        case 2: {
                            bytes[j] = (byte)(pixel >> 24);
                            bytes[j + 1] = (byte)(pixel >> 16);
                            bytes[j + 2] = (byte)(pixel >> 8);
                            bytes[j + 3] = (byte)pixel;
                        }
                    }
                }
                file.write(bytes);
            }
            file.close();
            IJ.showStatus((String)("Saved " + fileName + "."));
            if (createPov) {
                String rawFileName = fileName.replaceAll(".df3$", "");
                try {
                    InputStream is = this.getClass().getResourceAsStream("df3_scene.pov");
                    bytes = new byte[is.available()];
                    is.read(bytes);
                    String povCode = new String(bytes);
                    povCode = povCode.replaceAll(new String("\\$file_name\\$"), rawFileName);
                    povCode = povCode.replaceAll("\\$max_length\\$", new Integer(Math.max(width, Math.max(height, depth))).toString());
                    povCode = povCode.replaceAll("\\$width\\$", new Integer(width).toString());
                    povCode = povCode.replaceAll("\\$height\\$", new Integer(height).toString());
                    povCode = povCode.replaceAll("\\$depth\\$", new Integer(depth).toString());
                    PrintStream ps = new PrintStream(rawFileName + ".pov");
                    ps.print(povCode);
                    ps.close();
                }
                catch (Exception e) {
                    IJ.error((String)("Error writing pov-file '" + rawFileName + ".pov'.\n" + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            IJ.error((String)("Error writing df3-file '" + fileName + "'.\n" + e.getMessage()));
            return;
        }
    }
}

