/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.laplacian;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.gpu.GpuFeatureInput;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuPixelWiseOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;

@Plugin(type=FeatureOp.class, label="laplacian of gaussian")
public class SingleLaplacianOfGaussianFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma = 1.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("laplacian of gaussian sigma=" + this.sigma);
    }

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        int n = this.globalSettings().numDimensions();
        switch (n) {
            case 2: {
                this.apply2d(input, output);
                return;
            }
            case 3: {
                this.apply3d(input, output);
                return;
            }
        }
        throw new IllegalArgumentException("Expect 2d or 3d.");
    }

    private void apply2d(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        RandomAccessibleInterval<DoubleType> dx = input.derivedGauss(this.sigma, this.order(2, 0));
        RandomAccessibleInterval<DoubleType> dy = input.derivedGauss(this.sigma, this.order(2, 1));
        LoopBuilder.setImages(dx, dy, output.get(0)).multiThreaded().forEachPixel((x, y, sum) -> sum.setReal(x.getRealDouble() + y.getRealDouble()));
    }

    private void apply3d(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        RandomAccessibleInterval<DoubleType> dx = input.derivedGauss(this.sigma, this.order(3, 0));
        RandomAccessibleInterval<DoubleType> dy = input.derivedGauss(this.sigma, this.order(3, 1));
        RandomAccessibleInterval<DoubleType> dz = input.derivedGauss(this.sigma, this.order(3, 2));
        LoopBuilder.setImages(dx, dy, dz, output.get(0)).multiThreaded().forEachPixel((x, y, z, sum) -> sum.setReal(x.getRealDouble() + y.getRealDouble() + z.getRealDouble()));
    }

    private int[] order(int n, int d) {
        return IntStream.range(0, n).map(i -> i == d ? 2 : 0).toArray();
    }

    @Override
    public void prefetch(GpuFeatureInput input) {
        for (int d = 0; d < this.globalSettings().numDimensions(); ++d) {
            input.prefetchSecondDerivative(this.sigma, d, d, input.targetInterval());
        }
    }

    @Override
    public void apply(GpuFeatureInput input, List<GpuView> output) {
        boolean is3d = this.globalSettings().numDimensions() == 3;
        GpuApi gpu = input.gpuApi();
        GpuPixelWiseOperation loopBuilder = GpuPixelWiseOperation.gpu(gpu);
        loopBuilder.addInput("dxx", input.secondDerivative(this.sigma, 0, 0, input.targetInterval()));
        loopBuilder.addInput("dyy", input.secondDerivative(this.sigma, 1, 1, input.targetInterval()));
        if (is3d) {
            loopBuilder.addInput("dzz", input.secondDerivative(this.sigma, 2, 2, input.targetInterval()));
        }
        loopBuilder.addOutput("output", output.get(0));
        String operation = is3d ? "output = dxx + dyy + dzz" : "output = dxx + dyy";
        loopBuilder.forEachPixel(operation);
    }
}

