/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats;

import java.util.ArrayList;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolution;
import net.imglib2.type.numeric.RealType;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.SumConvolver;

class SumFilter {
    SumFilter() {
    }

    public static <T extends RealType<?>> Convolution<T> convolution(int ... sizes) {
        ArrayList<LineConvolution> convolutions = new ArrayList<LineConvolution>(sizes.length);
        for (int d = 0; d < sizes.length; ++d) {
            convolutions.add(new LineConvolution(SumConvolver.factory(sizes[d] / 2, (sizes[d] - 1) / 2), d));
        }
        return Convolution.concat(convolutions);
    }

    public static void convolve(int[] sizes, RandomAccessible<? extends RealType<?>> source, RandomAccessibleInterval<? extends RealType<?>> target) {
        SumFilter.convolution(sizes).process(source, target);
    }
}

