/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.iterator.RealIntervalIterator;
import net.imglib2.realtransform.RealTransform;

public class BoundingBoxEstimation {
    private Method method;
    private int samplesPerDim = 5;
    private double[] steps;

    public BoundingBoxEstimation() {
        this(Method.FACES);
    }

    public BoundingBoxEstimation(Method method) {
        this.setMethod(method);
    }

    public BoundingBoxEstimation(Method method, int samplesPerDim) {
        this.setMethod(method);
        this.setSamplesPerDim(samplesPerDim);
    }

    public void setMethod(String method) {
        this.setMethod(Method.valueOf(method));
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setSamplesPerDim(int samplesPerDim) {
        this.samplesPerDim = samplesPerDim;
    }

    public double[] setSamplesPerDim(RealInterval itvl, int maxSamples) {
        this.steps = BoundingBoxEstimation.samplesPerDim(itvl, maxSamples);
        return this.steps;
    }

    public static double[] samplesPerDim(RealInterval itvl, int maxSamples) {
        int nd = itvl.numDimensions();
        double step = Double.MIN_VALUE;
        for (int i = 0; i < nd; ++i) {
            double ns = (itvl.realMax(i) - itvl.realMin(i)) / (double)maxSamples;
            if (!(ns > step)) continue;
            step = ns;
        }
        double[] steps = new double[nd];
        Arrays.fill(steps, step);
        return steps;
    }

    public RealInterval estimateInterval(RealTransform xfm, RealInterval interval) {
        this.steps = BoundingBoxEstimation.samplesPerDim(interval, this.samplesPerDim);
        switch (this.method) {
            case CORNERS: {
                return BoundingBoxEstimation.cornersReal(xfm, interval);
            }
            case VOLUME: {
                return BoundingBoxEstimation.volumeReal(xfm, interval, this.steps);
            }
        }
        return BoundingBoxEstimation.facesReal(xfm, interval, this.steps);
    }

    public Interval estimatePixelInterval(RealTransform xfm, Interval interval) {
        this.steps = BoundingBoxEstimation.samplesPerDim((RealInterval)interval, this.samplesPerDim);
        switch (this.method) {
            case CORNERS: {
                return BoundingBoxEstimation.corners(xfm, interval);
            }
            case VOLUME: {
                return BoundingBoxEstimation.volume(xfm, interval, this.steps);
            }
        }
        return BoundingBoxEstimation.faces(xfm, interval, this.steps);
    }

    public BoundingBoxEstimation copy() {
        return new BoundingBoxEstimation(this.method, this.samplesPerDim);
    }

    public static FinalInterval containingInterval(RealInterval realInterval) {
        int nd = realInterval.numDimensions();
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = (long)Math.floor(realInterval.realMin(i));
            max[i] = (long)Math.ceil(realInterval.realMax(i));
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval faces(RealTransform xfm, Interval interval, double[] steps) {
        return BoundingBoxEstimation.containingInterval((RealInterval)BoundingBoxEstimation.facesReal(xfm, (RealInterval)interval, steps));
    }

    public static FinalRealInterval facesReal(RealTransform xfm, RealInterval interval, double[] stepsIn) {
        if (xfm == null) {
            return new FinalRealInterval(interval);
        }
        double[] steps = stepsIn == null ? BoundingBoxEstimation.samplesPerDim(interval, 5) : stepsIn;
        int nd = interval.numDimensions();
        double[] min = new double[nd];
        double[] max = new double[nd];
        Arrays.fill(min, 9.223372036854776E18);
        Arrays.fill(max, -9.223372036854776E18);
        double[] itvlMin = new double[nd];
        double[] itvlMax = new double[nd];
        for (int i = 0; i < nd; ++i) {
            BoundingBoxEstimation.subInterval(interval, interval.realMin(i), i, itvlMin, itvlMax);
            BoundingBoxEstimation.minMaxInterval(xfm, (RealInterval)new FinalRealInterval(itvlMin, itvlMax), steps, min, max);
            BoundingBoxEstimation.subInterval(interval, interval.realMax(i), i, itvlMin, itvlMax);
            BoundingBoxEstimation.minMaxInterval(xfm, (RealInterval)new FinalRealInterval(itvlMin, itvlMax), steps, min, max);
        }
        return new FinalRealInterval(min, max);
    }

    public static void minMaxInterval(RealTransform xfm, RealInterval interval, double[] steps, double[] min, double[] max) {
        int nd = interval.numDimensions();
        RealIntervalIterator it = new RealIntervalIterator(interval, steps);
        RealPoint ptxfm = new RealPoint(nd);
        while (it.hasNext()) {
            it.fwd();
            xfm.apply((RealLocalizable)it, (RealPositionable)ptxfm);
            for (int d = 0; d < nd; ++d) {
                double lo = ptxfm.getDoublePosition(d);
                double hi = ptxfm.getDoublePosition(d);
                if (lo < min[d]) {
                    min[d] = lo;
                }
                if (!(hi > max[d])) continue;
                max[d] = hi;
            }
        }
    }

    public static void subInterval(RealInterval interval, double pos, int dim, double[] min, double[] max) {
        interval.realMin(min);
        min[dim] = pos;
        interval.realMax(max);
        max[dim] = pos;
    }

    public static FinalRealInterval volumeReal(RealTransform xfm, RealInterval interval, double[] steps) {
        if (xfm == null) {
            return new FinalRealInterval(interval);
        }
        int nd = interval.numDimensions();
        double[] min = new double[nd];
        double[] max = new double[nd];
        Arrays.fill(min, 9.223372036854776E18);
        Arrays.fill(max, -9.223372036854776E18);
        BoundingBoxEstimation.minMaxInterval(xfm, interval, steps, min, max);
        return new FinalRealInterval(min, max);
    }

    public static FinalInterval volume(RealTransform xfm, Interval interval, double[] steps) {
        return BoundingBoxEstimation.containingInterval((RealInterval)BoundingBoxEstimation.volumeReal(xfm, (RealInterval)interval, steps));
    }

    public static RealInterval cornersReal(RealTransform xfm, RealInterval interval) {
        if (xfm == null) {
            return new FinalRealInterval(interval);
        }
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] min = new long[nd];
        long[] max = new long[nd];
        Arrays.fill(min, Long.MAX_VALUE);
        Arrays.fill(max, Long.MIN_VALUE);
        long[] unitInterval = new long[nd];
        Arrays.fill(unitInterval, 2L);
        IntervalIterator it = new IntervalIterator(unitInterval);
        while (it.hasNext()) {
            int d;
            it.fwd();
            for (d = 0; d < nd; ++d) {
                pt[d] = it.getLongPosition(d) == 0L ? interval.realMin(d) : interval.realMax(d);
            }
            xfm.apply(pt, ptxfm);
            for (d = 0; d < nd; ++d) {
                long lo = (long)Math.floor(ptxfm[d]);
                long hi = (long)Math.ceil(ptxfm[d]);
                if (lo < min[d]) {
                    min[d] = lo;
                }
                if (hi <= max[d]) continue;
                max[d] = hi;
            }
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval corners(RealTransform xfm, Interval interval) {
        return BoundingBoxEstimation.containingInterval(BoundingBoxEstimation.cornersReal(xfm, (RealInterval)interval));
    }

    public static enum Method {
        CORNERS,
        FACES,
        VOLUME;

    }
}

