/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.Project;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Node;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class Merger {
    public static final void compare(Project p1, Project p2) {
        Utils.log("Be warned: only Treeline, AreaTree and Connector are considered at the moment.");
        LayerSet ls1 = p1.getRootLayerSet();
        LayerSet ls2 = p2.getRootLayerSet();
        final ArrayList<ZDisplayable> zds1 = ls1.getZDisplayables();
        final ArrayList<ZDisplayable> zds2 = ls2.getZDisplayables();
        final HashSet<Class<Connector>> accepted = new HashSet<Class<Connector>>();
        accepted.add(Treeline.class);
        accepted.add(AreaTree.class);
        accepted.add(Connector.class);
        final HashMap<Displayable, List<Change>> matched = new HashMap<Displayable, List<Change>>();
        final HashSet<ZDisplayable> empty1 = new HashSet<ZDisplayable>();
        HashSet<ZDisplayable> empty2 = new HashSet<ZDisplayable>();
        final HashSet<ZDisplayable> unmatched1 = new HashSet<ZDisplayable>();
        final HashSet<ZDisplayable> unmatched2 = new HashSet<ZDisplayable>(zds2);
        Iterator<ZDisplayable> it = unmatched2.iterator();
        while (it.hasNext()) {
            ZDisplayable zd = it.next();
            if (!accepted.contains(zd.getClass())) {
                it.remove();
                continue;
            }
            if (!zd.isDeletable()) continue;
            it.remove();
            empty2.add(zd);
        }
        zds2.removeAll(empty2);
        final AtomicInteger counter = new AtomicInteger(0);
        try {
            Process.unbound(zds1, new TaskFactory<ZDisplayable, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object process(ZDisplayable zd1) {
                    Utils.showProgress((float)counter.getAndIncrement() / (float)zds1.size());
                    if (!accepted.contains(zd1.getClass())) {
                        Utils.log("Ignoring: [A] " + zd1);
                        return null;
                    }
                    if (zd1.isDeletable()) {
                        HashSet hashSet = empty1;
                        synchronized (hashSet) {
                            empty1.add(zd1);
                        }
                        return null;
                    }
                    ArrayList<Change> cs = new ArrayList<Change>();
                    for (ZDisplayable zd2 : zds2) {
                        if (zd1.getClass() != zd2.getClass() || !(zd1 instanceof Tree) || !(zd2 instanceof Tree)) continue;
                        Change c = Merger.compareTrees(zd1, zd2);
                        if (c.hasSimilarNodes()) {
                            Cloneable cloneable;
                            cs.add(c);
                            if (1 == cs.size()) {
                                cloneable = matched;
                                synchronized (cloneable) {
                                    matched.put(zd1, cs);
                                }
                            }
                            cloneable = unmatched2;
                            synchronized (cloneable) {
                                unmatched2.remove(zd2);
                            }
                        }
                        if (zd1.getId() != zd2.getId()) continue;
                        Utils.log("zd1 #" + zd1.getId() + " is similar to #" + zd2.getId() + ": " + c.hasSimilarNodes());
                    }
                    if (cs.isEmpty()) {
                        HashSet hashSet = unmatched1;
                        synchronized (hashSet) {
                            unmatched1.add(zd1);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            IJError.print(e);
        }
        Utils.showProgress(1.0);
        Utils.log("matched.size(): " + matched.size());
        Merger.makeGUI(p1, p2, empty1, empty2, matched, unmatched1, unmatched2);
    }

    private static final HashSet<WNode> asWNodes(Tree<?> tree) {
        HashSet<WNode> col = new HashSet<WNode>();
        for (Node<?> nd : tree.getRoot().getSubtreeNodes()) {
            col.add(new WNode(nd, tree.getAffineTransform()));
        }
        return col;
    }

    public static List<Set<Tag>> compareTags(Node<?> nd1, Node<?> nd2) {
        Set<Tag> tags1 = nd1.getTags();
        Set<Tag> tags2 = nd2.getTags();
        if (null == tags1 && null == tags2) {
            return null;
        }
        HashSet<Tag> common = new HashSet<Tag>();
        if (null != tags1 && null != tags2) {
            common.addAll(tags1);
            common.retainAll(tags2);
        }
        HashSet<Tag> only1 = new HashSet<Tag>();
        if (null != tags1) {
            only1.addAll(tags1);
            if (null != tags2) {
                only1.removeAll(tags2);
            }
        }
        HashSet<Tag> only2 = new HashSet<Tag>();
        if (null != tags2) {
            only2.addAll(tags2);
            if (null != tags1) {
                only2.removeAll(tags1);
            }
        }
        ArrayList<Set<Tag>> t = new ArrayList<Set<Tag>>();
        t.add(common);
        t.add(only1);
        t.add(only2);
        return t;
    }

    private static Change compareTrees(ZDisplayable zd1, ZDisplayable zd2) {
        Tree t1 = (Tree)zd1;
        Tree t2 = (Tree)zd2;
        Change c = new Change(zd1, zd2);
        if (!t1.getTitle().equals(t2.getTitle())) {
            c.title = true;
        }
        if (!t2.getAffineTransform().equals(t2.getAffineTransform())) {
            c.transform = true;
        }
        HashSet<WNode> nds1 = Merger.asWNodes(t1);
        HashMap<WNode, WNode> nds2 = new HashMap<WNode, WNode>();
        for (Node nd : t2.getRoot().getSubtreeNodes()) {
            WNode nn = new WNode(nd, t2.getAffineTransform());
            nds2.put(nn, nn);
        }
        HashSet<WNode> diff = new HashSet<WNode>(nds1);
        diff.removeAll(nds2.keySet());
        c.common_nodes = nds1.size() - diff.size();
        c.n_nodes_d1 = nds1.size();
        c.n_nodes_d2 = nds2.size();
        c.d1_only = c.n_nodes_d1 - c.common_nodes;
        c.d2_only = c.n_nodes_d2 - c.common_nodes;
        c.diff = nds1.size() - nds2.size();
        if (t1.getId() == t2.getId()) {
            Utils.log2("nds1.size(): " + nds1.size() + ", nds2.size(): " + nds2.size() + ", diff.size(): " + diff.size() + ", c.common_nodes: " + c.common_nodes + ", c.diff: " + c.diff);
        }
        if (nds1.size() > 0) {
            c.root = t1.getRoot().equals(t2.getRoot());
        }
        for (WNode nd1 : nds1) {
            List<Set<Tag>> t;
            WNode nd2 = (WNode)nds2.get(nd1);
            if (null == nd2 || null == (t = Merger.compareTags(nd1.nd, nd2.nd))) continue;
            c.common_tags += t.get(0).size();
            c.tags_1_only += t.get(1).size();
            c.tags_2_only += t.get(2).size();
        }
        return c;
    }

    private static void makeGUI(Project p1, Project p2, HashSet<ZDisplayable> empty1, HashSet<ZDisplayable> empty2, HashMap<Displayable, List<Change>> matched, HashSet<ZDisplayable> unmatched1, HashSet<ZDisplayable> unmatched2) {
        final ArrayList<Row> rows = new ArrayList<Row>();
        for (Map.Entry<Displayable, List<Change>> e : matched.entrySet()) {
            for (Change c : e.getValue()) {
                rows.add(new Row(c));
            }
            if (e.getValue().size() <= 1) continue;
            Utils.log("More than one assigned to " + e.getKey());
        }
        JTabbedPane tabs = new JTabbedPane();
        final Table table = new Table();
        tabs.addTab("Matched", new JScrollPane(table));
        JTable tu1 = Merger.createTable(unmatched1, "Unmatched 1", p1, p2);
        JTable tu2 = Merger.createTable(unmatched2, "Unmatched 2", p1, p2);
        JTable tu3 = Merger.createTable(empty1, "Empty 1", p1, p2);
        JTable tu4 = Merger.createTable(empty2, "Empty 2", p1, p2);
        tabs.addTab("Unmatched 1", new JScrollPane(tu1));
        tabs.addTab("Unmatched 2", new JScrollPane(tu2));
        tabs.addTab("Empty 1", new JScrollPane(tu3));
        tabs.addTab("Empty 2", new JScrollPane(tu4));
        for (int i = 0; i < tabs.getTabCount(); ++i) {
            if (null == tabs.getTabComponentAt(i)) {
                Utils.log2("null at " + i);
                continue;
            }
            tabs.getTabComponentAt(i).setPreferredSize(new Dimension(1024, 768));
        }
        String xml1 = new File(((FSLoader)p1.getLoader()).getProjectXMLPath()).getName();
        String xml2 = new File(((FSLoader)p2.getLoader()).getProjectXMLPath()).getName();
        JFrame frame = new JFrame("1: " + xml1 + "  ||  2: " + xml2);
        tabs.setPreferredSize(new Dimension(1024, 768));
        frame.getContentPane().add(tabs);
        frame.pack();
        frame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                table.setModel(new Model(rows));
                CustomCellRenderer cc = new CustomCellRenderer();
                for (int i = 0; i < Row.COLUMNS; ++i) {
                    table.setDefaultRenderer(table.getColumnClass(i), cc);
                }
            }
        });
    }

    private static JTable createTable(HashSet<ZDisplayable> hs, String column_title, final Project p1, final Project p2) {
        final TwoColumnModel tcm = new TwoColumnModel(hs, column_title);
        final JTable table = new JTable(tcm);
        table.setDefaultRenderer(table.getColumnClass(0), new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (1 == column && tcm.sent[row]) {
                    c.setBackground(Color.green);
                    c.setForeground(Color.white);
                } else if (isSelected) {
                    c.setForeground(table.getSelectionForeground());
                    c.setBackground(table.getSelectionBackground());
                } else {
                    c.setBackground(Color.white);
                    c.setForeground(Color.black);
                }
                return c;
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                final JTable src = (JTable)me.getSource();
                final TwoColumnModel model = (TwoColumnModel)src.getModel();
                final int row = src.rowAtPoint(me.getPoint());
                int col = src.columnAtPoint(me.getPoint());
                if (2 == me.getClickCount()) {
                    Object ob = model.getValueAt(row, col);
                    if (ob instanceof ZDisplayable) {
                        ZDisplayable zd = (ZDisplayable)ob;
                        Display df = Display.getOrCreateFront(zd.getProject());
                        df.show(zd.getFirstLayer(), zd, true, false);
                    }
                } else if (me.isPopupTrigger()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem send = new JMenuItem("Send selection");
                    popup.add(send);
                    send.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ArrayList<ZDisplayable> col = new ArrayList<ZDisplayable>();
                            for (int i : src.getSelectedRows()) {
                                col.add((ZDisplayable)model.getValueAt(i, 0));
                            }
                            if (col.isEmpty()) {
                                return;
                            }
                            Project target = ((ZDisplayable)col.get(0)).getProject() == p1 ? p2 : p1;
                            LayerSet ls = target.getRootLayerSet();
                            ArrayList<ZDisplayable> copies = new ArrayList<ZDisplayable>();
                            for (ZDisplayable zd : col) {
                                copies.add((ZDisplayable)zd.clone(target, false));
                                model.sent[row] = true;
                            }
                            ls.addAll(copies);
                            target.getProjectTree().insertSegmentations(copies);
                            model.fireTableDataChanged();
                        }
                    });
                    popup.show(table, me.getX(), me.getY());
                }
            }
        });
        return table;
    }

    private static final class Table
    extends JTable {
        private static final long serialVersionUID = 1L;

        Table() {
            this.setSelectionMode(0);
            this.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (2 != me.getClickCount()) {
                        return;
                    }
                    int viewColumn = this.getColumnModel().getColumnIndexAtX(me.getX());
                    int column = this.convertColumnIndexToModel(viewColumn);
                    if (-1 == column) {
                        return;
                    }
                    ((Model)this.getModel()).sortByColumn(column, me.isShiftDown());
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    int row = this.rowAtPoint(me.getPoint());
                    final Row r = ((Model)this.getModel()).rows.get(row);
                    if (Utils.isPopupTrigger(me)) {
                        JPopupMenu popup = new JPopupMenu();
                        final JMenuItem replace12 = new JMenuItem("Replace 1 with 2");
                        popup.add(replace12);
                        final JMenuItem replace21 = new JMenuItem("Replace 2 with 1");
                        popup.add(replace21);
                        popup.addSeparator();
                        final JMenuItem sibling12 = new JMenuItem("Add 1 as sibling of 2");
                        popup.add(sibling12);
                        final JMenuItem sibling21 = new JMenuItem("Add 2 as sibling of 1");
                        popup.add(sibling21);
                        popup.addSeparator();
                        final JMenuItem select = new JMenuItem("Select each in its own display");
                        popup.add(select);
                        final JMenuItem select2 = new JMenuItem("Select and center each in its own display");
                        popup.add(select2);
                        final JMenuItem show3D = new JMenuItem("Show both in 3D");
                        popup.add(show3D);
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (select == e.getSource()) {
                                    this.select(r.c.d1);
                                    this.select(r.c.d2);
                                } else if (select2 == e.getSource()) {
                                    this.select2(r.c.d1);
                                    this.select2(r.c.d2);
                                } else if (show3D == e.getSource()) {
                                    this.show3D(r.c.d1);
                                    this.show3D(r.c.d2);
                                } else if (replace12 == e.getSource()) {
                                    if (this.replace(r.c.d1, r.c.d2)) {
                                        r.sent();
                                    }
                                } else if (replace21 == e.getSource()) {
                                    if (this.replace(r.c.d2, r.c.d1)) {
                                        r.sent();
                                    }
                                } else if (sibling12 == e.getSource()) {
                                    if (this.addAsSibling(r.c.d2, r.c.d1)) {
                                        r.sent();
                                    }
                                } else if (sibling21 == e.getSource() && this.addAsSibling(r.c.d1, r.c.d2)) {
                                    r.sent();
                                }
                            }
                        };
                        for (JMenuItem item : new JMenuItem[]{select, select2, show3D, replace12, replace21, sibling12, sibling21}) {
                            item.addActionListener(listener);
                        }
                        popup.show(this, me.getX(), me.getY());
                    }
                }
            });
        }

        private void select(ZDisplayable d) {
            Display display = Display.getFront(d.getProject());
            if (null == display) {
                Utils.log("No displays open for project " + d.getProject());
            } else {
                display.select(d);
            }
        }

        private void select2(ZDisplayable d) {
            Display display = Display.getFront(d.getProject());
            if (null == display) {
                Utils.log("No displays open for project " + d.getProject());
            } else {
                Display.showCentered(d.getFirstLayer(), d, true, false);
            }
        }

        private void show3D(Displayable d) {
            Display3D.show(d.getProject().findProjectThing(d));
        }

        private boolean replace(ZDisplayable old, ZDisplayable new_) {
            String xml_old = new File(((FSLoader)old.getProject().getLoader()).getProjectXMLPath()).getName();
            String xml_new = new File(((FSLoader)new_.getProject().getLoader()).getProjectXMLPath()).getName();
            if (!Utils.check("Really replace " + old + " (" + xml_old + ")\nwith " + new_ + " (" + xml_new + ") ?")) {
                return false;
            }
            LayerSet ls = old.getLayerSet();
            ls.addChangeTreesStep();
            this.addCopyAsSibling(old, new_);
            old.getProject().remove(old);
            ls.addChangeTreesStep();
            Utils.log("Replaced " + old + " (from " + xml_old + ")\n    with " + new_ + " (from " + xml_new + ")");
            this.update();
            return true;
        }

        private boolean addAsSibling(ZDisplayable old, ZDisplayable to_copy) {
            LayerSet ls = old.getLayerSet();
            ls.addChangeTreesStep();
            this.addCopyAsSibling(old, to_copy);
            ls.addChangeTreesStep();
            this.update();
            return true;
        }

        private void addCopyAsSibling(ZDisplayable old, ZDisplayable to_copy) {
            ZDisplayable copy = (ZDisplayable)to_copy.clone(old.getProject(), false);
            old.getLayerSet().add(copy);
            old.getProject().getProjectTree().addSibling(old, copy);
        }

        private void update() {
            ((Model)this.getModel()).fireTableDataChanged();
            ((Model)this.getModel()).fireTableStructureChanged();
        }
    }

    private static final class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Row r = ((Model)table.getModel()).rows.get(row);
            if (Row.getSentColumn() == column && r.sent) {
                c.setForeground(Color.white);
                c.setBackground(Color.green);
                return c;
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                c.setForeground(Color.black);
                c.setBackground(r.getColor());
            }
            return c;
        }
    }

    private static final class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        ArrayList<Row> rows;

        Model(ArrayList<Row> rows) {
            this.rows = rows;
        }

        public void sortByColumn(final int column, final boolean descending) {
            final ArrayList<Row> rows = new ArrayList<Row>(this.rows);
            Collections.sort(rows, new Comparator<Row>(){

                @Override
                public final int compare(Row o1, Row o2) {
                    if (descending) {
                        Row tmp = o1;
                        o1 = o2;
                        o2 = tmp;
                    }
                    Object val1 = this.getValueAt(rows.indexOf(o1), column);
                    Object val2 = this.getValueAt(rows.indexOf(o2), column);
                    return val1.compareTo(val2);
                }
            });
            this.rows = rows;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }

        @Override
        public Comparable<?> getValueAt(int row, int col) {
            return this.rows.get(row).getColumn(col);
        }

        @Override
        public int getRowCount() {
            if (null == this.rows) {
                return 0;
            }
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return Row.COLUMNS;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        @Override
        public String getColumnName(int col) {
            return Row.getColumnName(col);
        }
    }

    private static class TwoColumnModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        final List<ZDisplayable> items = new ArrayList<ZDisplayable>();
        final boolean[] sent;

        TwoColumnModel(HashSet<ZDisplayable> ds, String title) {
            this.items.addAll(ds);
            this.sent = new boolean[this.items.size()];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.items.get(row);
                }
                case 1: {
                    return this.sent[row];
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "unmatched";
                }
                case 1: {
                    return "sent";
                }
            }
            return null;
        }
    }

    private static class Row {
        static int COLUMNS = 17;
        Change c;
        boolean sent = false;

        Row(Change c) {
            this.c = c;
        }

        Comparable<?> getColumn(int i) {
            switch (i) {
                case 0: {
                    return this.c.d1.getClass().getSimpleName();
                }
                case 1: {
                    return this.c.d1.getId();
                }
                case 2: {
                    return this.c.d1.getProject().getMeaningfulTitle2(this.c.d1);
                }
                case 3: {
                    return !this.c.title;
                }
                case 4: {
                    return !this.c.transform;
                }
                case 5: {
                    return !this.c.root;
                }
                case 6: {
                    return this.c.common_nodes;
                }
                case 7: {
                    return this.c.d1_only;
                }
                case 8: {
                    return this.c.d2_only;
                }
                case 9: {
                    return this.c.diff;
                }
                case 10: {
                    return this.c.common_tags;
                }
                case 11: {
                    return this.c.tags_1_only;
                }
                case 12: {
                    return this.c.tags_2_only;
                }
                case 13: {
                    return this.c.d2.getId();
                }
                case 14: {
                    return this.c.d2.getProject().getMeaningfulTitle2(this.c.d2);
                }
                case 15: {
                    return this.c.identical();
                }
                case 16: {
                    return this.sent;
                }
            }
            Utils.log("Row.getColumn: Don't know what to do with column " + i);
            return null;
        }

        Color getColor() {
            if (this.c.identical()) {
                return Color.white;
            }
            if (this.c.hasSimilarNodes()) {
                if (this.c.d1_only > 0 && this.c.d2_only > 0) {
                    return Color.magenta;
                }
                if (this.c.d1_only > 0) {
                    return Color.orange;
                }
                if (this.c.d2_only > 0) {
                    return Color.pink;
                }
                if (this.c.tags_1_only > 0 && this.c.tags_2_only > 0) {
                    return Color.magenta;
                }
                if (this.c.tags_1_only > 0) {
                    return Color.orange;
                }
                if (this.c.tags_2_only > 0) {
                    return Color.pink;
                }
            }
            return Color.red.brighter();
        }

        public void sent() {
            this.sent = true;
        }

        private static String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "id 1";
                }
                case 2: {
                    return "title 1";
                }
                case 3: {
                    return "=title?";
                }
                case 4: {
                    return "=affine?";
                }
                case 5: {
                    return "=root?";
                }
                case 6: {
                    return "Nodes common";
                }
                case 7: {
                    return "N 1 only";
                }
                case 8: {
                    return "N 2 only";
                }
                case 9: {
                    return "N diff";
                }
                case 10: {
                    return "Tags common";
                }
                case 11: {
                    return "Tags 1 only tags";
                }
                case 12: {
                    return "Tags 2 only tags";
                }
                case 13: {
                    return "id 2";
                }
                case 14: {
                    return "title 2";
                }
                case 15: {
                    return "Identical?";
                }
                case 16: {
                    return "sent";
                }
            }
            Utils.log("Row.getColumnName: Don't know what to do with column " + col);
            return null;
        }

        private static int getSentColumn() {
            return COLUMNS - 1;
        }
    }

    private static final class WNode {
        final Node<?> nd;
        final float x;
        final float y;
        final double z;

        WNode(Node<?> nd, AffineTransform aff) {
            this.nd = nd;
            float[] f = new float[]{nd.getX(), nd.getY()};
            aff.transform(f, 0, f, 0, 1);
            this.x = f[0];
            this.y = f[1];
            this.z = nd.getLayer().getZ();
        }

        public final int hashCode() {
            return 0;
        }

        public final boolean equals(Object ob) {
            WNode o = (WNode)ob;
            return this.same(this.x, o.x) && this.same(this.y, o.y) && this.same(this.z, o.z);
        }

        private final boolean same(float f1, float f2) {
            return (double)Math.abs(f1 - f2) < 0.01;
        }

        private final boolean same(double f1, double f2) {
            return Math.abs(f1 - f2) < 0.01;
        }
    }

    private static class Change {
        ZDisplayable d1;
        ZDisplayable d2;
        boolean title = false;
        boolean transform = false;
        boolean root = false;
        int diff = 0;
        int common_nodes = 0;
        int d1_only = 0;
        int d2_only = 0;
        int n_nodes_d1 = 0;
        int n_nodes_d2 = 0;
        int common_tags = 0;
        int tags_1_only = 0;
        int tags_2_only = 0;

        Change(ZDisplayable d1, ZDisplayable d2) {
            this.d1 = d1;
            this.d2 = d2;
        }

        boolean identical() {
            return !this.title && !this.transform && !this.root && 0 == this.diff && 0 == this.tags_1_only && 0 == this.tags_2_only && 0 == this.d1_only && 0 == this.d2_only;
        }

        boolean hasSimilarNodes() {
            return this.common_nodes > 0;
        }
    }
}

