/*
 * Decompiled with CFR 0.152.
 */
package mpi.fruitfly.registration;

import ij.ImagePlus;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicInteger;
import mpi.fruitfly.general.ImageArrayConverter;
import mpi.fruitfly.general.MultiThreading;
import mpi.fruitfly.math.General;
import mpi.fruitfly.math.datastructures.FloatArray2D;

public class CrossCorrelation2D {
    public FloatArray2D img1;
    public FloatArray2D img2;
    public boolean showImages = false;
    double maxR = -2.0;
    int displaceX = 0;
    int displaceY = 0;
    final Double regCoef = new Double(-2.0);

    public CrossCorrelation2D(String image1, String image2, boolean showImages) {
        ImagePlus img1 = new Opener().openImage(image1);
        ImagePlus img2 = new Opener().openImage(image2);
        if (showImages) {
            img1.show();
            img2.show();
        }
        ImageProcessor ip1 = img1.getProcessor();
        ImageProcessor ip2 = img2.getProcessor();
        this.img1 = ImageArrayConverter.ImageToFloatArray2D(ip1);
        this.img2 = ImageArrayConverter.ImageToFloatArray2D(ip2);
        this.showImages = showImages;
    }

    public CrossCorrelation2D(ImageProcessor ip1, ImageProcessor ip2, boolean showImages) {
        if (showImages) {
            ImagePlus img1 = new ImagePlus("Image 1", ip1);
            ImagePlus img2 = new ImagePlus("Image 2", ip2);
            img1.show();
            img2.show();
        }
        this.img1 = ImageArrayConverter.ImageToFloatArray2D(ip1);
        this.img2 = ImageArrayConverter.ImageToFloatArray2D(ip2);
        this.showImages = showImages;
    }

    public double[] computeCrossCorrelationMT(double relMinOverlapX, double relMinOverlapY, boolean showImages) {
        final int w1 = this.img1.width;
        final int w2 = this.img2.width;
        final int h1 = this.img1.height;
        final int h2 = this.img2.height;
        final int min_border_w = (int)(w1 < w2 ? (double)w1 * relMinOverlapX + 0.5 : (double)w2 * relMinOverlapX + 0.5);
        final int min_border_h = (int)(h1 < h2 ? (double)h1 * relMinOverlapY + 0.5 : (double)h2 * relMinOverlapY + 0.5);
        final AtomicInteger ai = new AtomicInteger(-w1 + min_border_w);
        Thread[] threads = MultiThreading.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int moveX = ai.getAndIncrement();
                    while (moveX < w2 - min_border_w) {
                        for (int moveY = -h1 + min_border_h; moveY < h2 - min_border_h; ++moveY) {
                            double value2;
                            double value1;
                            double avg1 = 0.0;
                            double avg2 = 0.0;
                            int count = 0;
                            for (int x1 = -General.min(0, moveX); x1 < General.min(w1, w2 - moveX); ++x1) {
                                int x2 = x1 + moveX;
                                for (int y1 = -General.min(0, moveY); y1 < General.min(h1, h2 - moveY); ++y1) {
                                    int y2 = y1 + moveY;
                                    value1 = CrossCorrelation2D.this.img1.get(x1, y1);
                                    if (value1 == -1.0 || (value2 = (double)CrossCorrelation2D.this.img2.get(x2, y2)) == -1.0) continue;
                                    avg1 += value1;
                                    avg2 += value2;
                                    ++count;
                                }
                            }
                            if (0 == count) continue;
                            avg1 /= (double)count;
                            avg2 /= (double)count;
                            double var1 = 0.0;
                            double var2 = 0.0;
                            double coVar = 0.0;
                            for (int x1 = -General.min(0, moveX); x1 < General.min(w1, w2 - moveX); ++x1) {
                                int x2 = x1 + moveX;
                                for (int y1 = -General.min(0, moveY); y1 < General.min(h1, h2 - moveY); ++y1) {
                                    int y2 = y1 + moveY;
                                    value1 = CrossCorrelation2D.this.img1.get(x1, y1);
                                    if (value1 == -1.0 || (value2 = (double)CrossCorrelation2D.this.img2.get(x2, y2)) == -1.0) continue;
                                    double dist1 = value1 - avg1;
                                    double dist2 = value2 - avg2;
                                    coVar += dist1 * dist2;
                                    var1 += dist1 * dist1;
                                    var2 += dist2 * dist2;
                                }
                            }
                            double stDev1 = Math.sqrt(var1 /= (double)count);
                            double stDev2 = Math.sqrt(var2 /= (double)count);
                            double R = (coVar /= (double)count) / (stDev1 * stDev2);
                            CrossCorrelation2D.this.compareAndSetR(R, moveX, moveY);
                            if (!(R < -1.0) && !(R > 1.0)) continue;
                            System.out.println("BIG ERROR! R =" + R);
                        }
                        moveX = ai.getAndIncrement();
                    }
                }
            });
        }
        MultiThreading.startAndJoin(threads);
        if (showImages) {
            System.out.println(-this.displaceX + " " + -this.displaceY + " " + this.maxR);
            FloatArray2D result = ImageArrayConverter.drawTranslatedImages(this.img1, this.img2, new Point(-this.displaceX, -this.displaceY), ImageArrayConverter.DRAWTYPE_OVERLAP);
            ImageArrayConverter.FloatArrayToImagePlus(result, "result", 0.0f, 0.0f).show();
        }
        return new double[]{-this.displaceX, -this.displaceY, this.maxR};
    }

    private synchronized void compareAndSetR(double R, int moveX, int moveY) {
        if (R > this.maxR) {
            this.maxR = R;
            this.displaceX = moveX;
            this.displaceY = moveY;
        }
    }

    @Deprecated
    public double[] computeCrossCorrelation(double relMinOverlapX, double relMinOverlapY, boolean showImages) {
        double maxR = -2.0;
        int displaceX = 0;
        int displaceY = 0;
        int w1 = this.img1.width;
        int w2 = this.img2.width;
        int h1 = this.img1.height;
        int h2 = this.img2.height;
        int min_border_w = (int)(w1 < w2 ? (double)w1 * relMinOverlapX + 0.5 : (double)w2 * relMinOverlapX + 0.5);
        int min_border_h = (int)(h1 < h2 ? (double)h1 * relMinOverlapY + 0.5 : (double)h2 * relMinOverlapY + 0.5);
        for (int moveX = -w1 + min_border_w; moveX < w2 - min_border_w; ++moveX) {
            for (int moveY = -h1 + min_border_h; moveY < h2 - min_border_h; ++moveY) {
                double stDev2;
                double value2;
                double value1;
                double avg1 = 0.0;
                double avg2 = 0.0;
                int count = 0;
                for (int x1 = -General.min(0, moveX); x1 < General.min(w1, w2 - moveX); ++x1) {
                    int x2 = x1 + moveX;
                    for (int y1 = -General.min(0, moveY); y1 < General.min(h1, h2 - moveY); ++y1) {
                        int y2 = y1 + moveY;
                        value1 = this.img1.get(x1, y1);
                        if (value1 == -1.0 || (value2 = (double)this.img2.get(x2, y2)) == -1.0) continue;
                        avg1 += value1;
                        avg2 += value2;
                        ++count;
                    }
                }
                if (0 == count) continue;
                avg1 /= (double)count;
                avg2 /= (double)count;
                double var1 = 0.0;
                double var2 = 0.0;
                double coVar = 0.0;
                for (int x1 = -General.min(0, moveX); x1 < General.min(w1, w2 - moveX); ++x1) {
                    int x2 = x1 + moveX;
                    for (int y1 = -General.min(0, moveY); y1 < General.min(h1, h2 - moveY); ++y1) {
                        int y2 = y1 + moveY;
                        value1 = this.img1.get(x1, y1);
                        if (value1 == -1.0 || (value2 = (double)this.img2.get(x2, y2)) == -1.0) continue;
                        double dist1 = value1 - avg1;
                        double dist2 = value2 - avg2;
                        coVar += dist1 * dist2;
                        var1 += dist1 * dist1;
                        var2 += dist2 * dist2;
                    }
                }
                var1 /= (double)count;
                var2 /= (double)count;
                double stDev1 = Math.sqrt(var1);
                double R = (coVar /= (double)count) / (stDev1 * (stDev2 = Math.sqrt(var2)));
                if (R > maxR) {
                    maxR = R;
                    displaceX = moveX;
                    displaceY = moveY;
                }
                if (!(R < -1.0) && !(R > 1.0)) continue;
                System.out.println("BIG ERROR! R =" + R);
            }
        }
        if (showImages) {
            System.out.println(-displaceX + " " + -displaceY);
            FloatArray2D result = ImageArrayConverter.drawTranslatedImages(this.img1, this.img2, new Point(-displaceX, -displaceY), ImageArrayConverter.DRAWTYPE_OVERLAP);
            ImageArrayConverter.FloatArrayToImagePlus(result, "result", 0.0f, 0.0f).show();
        }
        return new double[]{-displaceX, -displaceY, maxR};
    }
}

