/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.gui.GenericDialog;
import java.io.Serializable;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.trakem2.align.AlignmentUtils;

public class AbstractLayerAlignmentParam
implements Serializable {
    private static final long serialVersionUID = 4186011617208423197L;
    public final AlignmentUtils.ParamPointMatch ppm = new AlignmentUtils.ParamPointMatch();
    public float maxEpsilon;
    public float minInlierRatio;
    public int minNumInliers;
    public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
    public int expectedModelIndex;
    public boolean multipleHypotheses;
    public boolean widestSetOnly;
    public boolean rejectIdentity;
    public float identityTolerance;
    public int maxNumNeighbors;
    public int maxNumFailures;
    public int desiredModelIndex;
    public int maxIterationsOptimize;
    public int maxPlateauwidthOptimize;
    public boolean visualize;
    public int maxNumThreads;

    public boolean setupSIFT(String title) {
        GenericDialog gdSIFT = new GenericDialog(title + "SIFT parameters");
        SIFT.addFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.ppm.sift);
        gdSIFT.addMessage("Local Descriptor Matching:");
        gdSIFT.addNumericField("closest/next_closest_ratio :", (double)this.ppm.rod, 2);
        gdSIFT.addMessage("Miscellaneous:");
        gdSIFT.addCheckbox("clear_cache", this.ppm.clearCache);
        gdSIFT.addNumericField("feature_extraction_threads :", (double)this.ppm.maxNumThreadsSift, 0);
        gdSIFT.showDialog();
        if (gdSIFT.wasCanceled()) {
            return false;
        }
        SIFT.readFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.ppm.sift);
        this.ppm.rod = (float)gdSIFT.getNextNumber();
        this.ppm.clearCache = gdSIFT.getNextBoolean();
        this.ppm.maxNumThreadsSift = (int)gdSIFT.getNextNumber();
        return true;
    }

    public AbstractLayerAlignmentParam() {
        this.ppm.sift.fdSize = 8;
        this.maxEpsilon = 200.0f;
        this.minInlierRatio = 0.0f;
        this.minNumInliers = 12;
        this.expectedModelIndex = 3;
        this.multipleHypotheses = false;
        this.widestSetOnly = false;
        this.rejectIdentity = false;
        this.identityTolerance = 5.0f;
        this.maxNumNeighbors = 1;
        this.maxNumFailures = 3;
        this.desiredModelIndex = 1;
        this.maxIterationsOptimize = 1000;
        this.maxPlateauwidthOptimize = 200;
        this.visualize = false;
        this.maxNumThreads = Runtime.getRuntime().availableProcessors();
    }

    public AbstractLayerAlignmentParam(int SIFTfdBins, int SIFTfdSize, float SIFTinitialSigma, int SIFTmaxOctaveSize, int SIFTminOctaveSize, int SIFTsteps, boolean clearCache, int maxNumThreadsSift, float rod, int desiredModelIndex, int expectedModelIndex, float identityTolerance, float maxEpsilon, int maxIterationsOptimize, int maxNumFailures, int maxNumNeighbors, int maxNumThreads, int maxPlateauwidthOptimize, float minInlierRatio, int minNumInliers, boolean multipleHypotheses, boolean widestSetOnly, boolean rejectIdentity, boolean visualize) {
        this.ppm.sift.fdSize = 8;
        this.maxEpsilon = 200.0f;
        this.minInlierRatio = 0.0f;
        this.minNumInliers = 12;
        this.expectedModelIndex = 3;
        this.multipleHypotheses = false;
        this.widestSetOnly = false;
        this.rejectIdentity = false;
        this.identityTolerance = 5.0f;
        this.maxNumNeighbors = 1;
        this.maxNumFailures = 3;
        this.desiredModelIndex = 1;
        this.maxIterationsOptimize = 1000;
        this.maxPlateauwidthOptimize = 200;
        this.visualize = false;
        this.maxNumThreads = Runtime.getRuntime().availableProcessors();
        this.ppm.sift.fdBins = SIFTfdBins;
        this.ppm.sift.fdSize = SIFTfdSize;
        this.ppm.sift.initialSigma = SIFTinitialSigma;
        this.ppm.sift.maxOctaveSize = SIFTmaxOctaveSize;
        this.ppm.sift.minOctaveSize = SIFTminOctaveSize;
        this.ppm.sift.steps = SIFTsteps;
        this.ppm.clearCache = clearCache;
        this.ppm.maxNumThreadsSift = maxNumThreadsSift;
        this.ppm.rod = rod;
        this.desiredModelIndex = desiredModelIndex;
        this.expectedModelIndex = expectedModelIndex;
        this.identityTolerance = identityTolerance;
        this.maxEpsilon = maxEpsilon;
        this.maxIterationsOptimize = maxIterationsOptimize;
        this.maxNumFailures = maxNumFailures;
        this.maxNumNeighbors = maxNumNeighbors;
        this.maxNumThreads = maxNumThreads;
        this.maxPlateauwidthOptimize = maxPlateauwidthOptimize;
        this.minInlierRatio = minInlierRatio;
        this.minNumInliers = minNumInliers;
        this.multipleHypotheses = multipleHypotheses;
        this.widestSetOnly = widestSetOnly;
        this.rejectIdentity = rejectIdentity;
        this.visualize = visualize;
    }

    public AbstractLayerAlignmentParam clone() {
        return new AbstractLayerAlignmentParam(this.ppm.sift.fdBins, this.ppm.sift.fdSize, this.ppm.sift.initialSigma, this.ppm.sift.maxOctaveSize, this.ppm.sift.minOctaveSize, this.ppm.sift.steps, this.ppm.clearCache, this.ppm.maxNumThreadsSift, this.ppm.rod, this.desiredModelIndex, this.expectedModelIndex, this.identityTolerance, this.maxEpsilon, this.maxIterationsOptimize, this.maxNumFailures, this.maxNumNeighbors, this.maxNumThreads, this.maxPlateauwidthOptimize, this.minInlierRatio, this.minNumInliers, this.multipleHypotheses, this.widestSetOnly, this.rejectIdentity, this.visualize);
    }
}

