/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import java.io.IOException;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.transform.Transform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.TransformView;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.visitor.CSVVisitor;
import org.janelia.thickness.lut.PermutationTransform;

public class PermutedLUTVisitor
extends CSVVisitor {
    public PermutedLUTVisitor(String basePath, String relativePattern, String separator) {
        super(basePath, relativePattern, separator);
    }

    @Override
    public <T extends RealType<T>> void act(int iteration, RandomAccessibleInterval<T> matrix, RandomAccessibleInterval<T> scaledMatrix, double[] lut, int[] permutation, int[] inversePermutation, double[] multipliers, RandomAccessibleInterval<double[]> estimatedFit) {
        ArrayImg coordinateImage = ArrayImgs.doubles((double[])lut, (long[])new long[]{lut.length});
        PermutationTransform transform = new PermutationTransform(permutation, 1, 1);
        IntervalView permuted = Views.interval((RandomAccessible)new TransformView((RandomAccessible)coordinateImage, (Transform)transform), (Interval)coordinateImage);
        try {
            String path = this.fileDir(iteration);
            this.createParentDirectory(path);
            this.write(new CSVVisitor.IndexedIterable(this.separator, permuted), path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

