/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

public class FinalVoxelDimensions {
    private final String unit;
    private final double[] dimensions;

    public FinalVoxelDimensions(String unit, double ... dimensions) {
        this.unit = unit;
        this.dimensions = (double[])dimensions.clone();
    }

    public int numDimensions() {
        return this.dimensions.length;
    }

    public String unit() {
        return this.unit;
    }

    public void dimensions(double[] dims) {
        for (int d = 0; d < dims.length; ++d) {
            dims[d] = this.dimensions[d];
        }
    }

    public double dimension(int d) {
        return this.dimensions[d];
    }

    public static boolean equals(FinalVoxelDimensions a, FinalVoxelDimensions b) {
        if (!a.unit().equals(b.unit())) {
            return false;
        }
        double eps = 1.0E-9;
        for (int i = 0; i < a.numDimensions(); ++i) {
            if (!(Math.abs(a.dimension(i) - b.dimension(i)) > 1.0E-9)) continue;
            return false;
        }
        return true;
    }
}

