/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.Mode;
import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.awt.ModeMenuItem;
import edu.mines.jtk.awt.ModeToggleButton;
import edu.mines.jtk.dsp.Real1;
import edu.mines.jtk.dsp.RecursiveCascadeFilter;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.SequenceView;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileZoomMode;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Cdouble;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PolesAndZerosDemo {
    private static final int PZP_X = 100;
    private static final int PZP_Y = 0;
    private static final int PZP_WIDTH = 520;
    private static final int PZP_HEIGHT = 550;
    private static final int RP_X = 620;
    private static final int RP_Y = 0;
    private static final int RP_WIDTH = 500;
    private static final int RP_HEIGHT = 700;
    private ArrayList<Cdouble> _poles = new ArrayList(0);
    private ArrayList<Cdouble> _zeros = new ArrayList(0);
    private PoleZeroPlot _pzp = new PoleZeroPlot();
    private ResponsePlot _rp = new ResponsePlot(false);

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PolesAndZerosDemo();
            }
        });
    }

    private PolesAndZerosDemo() {
    }

    private void addPole(Cdouble pole) {
        this._poles.add(new Cdouble(pole));
        if (!pole.isReal()) {
            this._poles.add(pole.conj());
        }
        this._pzp.updatePolesView();
        this._rp.updateViews();
    }

    private void removePole(Cdouble pole) {
        this._poles.remove(pole);
        if (!pole.isReal()) {
            this._poles.remove(pole.conj());
        }
        this._pzp.updatePolesView();
        this._rp.updateViews();
    }

    private void movePole(Cdouble poleOld, Cdouble poleNew) {
        this._poles.remove(poleOld);
        if (!poleOld.isReal()) {
            this._poles.remove(poleOld.conj());
        }
        this._poles.add(poleNew);
        if (!poleNew.isReal()) {
            this._poles.add(poleNew.conj());
        }
        this._pzp.updatePolesView();
        this._rp.updateViews();
    }

    private Cdouble getPoleNearest(Cdouble z) {
        Cdouble pmin = null;
        double dmin = 0.0;
        for (Cdouble p : this._poles) {
            double d = p.minus(z).abs();
            if (pmin != null && !(d < dmin)) continue;
            pmin = p;
            dmin = d;
        }
        return pmin;
    }

    private void addZero(Cdouble zero) {
        this._zeros.add(new Cdouble(zero));
        if (!zero.isReal()) {
            this._zeros.add(zero.conj());
        }
        this._pzp.updateZerosView();
        this._rp.updateViews();
    }

    private void removeZero(Cdouble zero) {
        this._zeros.remove(zero);
        if (!zero.isReal()) {
            this._zeros.remove(zero.conj());
        }
        this._pzp.updateZerosView();
        this._rp.updateViews();
    }

    private void moveZero(Cdouble zeroOld, Cdouble zeroNew) {
        this._zeros.remove(zeroOld);
        if (!zeroOld.isReal()) {
            this._zeros.remove(zeroOld.conj());
        }
        this._zeros.add(zeroNew);
        if (!zeroNew.isReal()) {
            this._zeros.add(zeroNew.conj());
        }
        this._pzp.updateZerosView();
        this._rp.updateViews();
    }

    private Cdouble getZeroNearest(Cdouble z) {
        Cdouble pmin = null;
        double dmin = 0.0;
        for (Cdouble p : this._zeros) {
            double d = p.minus(z).abs();
            if (pmin != null && !(d < dmin)) continue;
            pmin = p;
            dmin = d;
        }
        return pmin;
    }

    private class SaveAsPngAction
    extends AbstractAction {
        private PlotFrame _plotFrame;

        private SaveAsPngAction(PlotFrame plotFrame) {
            super("Save as PNG");
            this._plotFrame = plotFrame;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
            fc.showSaveDialog(this._plotFrame);
            File file = fc.getSelectedFile();
            if (file != null) {
                String filename = file.getAbsolutePath();
                this._plotFrame.paintToPng(300.0, 6.0, filename);
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        private ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class PoleZeroMode
    extends Mode {
        private boolean _poles;
        private Cdouble _zedit;
        private boolean _editing;
        private Tile _tile;
        private MouseListener _ml;
        private MouseMotionListener _mml;

        public PoleZeroMode(ModeManager modeManager, boolean forPoles) {
            super(modeManager);
            this._ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isShiftDown()) {
                        PoleZeroMode.this.add(e);
                    } else if (e.isControlDown()) {
                        PoleZeroMode.this.remove(e);
                    } else if (PoleZeroMode.this.beginEdit(e)) {
                        PoleZeroMode.this._editing = true;
                        PoleZeroMode.this._tile.addMouseMotionListener(PoleZeroMode.this._mml);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (PoleZeroMode.this._editing) {
                        PoleZeroMode.this._tile.removeMouseMotionListener(PoleZeroMode.this._mml);
                        PoleZeroMode.this.endEdit(e);
                        PoleZeroMode.this._editing = false;
                    }
                }
            };
            this._mml = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (PoleZeroMode.this._editing) {
                        PoleZeroMode.this.duringEdit(e);
                    }
                }
            };
            if (forPoles) {
                this._poles = true;
                this.setName("Poles");
                this.setIcon(PoleZeroMode.loadIcon(PolesAndZerosDemo.class, "Poles16.png"));
                this.setMnemonicKey(88);
                this.setAcceleratorKey(KeyStroke.getKeyStroke(88, 0));
                this.setShortDescription("Add (Shift), remove (Ctrl), or drag poles");
            } else {
                this.setName("Zeros");
                this.setIcon(PoleZeroMode.loadIcon(PolesAndZerosDemo.class, "Zeros16.png"));
                this.setMnemonicKey(48);
                this.setAcceleratorKey(KeyStroke.getKeyStroke(48, 0));
                this.setShortDescription("Add (Shift), remove (Ctrl), or drag zeros");
            }
        }

        @Override
        protected void setActive(Component component, boolean active) {
            if (component instanceof Tile) {
                if (active) {
                    component.addMouseListener(this._ml);
                } else {
                    component.removeMouseListener(this._ml);
                }
            }
        }

        private Cdouble pointToComplex(int x, int y) {
            Transcaler ts = this._tile.getTranscaler();
            Projector hp = this._tile.getHorizontalProjector();
            Projector vp = this._tile.getVerticalProjector();
            double xu = ts.x(x);
            double yu = ts.y(y);
            double xv = hp.v(xu);
            double yv = vp.v(yu);
            return this.roundToReal(new Cdouble(xv, yv));
        }

        private Point complexToPoint(Cdouble z) {
            Transcaler ts = this._tile.getTranscaler();
            Projector hp = this._tile.getHorizontalProjector();
            Projector vp = this._tile.getVerticalProjector();
            double xu = hp.u(z.r);
            double yu = vp.u(z.i);
            int xp = ts.x(xu);
            int yp = ts.y(yu);
            return new Point(xp, yp);
        }

        private Cdouble roundToReal(Cdouble c) {
            Cdouble cr = new Cdouble(c.r, 0.0);
            Point pr = this.complexToPoint(cr);
            Point p = this.complexToPoint(c);
            return ArrayMath.abs(p.y - pr.y) < 6 ? cr : c;
        }

        private boolean closeEnough(int x, int y, Cdouble c) {
            Point p = this.complexToPoint(c);
            return ArrayMath.abs(p.x - x) < 6 && ArrayMath.abs(p.y - y) < 6;
        }

        private void add(MouseEvent e) {
            this._tile = (Tile)e.getSource();
            int x = e.getX();
            int y = e.getY();
            Cdouble z = this.pointToComplex(x, y);
            if (this._poles) {
                PolesAndZerosDemo.this.addPole(z);
            } else {
                PolesAndZerosDemo.this.addZero(z);
            }
        }

        private void remove(MouseEvent e) {
            this._tile = (Tile)e.getSource();
            int x = e.getX();
            int y = e.getY();
            Cdouble z = this.pointToComplex(x, y);
            if (this._poles) {
                Cdouble pole = PolesAndZerosDemo.this.getPoleNearest(z);
                if (pole != null && this.closeEnough(x, y, pole)) {
                    PolesAndZerosDemo.this.removePole(pole);
                }
            } else {
                Cdouble zero = PolesAndZerosDemo.this.getZeroNearest(z);
                if (zero != null && this.closeEnough(x, y, zero)) {
                    PolesAndZerosDemo.this.removeZero(zero);
                }
            }
        }

        private boolean beginEdit(MouseEvent e) {
            this._tile = (Tile)e.getSource();
            int x = e.getX();
            int y = e.getY();
            Cdouble z = this.pointToComplex(x, y);
            if (this._poles) {
                Cdouble pole = PolesAndZerosDemo.this.getPoleNearest(z);
                if (pole != null && this.closeEnough(x, y, pole)) {
                    PolesAndZerosDemo.this.movePole(pole, z);
                    this._zedit = z;
                    return true;
                }
            } else {
                Cdouble zero = PolesAndZerosDemo.this.getZeroNearest(z);
                if (zero != null && this.closeEnough(x, y, zero)) {
                    PolesAndZerosDemo.this.moveZero(zero, z);
                    this._zedit = z;
                    return true;
                }
            }
            return false;
        }

        private void duringEdit(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Cdouble z = this.pointToComplex(x, y);
            if (this._poles) {
                PolesAndZerosDemo.this.movePole(this._zedit, z);
            } else {
                PolesAndZerosDemo.this.moveZero(this._zedit, z);
            }
            this._zedit = z;
        }

        private void endEdit(MouseEvent e) {
            this.duringEdit(e);
            this._editing = false;
        }
    }

    private class ResponsePlot {
        private boolean _db;
        private PlotPanel _plotPanelH;
        private PlotPanel _plotPanelAP;
        private PlotFrame _plotFrame;
        private SequenceView _hView;
        private PointsView _aView;
        private PointsView _pView;

        private ResponsePlot(boolean db) {
            this._db = db;
            this._plotPanelH = new PlotPanel();
            this._plotPanelH.setHLabel("sample index");
            this._plotPanelH.setVLabel("amplitude");
            this._plotPanelH.setTitle("impulse response");
            this._plotPanelAP = new PlotPanel(2, 1);
            this._plotPanelAP.setTitle("amplitude and phase response");
            if (this._db) {
                this._plotPanelAP.setVLabel(0, "amplitude (dB)");
            } else {
                this._plotPanelAP.setVLabel(0, "amplitude");
            }
            this._plotPanelAP.setVLimits(1, -0.5, 0.5);
            this._plotPanelAP.setVLabel(1, "phase (cycles)");
            this._plotPanelAP.setHLabel("frequency (cycles/sample)");
            this.updateViews();
            this._plotFrame = new PlotFrame(this._plotPanelH, this._plotPanelAP, PlotFrame.Split.VERTICAL);
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic('F');
            fileMenu.add(new SaveAsPngAction(this._plotFrame)).setMnemonic('a');
            fileMenu.add(new ExitAction()).setMnemonic('x');
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(fileMenu);
            this._plotFrame.setJMenuBar(menuBar);
            this._plotFrame.setDefaultCloseOperation(3);
            this._plotFrame.setLocation(620, 0);
            this._plotFrame.setSize(500, 700);
            this._plotFrame.setFontSizeForPrint(8.0, 240.0);
            this._plotFrame.setVisible(true);
        }

        private void updateViews() {
            Real1 h = this.computeImpulseResponse();
            Real1[] ap = this.computeAmplitudeAndPhaseResponses();
            Real1 a = ap[0];
            Real1 p = ap[1];
            if (this._hView == null) {
                this._hView = this._plotPanelH.addSequence(h.getSampling(), h.getValues());
                this._aView = this._plotPanelAP.addPoints(0, 0, a.getSampling(), a.getValues());
                this._pView = this._plotPanelAP.addPoints(1, 0, p.getSampling(), p.getValues());
            } else {
                this._hView.set(h.getSampling(), h.getValues());
                this._aView.set(a.getSampling(), a.getValues());
                this._pView.set(p.getSampling(), p.getValues());
            }
        }

        private Real1 computeImpulseResponse() {
            int np = PolesAndZerosDemo.this._poles.size();
            int nz = PolesAndZerosDemo.this._zeros.size();
            Cdouble[] poles = new Cdouble[np];
            Cdouble[] zeros = new Cdouble[nz];
            PolesAndZerosDemo.this._poles.toArray(poles);
            PolesAndZerosDemo.this._zeros.toArray(zeros);
            int n = 101;
            float[] h = new float[n];
            if (np > 0 || nz > 0) {
                float[] impulse = new float[n];
                impulse[0] = 1.0f;
                RecursiveCascadeFilter f = new RecursiveCascadeFilter(poles, zeros, 1.0);
                f.applyForward(impulse, h);
            } else {
                h[0] = 1.0f;
            }
            Sampling s = new Sampling(n);
            return new Real1(s, h);
        }

        private Real1[] computeAmplitudeAndPhaseResponses() {
            int nf = 501;
            double df = 0.5 / (double)(nf - 1);
            double ff = 0.0;
            Sampling sf = new Sampling(nf, df, ff);
            float[] af = new float[nf];
            float[] pf = new float[nf];
            for (int jf = 0; jf < nf; ++jf) {
                double f = ff + (double)jf * df;
                Cdouble cone = new Cdouble(1.0, 0.0);
                Cdouble zinv = Cdouble.polar(1.0, Math.PI * -2 * f);
                Cdouble p = new Cdouble(1.0, 0.0);
                for (Cdouble c : PolesAndZerosDemo.this._zeros) {
                    p.timesEquals(cone.minus(c.times(zinv)));
                }
                Cdouble q = new Cdouble(1.0, 0.0);
                for (Cdouble d : PolesAndZerosDemo.this._poles) {
                    q.timesEquals(cone.minus(d.times(zinv)));
                }
                Cdouble h = p.over(q);
                af[jf] = (float)h.abs();
                pf[jf] = (float)h.arg();
            }
            if (this._db) {
                af = ArrayMath.log10(af);
                af = ArrayMath.mul(20.0f, af);
            }
            Real1 a = new Real1(sf, af);
            pf = ArrayMath.mul(0.15915494f, pf);
            Real1 p = new Real1(sf, pf);
            return new Real1[]{a, p};
        }
    }

    private class PoleZeroPlot {
        private PlotFrame _plotFrame;
        private PlotPanel _plotPanel = new PlotPanel();
        private PointsView _polesView;
        private PointsView _zerosView;
        private PointsView _circleView;

        private PoleZeroPlot() {
            this._plotPanel.setTitle("poles and zeros");
            this._plotPanel.setHLabel("real");
            this._plotPanel.setVLabel("imaginary");
            this._plotPanel.setHLimits(-2.0, 2.0);
            this._plotPanel.setVLimits(-2.0, 2.0);
            this._plotPanel.addGrid("H0-V0-");
            float[][] circlePoints = this.makeCirclePoints();
            this._circleView = this._plotPanel.addPoints(circlePoints[0], circlePoints[1]);
            this._circleView.setLineColor(Color.RED);
            this.updatePolesView();
            this.updateZerosView();
            this._plotFrame = new PlotFrame(this._plotPanel);
            TileZoomMode tzm = this._plotFrame.getTileZoomMode();
            ModeManager mm = this._plotFrame.getModeManager();
            PoleZeroMode pm = new PoleZeroMode(mm, true);
            PoleZeroMode zm = new PoleZeroMode(mm, false);
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic('F');
            fileMenu.add(new SaveAsPngAction(this._plotFrame)).setMnemonic('a');
            fileMenu.add(new ExitAction()).setMnemonic('x');
            JMenu modeMenu = new JMenu("Mode");
            modeMenu.setMnemonic('M');
            modeMenu.add(new ModeMenuItem(tzm));
            modeMenu.add(new ModeMenuItem(pm));
            modeMenu.add(new ModeMenuItem(zm));
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(fileMenu);
            menuBar.add(modeMenu);
            this._plotFrame.setJMenuBar(menuBar);
            JToolBar toolBar = new JToolBar(1);
            toolBar.setRollover(true);
            toolBar.add(new ModeToggleButton(tzm));
            toolBar.add(new ModeToggleButton(pm));
            toolBar.add(new ModeToggleButton(zm));
            this._plotFrame.add((Component)toolBar, "West");
            pm.setActive(true);
            this._plotFrame.setDefaultCloseOperation(3);
            this._plotFrame.setLocation(100, 0);
            this._plotFrame.setSize(520, 550);
            this._plotFrame.setFontSizeForPrint(8.0, 240.0);
            this._plotFrame.setVisible(true);
        }

        private void updatePolesView() {
            int np = PolesAndZerosDemo.this._poles.size();
            float[] xp = new float[np];
            float[] yp = new float[np];
            for (int ip = 0; ip < np; ++ip) {
                Cdouble p = (Cdouble)PolesAndZerosDemo.this._poles.get(ip);
                xp[ip] = (float)p.r;
                yp[ip] = (float)p.i;
            }
            if (this._polesView == null) {
                this._polesView = this._plotPanel.addPoints(xp, yp);
                this._polesView.setMarkStyle(PointsView.Mark.CROSS);
                this._polesView.setLineStyle(PointsView.Line.NONE);
            } else {
                this._polesView.set(xp, yp);
            }
        }

        private void updateZerosView() {
            int nz = PolesAndZerosDemo.this._zeros.size();
            float[] xz = new float[nz];
            float[] yz = new float[nz];
            for (int iz = 0; iz < nz; ++iz) {
                Cdouble z = (Cdouble)PolesAndZerosDemo.this._zeros.get(iz);
                xz[iz] = (float)z.r;
                yz[iz] = (float)z.i;
            }
            if (this._zerosView == null) {
                this._zerosView = this._plotPanel.addPoints(xz, yz);
                this._zerosView.setMarkStyle(PointsView.Mark.HOLLOW_CIRCLE);
                this._zerosView.setLineStyle(PointsView.Line.NONE);
            } else {
                this._zerosView.set(xz, yz);
            }
        }

        private float[][] makeCirclePoints() {
            int nt = 1000;
            double dt = Math.PI * 2 / (double)(nt - 1);
            float[] x = new float[nt];
            float[] y = new float[nt];
            for (int it = 0; it < nt; ++it) {
                float t = (float)((double)it * dt);
                x[it] = ArrayMath.cos(t);
                y[it] = ArrayMath.sin(t);
            }
            return new float[][]{x, y};
        }
    }
}

