/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Quadratic;
import edu.mines.jtk.opt.Transform;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class TransformQuadratic
implements Quadratic {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private VectConst _data;
    private VectConst _referenceModel;
    private VectConst _perturbModel;
    private Transform _transform;
    private boolean _dampOnlyPerturbation = false;

    public TransformQuadratic(VectConst data, VectConst referenceModel, VectConst perturbModel, Transform transform, boolean dampOnlyPerturbation) {
        this._data = data;
        this._referenceModel = referenceModel;
        this._perturbModel = perturbModel;
        this._transform = transform;
        this._dampOnlyPerturbation = dampOnlyPerturbation;
    }

    public int getTransposePrecision() {
        VectConst d = this._data;
        Vect b = this.getB();
        double bb = b.dot(b);
        TransformQuadratic.checkNaN(bb);
        assert (!Almost.FLOAT.zero(bb)) : "Cannot test with zero-magnitude b";
        Vect Fb = VectUtil.cloneZero(d);
        Vect bSave = b.clone();
        this._transform.forwardLinearized(Fb, b, this._referenceModel);
        assert (VectUtil.areSame(b, bSave)) : "model was changed by forward model";
        bSave.dispose();
        Vect test = d.clone();
        this._transform.forwardLinearized(test, b, this._referenceModel);
        assert (VectUtil.areSame(test, Fb)) : "forwardLinearized should zero data";
        test.dispose();
        Vect Ad = VectUtil.cloneZero(b);
        Vect dSave = d.clone();
        this._transform.addTranspose(d, Ad, this._referenceModel);
        double transposeMagnitude = Ad.dot(Ad);
        TransformQuadratic.checkNaN(transposeMagnitude);
        assert (VectUtil.areSame(d, dSave)) : "data was changed by transpose";
        dSave.dispose();
        test = b.clone();
        double scaleTest = 1.1 * Math.sqrt(transposeMagnitude / bb);
        VectUtil.scale(test, scaleTest);
        this._transform.addTranspose(d, test, this._referenceModel);
        assert (!VectUtil.areSame(Ad, test)) : "Transpose should not zero model.  Magnitude: b=" + bb + "trans=" + transposeMagnitude + " test=" + test.dot(test);
        test.add(1.0, -1.0, Ad);
        VectUtil.scale(test, 1.0 / scaleTest);
        assert (VectUtil.areSame(test, b)) : "Transpose did not add to model vector";
        test.dispose();
        double dFb = d.dot(Fb);
        double Adb = Ad.dot(b);
        assert (!Almost.FLOAT.zero(dFb)) : "zero magnitude test: dFb is zero";
        assert (!Almost.FLOAT.zero(Adb)) : "zero magnitude test: Adb is zero";
        TransformQuadratic.checkNaN(dFb);
        TransformQuadratic.checkNaN(Adb);
        int significantDigits = 10;
        boolean matches = false;
        while (!matches && significantDigits > 0) {
            Almost almost = new Almost(significantDigits);
            matches = almost.equal(dFb, Adb);
            if (matches) continue;
            --significantDigits;
        }
        if (significantDigits < 3) {
            LOG.severe("Transpose precision is unacceptable: dFb=" + dFb + " Adb=" + Adb);
        }
        Ad.dispose();
        Fb.dispose();
        b.dispose();
        return significantDigits;
    }

    @Override
    public void multiplyHessian(Vect x) {
        Vect data = this._data.clone();
        this._transform.forwardLinearized(data, x, this._referenceModel);
        data.multiplyInverseCovariance();
        x.multiplyInverseCovariance();
        this._transform.addTranspose(data, x, this._referenceModel);
        data.dispose();
    }

    @Override
    public void inverseHessian(Vect x) {
        this._transform.inverseHessian(x, this._referenceModel);
    }

    @Override
    public Vect getB() {
        Vect b;
        Vect data = VectUtil.cloneZero(this._data);
        this._transform.forwardNonlinear(data, this._referenceModel);
        data.add(1.0, -1.0, this._data);
        this._transform.adjustRobustErrors(data);
        data.multiplyInverseCovariance();
        if (this._dampOnlyPerturbation) {
            b = this._perturbModel != null ? VectUtil.cloneZero(this._perturbModel) : VectUtil.cloneZero(this._referenceModel);
        } else {
            if (this._perturbModel != null) {
                b = this._perturbModel.clone();
                b.project(0.0, 1.0, this._referenceModel);
            } else {
                b = this._referenceModel.clone();
            }
            b.multiplyInverseCovariance();
        }
        this._transform.addTranspose(data, b, this._referenceModel);
        data.dispose();
        return b;
    }

    public double evalFullObjectiveFunction(VectConst m) {
        Vect data = VectUtil.cloneZero(this._data);
        Vect model = m.clone();
        model.constrain();
        this._transform.forwardNonlinear(data, model);
        data.add(1.0, -1.0, this._data);
        this._transform.adjustRobustErrors(data);
        double eNe = data.magnitude();
        TransformQuadratic.checkNaN(eNe);
        data.dispose();
        if (this._dampOnlyPerturbation) {
            model.add(1.0, -1.0, this._referenceModel);
        }
        double mMm = model.magnitude();
        TransformQuadratic.checkNaN(mMm);
        model.dispose();
        return eNe + mMm;
    }

    private static void checkNaN(double value) {
        if (value * 0.0 != 0.0) {
            throw new IllegalStateException("Value is a NaN");
        }
    }

    public void dispose() {
    }
}

