/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.ogl.GlCanvas;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.util.Direct;
import java.nio.FloatBuffer;

public class ViewCanvas
extends GlCanvas {
    private static final long serialVersionUID = 1L;
    private View _view;
    private Matrix44 _viewToCube = Matrix44.identity();
    private Matrix44 _cubeToPixel = Matrix44.identity();

    public ViewCanvas() {
    }

    public ViewCanvas(View view) {
        this.setView(view);
    }

    public void setView(View view) {
        if (this._view != null) {
            this._view.removeCanvas(this);
        }
        this._view = view;
        if (this._view != null) {
            this._view.addCanvas(this);
            this._view.updateTransforms();
            this._view.repaint();
        }
    }

    public View getView() {
        return this._view;
    }

    public void setViewToCube(Matrix44 viewToCube) {
        this._viewToCube = new Matrix44(viewToCube);
        this.repaint();
    }

    public Matrix44 getViewToCube() {
        return new Matrix44(this._viewToCube);
    }

    public void setCubeToPixel(Matrix44 cubeToPixel) {
        this._cubeToPixel = new Matrix44(cubeToPixel);
        this.repaint();
    }

    public Matrix44 getCubeToPixel() {
        return new Matrix44(this._cubeToPixel);
    }

    public double getPixelZ(final int xp, final int yp) {
        final int hp = this.getHeight();
        final FloatBuffer pixels = Direct.newFloatBuffer(1);
        this.runWithContext(new Runnable(){

            @Override
            public void run() {
                Gl.glPushAttrib(32);
                Gl.glReadBuffer(1028);
                Gl.glReadPixels(xp, hp - 1 - yp, 1, 1, 6402, 5126, pixels);
                Gl.glPopAttrib();
            }
        });
        return pixels.get(0);
    }

    @Override
    public void glInit() {
        Gl.setSwapInterval(1);
    }

    @Override
    public void glPaint() {
        if (this._view != null) {
            this._view.draw(this);
        }
    }

    @Override
    public void glResize(int width, int height, int widthBefore, int heightBefore) {
        if (this._view != null) {
            this._view.updateTransforms(this);
        }
    }
}

