/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.UnitSphereSampling;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnitSphereSamplingTest
extends TestCase {
    private static Random _random = new Random();

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(UnitSphereSamplingTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSymmetry() {
        UnitSphereSamplingTest.testSymmetry(8);
        UnitSphereSamplingTest.testSymmetry(16);
    }

    public void testInterpolation() {
        UnitSphereSamplingTest.testInterpolation(16, 1.0E-4f);
    }

    public void testTriangle() {
        UnitSphereSamplingTest.testTriangle(8);
        UnitSphereSamplingTest.testTriangle(16);
    }

    public void testTriangle1() {
        float[] p = new float[]{-0.82179755f, 0.56977963f, 0.0f};
        UnitSphereSampling uss = new UnitSphereSampling(16);
        int i = uss.getIndex(p);
        int[] abc = uss.getTriangle(p);
        int ia = abc[0];
        int ib = abc[1];
        int ic = abc[2];
        UnitSphereSamplingTest.assertTrue((i == ia || i == ib || i == ic ? 1 : 0) != 0);
    }

    public void testWeights() {
        UnitSphereSamplingTest.testWeights(8);
        UnitSphereSamplingTest.testWeights(16);
    }

    public void testMaxError() {
        UnitSphereSamplingTest.testMaxError(16, 1.0f);
    }

    private static void testSymmetry(int nbits) {
        float[] q;
        float[] p;
        UnitSphereSampling uss = new UnitSphereSampling(nbits);
        int mi = uss.getMaxIndex();
        int i = 1;
        int j = -i;
        while (i <= mi) {
            p = uss.getPoint(i);
            q = uss.getPoint(j);
            UnitSphereSamplingTest.assertEquals((double)p[0], (double)(-q[0]), (double)0.0);
            UnitSphereSamplingTest.assertEquals((double)p[1], (double)(-q[1]), (double)0.0);
            UnitSphereSamplingTest.assertEquals((double)p[2], (double)(-q[2]), (double)0.0);
            j = -(++i);
        }
        int npoint = 10000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            p = UnitSphereSamplingTest.randomPoint();
            q = new float[]{-p[0], -p[1], -p[2]};
            int i2 = uss.getIndex(p);
            int j2 = uss.getIndex(q);
            if (p[2] == 0.0f) {
                UnitSphereSamplingTest.assertEquals((int)(i2 + j2), (int)(mi + 1));
                continue;
            }
            UnitSphereSamplingTest.assertEquals((int)(-i2), (int)j2);
        }
    }

    private static void testInterpolation(int nbits, float error) {
        UnitSphereSampling uss = new UnitSphereSampling(nbits);
        int mi = uss.getMaxIndex();
        int nf = 1 + 2 * mi;
        float[] fi = new float[nf];
        for (int i = 1; i <= mi; ++i) {
            float[] p = uss.getPoint(i);
            float[] q = uss.getPoint(-i);
            fi[i] = UnitSphereSamplingTest.func(p[0], p[1], p[2]);
            fi[nf - i] = UnitSphereSamplingTest.func(q[0], q[1], q[2]);
        }
        float emax = 0.0f;
        int npoint = 10000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float f;
            float fc;
            float fb;
            float fa;
            float g;
            float e;
            float[] p = UnitSphereSamplingTest.randomPoint();
            int[] iabc = uss.getTriangle(p);
            float[] wabc = uss.getWeights(p, iabc);
            int ia = iabc[0];
            int ib = iabc[1];
            int ic = iabc[2];
            float wa = wabc[0];
            float wb = wabc[1];
            float wc = wabc[2];
            if (ia < 0) {
                ia = nf + ia;
                ib = nf + ib;
                ic = nf + ic;
            }
            if (!((e = Math.abs((g = wa * (fa = fi[ia]) + wb * (fb = fi[ib]) + wc * (fc = fi[ic])) - (f = UnitSphereSamplingTest.func(p[0], p[1], p[2])))) > emax)) continue;
            emax = e;
        }
        UnitSphereSamplingTest.assertTrue((emax < error ? 1 : 0) != 0);
    }

    private static float func(float x, float y, float z) {
        return 0.1f * (9.0f * x * x * x - 2.0f * x * x * y + 3.0f * x * y * y - 4.0f * y * y * y + 2.0f * z * z * z - x * y * z);
    }

    private static void testTriangle(int nbits) {
        UnitSphereSampling uss = new UnitSphereSampling(nbits);
        int npoint = 100000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float[] p = UnitSphereSamplingTest.randomPoint();
            int i = uss.getIndex(p);
            int[] abc = uss.getTriangle(p);
            int ia = abc[0];
            int ib = abc[1];
            int ic = abc[2];
            UnitSphereSamplingTest.assertTrue((i == ia || i == ib || i == ic ? 1 : 0) != 0);
        }
    }

    private static void testWeights(int nbits) {
        UnitSphereSampling uss = new UnitSphereSampling(nbits);
        int npoint = 10;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float[] p = UnitSphereSamplingTest.randomPoint();
            int[] iabc = uss.getTriangle(p);
            float[] wabc = uss.getWeights(p, iabc);
            float wa = wabc[0];
            float wb = wabc[1];
            float wc = wabc[2];
            UnitSphereSamplingTest.assertEquals((double)1.0, (double)(wa + wb + wc), (double)1.0E-5);
        }
    }

    private static void testMaxError(int nbits, float error) {
        UnitSphereSampling uss = new UnitSphereSampling(nbits);
        int npoint = 100000;
        float dmax = 0.0f;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            int i;
            float[] q;
            float[] p = UnitSphereSamplingTest.randomPoint();
            float d = UnitSphereSamplingTest.distanceOnSphere(p, q = uss.getPoint(i = uss.getIndex(p)));
            if (!(d > dmax)) continue;
            dmax = d;
        }
        UnitSphereSamplingTest.assertTrue((dmax < error ? 1 : 0) != 0);
    }

    private static float[] randomPoint() {
        float x = -1.0f + 2.0f * _random.nextFloat();
        float y = -1.0f + 2.0f * _random.nextFloat();
        float z = -1.0f + 2.0f * _random.nextFloat();
        float f = _random.nextFloat();
        if (f < 0.1f) {
            x = 0.0f;
        }
        if (0.1f <= f && f < 0.2f) {
            y = 0.0f;
        }
        if (0.2f <= f && f < 0.3f) {
            z = 0.0f;
        }
        float s = 1.0f / (float)Math.sqrt(x * x + y * y + z * z);
        return new float[]{x * s, y * s, z * s};
    }

    private static float distanceOnSphere(float[] p, float[] q) {
        double x = p[0] + q[0];
        double y = p[1] + q[1];
        double z = p[2] + q[2];
        double d = x * x + y * y + z * z;
        d = d == 0.0 ? Math.PI : (d == 4.0 ? 0.0 : 2.0 * Math.atan(Math.sqrt((4.0 - d) / d)));
        return (float)d;
    }
}

