/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.display;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayCreatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.display.event.window.WinClosedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultDisplayService
extends AbstractService
implements DisplayService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private ObjectService objectService;
    @Parameter
    private PluginService pluginService;
    private final LinkedList<Display<?>> displayList = new LinkedList();

    @Override
    public EventService eventService() {
        return this.eventService;
    }

    @Override
    public ObjectService objectService() {
        return this.objectService;
    }

    @Override
    public PluginService pluginService() {
        return this.pluginService;
    }

    @Override
    public Display<?> getActiveDisplay() {
        if (this.displayList.size() == 0) {
            return null;
        }
        return this.displayList.get(0);
    }

    @Override
    public <D extends Display<?>> D getActiveDisplay(Class<D> displayClass) {
        for (Display display : this.displayList) {
            if (!displayClass.isAssignableFrom(display.getClass())) continue;
            return (D)display;
        }
        return null;
    }

    @Override
    public void setActiveDisplay(Display<?> display) {
        if (display != null) {
            this.displayList.remove(display);
            this.displayList.addFirst(display);
            this.eventService.publish(new DisplayActivatedEvent(display));
        }
    }

    @Override
    public List<PluginInfo<Display<?>>> getDisplayPlugins() {
        return this.pluginService.getPluginsOfType(Display.class);
    }

    @Override
    public <D extends Display<?>> PluginInfo<Display<?>> getDisplayPlugin(Class<D> pluginClass) {
        PluginInfo<Display<?>> displayPlugin = this.pluginService.getPlugin(pluginClass, Display.class);
        return displayPlugin;
    }

    @Override
    public PluginInfo<Display<?>> getDisplayPlugin(String className) {
        return this.pluginService.getPlugin(className);
    }

    public <D extends Display<?>> List<PluginInfo<D>> getDisplayPluginsOfType(Class<D> type) {
        return this.pluginService.getPluginsOfType(type);
    }

    @Override
    public List<Display<?>> getDisplays() {
        return this.objectService.getObjects(Display.class);
    }

    public <D extends Display<?>> List<D> getDisplaysOfType(Class<D> type) {
        return this.objectService.getObjects(type);
    }

    @Override
    public Display<?> getDisplay(String name) {
        for (Display<?> display : this.getDisplays()) {
            if (!name.equalsIgnoreCase(display.getName())) continue;
            return display;
        }
        return null;
    }

    @Override
    public List<Display<?>> getDisplays(Object o) {
        ArrayList displays = new ArrayList();
        for (Display<?> display : this.getDisplays()) {
            if (!display.isDisplaying(o)) continue;
            displays.add(display);
        }
        return displays;
    }

    @Override
    public boolean isUniqueName(String name) {
        for (Display<?> display : this.getDisplays()) {
            if (!name.equalsIgnoreCase(display.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Display<?> createDisplay(Object o) {
        return this.createDisplay(null, o);
    }

    @Override
    public Display<?> createDisplay(String name, Object o) {
        Display<?> display = this.createDisplayQuietly(o);
        if (display == null) {
            return null;
        }
        if (name != null) {
            display.setName(name);
        }
        this.eventService.publish(new DisplayCreatedEvent(display));
        return display;
    }

    @Override
    public Display<?> createDisplayQuietly(Object o) {
        List<PluginInfo<Display<?>>> displayPlugins = this.getDisplayPlugins();
        for (PluginInfo<Display<?>> info : displayPlugins) {
            Display<?> display = this.pluginService.createInstance(info);
            if (display == null || !display.canDisplay(o)) continue;
            display.display(o);
            return display;
        }
        return null;
    }

    @EventHandler
    protected void onEvent(WinClosedEvent event) {
        Display<?> display = event.getDisplay();
        if (display != null) {
            display.close();
        }
    }

    @EventHandler
    protected void onEvent(WinActivatedEvent event) {
        Display<?> display = event.getDisplay();
        if (display != null) {
            this.setActiveDisplay(display);
        }
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent evt) {
        this.displayList.remove(evt.getObject());
    }
}

