/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.imagej.plugins.uploaders.ssh.SSHSessionCreator;
import net.imagej.updater.AbstractUploader;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.Uploadable;
import net.imagej.updater.Uploader;
import net.imagej.updater.util.InputStream2OutputStream;
import net.imagej.updater.util.UpdateCanceledException;
import net.imagej.updater.util.UpdaterUserInterface;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Uploader.class)
public class SSHFileUploader
extends AbstractUploader {
    private Session session;
    private Channel channel;
    private OutputStream out;
    protected OutputStream err = UpdaterUserInterface.get().getOutputStream();
    private InputStream in;
    private LogService log;

    public boolean login(FilesUploader uploader) {
        if (!super.login(uploader)) {
            return false;
        }
        this.log = uploader.getLog();
        this.session = SSHSessionCreator.getSession(uploader);
        return this.session != null;
    }

    protected boolean debugLogin(String host) {
        if (this.log == null) {
            this.log = new StderrLogService();
            this.log.setLevel(4);
        }
        try {
            this.session = SSHSessionCreator.debugConnect(host, this.log);
        }
        catch (JSchException e) {
            this.log.error((Throwable)e);
            return false;
        }
        return true;
    }

    public void logout() {
        try {
            this.disconnectSession();
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }

    public synchronized void upload(List<Uploadable> sources, List<String> locks) throws IOException {
        this.setCommand("date -u +%Y%m%d%H%M%S");
        this.timestamp = this.readNumber(this.in);
        this.setTitle("Uploading");
        String uploadFilesCommand = "scp -p -t -r " + this.uploadDir;
        this.setCommand(uploadFilesCommand);
        if (this.checkAck(this.in) != 0) {
            throw new IOException("Failed to set command " + uploadFilesCommand);
        }
        try {
            this.uploadFiles(sources);
        }
        catch (UpdateCanceledException cancel) {
            for (String lock : locks) {
                this.setCommand("rm " + this.uploadDir + lock + ".lock");
            }
            this.out.close();
            this.channel.disconnect();
            throw cancel;
        }
        for (String lock : locks) {
            this.setCommand("mv -f " + this.uploadDir + lock + ".lock " + this.uploadDir + lock);
        }
        this.out.close();
        this.disconnectSession();
    }

    private void uploadFiles(List<Uploadable> sources) throws IOException {
        this.calculateTotalSize(sources);
        int count = 0;
        String prefix = "";
        byte[] buf = new byte[16384];
        for (Uploadable source : sources) {
            int len;
            String target = source.getFilename();
            while (!target.startsWith(prefix)) {
                prefix = this.cdUp(prefix);
            }
            int slash = target.lastIndexOf(47);
            String directory = target.substring(0, slash + 1);
            this.cdInto(directory.substring(prefix.length()));
            prefix = directory;
            String command = source.getPermissions() + " " + source.getFilesize() + " " + target.substring(slash + 1) + "\n";
            this.out.write(command.getBytes());
            this.out.flush();
            this.checkAckUploadError(target);
            this.addItem(source);
            InputStream input = source.getInputStream();
            int currentCount = 0;
            int currentTotal = (int)source.getFilesize();
            while ((len = input.read(buf, 0, buf.length)) > 0) {
                this.out.write(buf, 0, len);
                this.setItemCount(currentCount += len, currentTotal);
                this.setCount(count + currentCount, this.total);
            }
            input.close();
            count += currentCount;
            buf[0] = 0;
            this.out.write(buf, 0, 1);
            this.out.flush();
            this.checkAckUploadError(target);
            this.itemDone(source);
        }
        while (!prefix.equals("")) {
            prefix = this.cdUp(prefix);
        }
        this.done();
    }

    private String cdUp(String directory) throws IOException {
        this.out.write("E\n".getBytes());
        this.out.flush();
        this.checkAckUploadError(directory);
        int slash = directory.lastIndexOf(47, directory.length() - 2);
        return directory.substring(0, slash + 1);
    }

    private void cdInto(String directory) throws IOException {
        while (!directory.equals("")) {
            int slash = directory.indexOf(47);
            String name = slash < 0 ? directory : directory.substring(0, slash);
            String command = "D2775 0 " + name + "\n";
            this.out.write(command.getBytes());
            this.out.flush();
            if (this.checkAck(this.in) != 0) {
                throw new IOException("Cannot enter directory " + name);
            }
            if (slash < 0) {
                return;
            }
            directory = directory.substring(slash + 1);
        }
    }

    protected void setCommand(String command) throws IOException {
        if (this.out != null) {
            this.out.close();
            this.channel.disconnect();
        }
        try {
            UpdaterUserInterface.get().debug("launching command " + command);
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            this.channel.setInputStream(null);
            ((ChannelExec)this.channel).setErrStream(this.err);
            this.out = this.channel.getOutputStream();
            this.in = this.channel.getInputStream();
            this.channel.connect();
        }
        catch (JSchException e) {
            this.log.error((Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private void checkAckUploadError(String target) throws IOException {
        if (this.checkAck(this.in) != 0) {
            throw new IOException("Failed to upload " + target);
        }
    }

    public void disconnectSession() throws IOException {
        if (this.in != null) {
            new InputStream2OutputStream(this.in, UpdaterUserInterface.get().getOutputStream());
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int exitStatus = 0;
        if (this.channel != null) {
            exitStatus = this.channel.getExitStatus();
            UpdaterUserInterface.get().debug("disconnect session; exit status is " + exitStatus);
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        if (this.err != null) {
            this.err.close();
        }
        if (exitStatus != 0) {
            throw new IOException("Command failed with status " + exitStatus + " (see Log)!");
        }
    }

    protected long readNumber(InputStream in) throws IOException {
        long result = 0L;
        while (true) {
            int b;
            if ((b = in.read()) >= 48 && b <= 57) {
                result = 10L * result + (long)b - 48L;
                continue;
            }
            if (b == 10) break;
        }
        return result;
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        UpdaterUserInterface.get().handleException((Throwable)new Exception("checkAck returns " + b));
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            UpdaterUserInterface.get().log("checkAck returned '" + sb.toString() + "'");
            UpdaterUserInterface.get().error(sb.toString());
        }
        return b;
    }

    public String getProtocol() {
        return "ssh";
    }
}

