/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import ij.ImageJ;
import ij.Prefs;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.tree.TreeCellRenderer;
import org.janelia.saalfeldlab.n5.bdv.N5Viewer;
import org.janelia.saalfeldlab.n5.bdv.N5ViewerTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ij.N5Importer;
import org.janelia.saalfeldlab.n5.metadata.N5ViewerMultichannelMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusLegacyMetadataParser;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.ui.DatasetSelectorDialog;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5ViewerMultiscaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;

public class N5ViewerCreator {
    public static final N5MetadataParser<?>[] n5vGroupParsers = new N5MetadataParser[]{new OmeNgffMetadataParser(), new N5CosemMultiScaleMetadata.CosemMultiScaleParser(), new N5ViewerMultiscaleMetadataParser(), new CanonicalMetadataParser(), new N5ViewerMultichannelMetadata.N5ViewerMultichannelMetadataParser(), new N5ViewerMultichannelMetadata.GenericMultichannelMetadataParser()};
    public static final N5MetadataParser<?>[] n5vParsers = new N5MetadataParser[]{new ImagePlusLegacyMetadataParser(), new N5CosemMetadataParser(), new N5SingleScaleMetadataParser(), new CanonicalMetadataParser(), new N5GenericSingleScaleMetadataParser()};
    private String lastOpenedContainer = "";

    public static final void main(String ... args) {
        new ImageJ();
        Prefs.setThreads((int)6);
        new N5ViewerCreator().openViewer(Throwable::printStackTrace);
    }

    public void openViewer(Consumer<Exception> exceptionHandler) {
        this.openViewer(exceptionHandler, null);
    }

    public void openViewer(Consumer<Exception> exceptionHandler, Consumer<N5Viewer> viewerConsumer) {
        this.openViewer(exceptionHandler, viewerConsumer, null, null);
    }

    public void openViewer(Consumer<Exception> exceptionHandler, Consumer<N5Viewer> viewerConsumer, Consumer<DataSelection> selectionConsumer, Consumer<Void> cancelConsumer) {
        ExecutorService exec = Executors.newFixedThreadPool(Prefs.getThreads());
        DatasetSelectorDialog dialog = new DatasetSelectorDialog((Function)new N5Importer.N5ViewerReaderFun(), (Function)new N5Importer.N5BasePathFun(), this.lastOpenedContainer, n5vGroupParsers, n5vParsers);
        dialog.setLoaderExecutor(exec);
        dialog.setContainerPathUpdateCallback(x -> {
            this.lastOpenedContainer = x;
        });
        dialog.setTreeRenderer((TreeCellRenderer)((Object)new N5ViewerTreeCellRenderer(false)));
        dialog.setCancelCallback(cancelConsumer);
        dialog.run(selection -> {
            try {
                N5Viewer n5Viewer = new N5Viewer(null, (DataSelection)selection, true);
                if (selectionConsumer != null) {
                    selectionConsumer.accept((DataSelection)selection);
                }
                if (viewerConsumer != null) {
                    viewerConsumer.accept(n5Viewer);
                }
            }
            catch (IOException e) {
                exceptionHandler.accept(e);
            }
        });
    }
}

