/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.DirectionalLightRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Light;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector3f;

public class DirectionalLight
extends Light {
    public static final int ALLOW_DIRECTION_READ = 18;
    public static final int ALLOW_DIRECTION_WRITE = 19;
    private static final int[] readCapabilities = new int[]{18};

    public DirectionalLight() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public DirectionalLight(Color3f color, Vector3f direction) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((DirectionalLightRetained)this.retained).initDirection(direction);
    }

    public DirectionalLight(boolean lightOn, Color3f color, Vector3f direction) {
        super(lightOn, color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((DirectionalLightRetained)this.retained).initDirection(direction);
    }

    @Override
    void createRetained() {
        this.retained = new DirectionalLightRetained();
        this.retained.setSource(this);
    }

    public void setDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight0"));
        }
        if (this.isLive()) {
            ((DirectionalLightRetained)this.retained).setDirection(direction);
        } else {
            ((DirectionalLightRetained)this.retained).initDirection(direction);
        }
    }

    public void setDirection(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight1"));
        }
        if (this.isLive()) {
            ((DirectionalLightRetained)this.retained).setDirection(x, y, z);
        } else {
            ((DirectionalLightRetained)this.retained).initDirection(x, y, z);
        }
    }

    public void getDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DirectionalLight2"));
        }
        ((DirectionalLightRetained)this.retained).getDirection(direction);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        DirectionalLight d = new DirectionalLight();
        d.duplicateNode(this, forceDuplicate);
        return d;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        Vector3f v = new Vector3f();
        ((DirectionalLightRetained)originalNode.retained).getDirection(v);
        ((DirectionalLightRetained)this.retained).initDirection(v);
    }
}

