/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.GLSLShaderProgramRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderProgram;
import org.jogamp.java3d.SourceCodeShader;

public class GLSLShaderProgram
extends ShaderProgram {
    @Override
    public void setVertexAttrNames(String[] vertexAttrNames) {
        this.checkForLiveOrCompiled();
        if (vertexAttrNames != null) {
            for (int i = 0; i < vertexAttrNames.length; ++i) {
                if (vertexAttrNames[i] != null) continue;
                throw new NullPointerException();
            }
        }
        ((GLSLShaderProgramRetained)this.retained).setVertexAttrNames(vertexAttrNames);
    }

    @Override
    public String[] getVertexAttrNames() {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GLSLShaderProgram0"));
        }
        return ((GLSLShaderProgramRetained)this.retained).getVertexAttrNames();
    }

    @Override
    public void setShaderAttrNames(String[] shaderAttrNames) {
        this.checkForLiveOrCompiled();
        if (shaderAttrNames != null) {
            for (int i = 0; i < shaderAttrNames.length; ++i) {
                if (shaderAttrNames[i] != null) continue;
                throw new NullPointerException();
            }
        }
        ((GLSLShaderProgramRetained)this.retained).setShaderAttrNames(shaderAttrNames);
    }

    @Override
    public String[] getShaderAttrNames() {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GLSLShaderProgram0"));
        }
        return ((GLSLShaderProgramRetained)this.retained).getShaderAttrNames();
    }

    @Override
    public void setShaders(Shader[] shaders) {
        this.checkForLiveOrCompiled();
        if (shaders != null) {
            for (int i = 0; i < shaders.length; ++i) {
                if (shaders[i].getShadingLanguage() != 1) {
                    throw new IllegalArgumentException(J3dI18N.getString("GLSLShaderProgram2"));
                }
                SourceCodeShader sourceCodeShader = (SourceCodeShader)shaders[i];
            }
        }
        ((GLSLShaderProgramRetained)this.retained).setShaders(shaders);
    }

    @Override
    public Shader[] getShaders() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GLSLShaderProgram1"));
        }
        return ((GLSLShaderProgramRetained)this.retained).getShaders();
    }

    @Override
    void createRetained() {
        this.retained = new GLSLShaderProgramRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        GLSLShaderProgram a = new GLSLShaderProgram();
        a.duplicateNodeComponent(this);
        return a;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        GLSLShaderProgramRetained orig = (GLSLShaderProgramRetained)originalNodeComponent.retained;
        GLSLShaderProgramRetained rt = (GLSLShaderProgramRetained)this.retained;
        rt.setVertexAttrNames(orig.getVertexAttrNames());
        rt.setShaderAttrNames(orig.getShaderAttrNames());
        rt.setShaders(orig.getShaders());
    }

    @Override
    boolean duplicateChild() {
        if (super.duplicateChild()) {
            return true;
        }
        return this.getDuplicateOnCloneTree();
    }
}

