/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.derivative;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.PartialDerivative.class)
public class PartialDerivativeRAI<T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Filter.PartialDerivative {
    @Parameter
    private int dimension;
    private UnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createRAI;
    private BinaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> addOp;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> kernelBConvolveOp;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>[] kernelAConvolveOps;

    @Override
    public void initialize() {
        RandomAccessibleInterval<ComplexType> kernel = this.ops().create().kernelSobel((ComplexType)Util.getTypeFromInterval((Interval)((Interval)this.in())));
        IntervalView kernelA = Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(kernel, (int)3, (long)0L), (int)2, (long)0L);
        IntervalView kernelB = Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(kernel, (int)3, (long)0L), (int)2, (long)1L);
        if (((RandomAccessibleInterval)this.in()).numDimensions() > 2) {
            MixedTransformView expandedKernelA = Views.addDimension((RandomAccessible)kernelA);
            MixedTransformView expandedKernelB = Views.addDimension((RandomAccessible)kernelB);
            for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions() - 3; ++i) {
                expandedKernelA = Views.addDimension((RandomAccessible)expandedKernelA);
                expandedKernelB = Views.addDimension((RandomAccessible)expandedKernelB);
            }
            long[] dims = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
            for (int j = 0; j < ((RandomAccessibleInterval)this.in()).numDimensions(); ++j) {
                dims[j] = 1L;
            }
            dims[0] = 3L;
            FinalInterval kernelInterval = new FinalInterval(dims);
            kernelA = Views.interval((RandomAccessible)expandedKernelA, (Interval)kernelInterval);
            kernelB = Views.interval((RandomAccessible)expandedKernelB, (Interval)kernelInterval);
        }
        long[] dims = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
        if (this.dimension == 0) {
            this.kernelBConvolveOp = RAIs.computer(this.ops(), Ops.Filter.Convolve.class, (RandomAccessibleInterval)this.in(), kernelB);
        } else {
            for (int j = 0; j < ((RandomAccessibleInterval)this.in()).numDimensions(); ++j) {
                dims[j] = j == this.dimension ? 3L : 1L;
            }
            Img<DoubleType> kernelInterval = this.ops().create().img(dims);
            IntervalView rotatedKernelB = kernelB;
            for (int i = 0; i < this.dimension; ++i) {
                rotatedKernelB = Views.rotate((RandomAccessibleInterval)rotatedKernelB, (int)i, (int)(i + 1));
            }
            rotatedKernelB = Views.interval((RandomAccessible)rotatedKernelB, kernelInterval);
            this.kernelBConvolveOp = RAIs.computer(this.ops(), Ops.Filter.Convolve.class, (RandomAccessibleInterval)this.in(), rotatedKernelB);
        }
        dims = null;
        this.kernelAConvolveOps = new UnaryComputerOp[((RandomAccessibleInterval)this.in()).numDimensions()];
        if (this.dimension != 0) {
            this.kernelAConvolveOps[0] = RAIs.computer(this.ops(), Ops.Filter.Convolve.class, (RandomAccessibleInterval)this.in(), kernelA);
        }
        IntervalView rotatedKernelA = kernelA;
        for (int i = 1; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
            if (i == this.dimension) continue;
            dims = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
            for (int j = 0; j < ((RandomAccessibleInterval)this.in()).numDimensions(); ++j) {
                dims[j] = i == j ? 3L : 1L;
            }
            Img<DoubleType> kernelInterval = this.ops().create().img(dims);
            for (int j = 0; j < i; ++j) {
                rotatedKernelA = Views.rotate((RandomAccessibleInterval)rotatedKernelA, (int)j, (int)(j + 1));
            }
            this.kernelAConvolveOps[i] = RAIs.computer(this.ops(), Ops.Filter.Convolve.class, (RandomAccessibleInterval)this.in(), Views.interval((RandomAccessible)rotatedKernelA, kernelInterval));
            rotatedKernelA = kernelA;
        }
        this.addOp = RAIs.binaryComputer(this.ops(), Ops.Math.Add.class, (RandomAccessibleInterval)this.in(), (RandomAccessibleInterval)this.in(), new Object[0]);
        this.createRAI = RAIs.function(this.ops(), Ops.Create.Img.class, (RandomAccessibleInterval)this.in(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        RandomAccessibleInterval<T> in = input;
        for (int i = input.numDimensions() - 1; i >= 0; --i) {
            RandomAccessibleInterval<T> derivative = this.createRAI.calculate(input);
            if (this.dimension == i) {
                this.kernelBConvolveOp.compute((RandomAccessibleInterval<T>)Views.interval((RandomAccessible)Views.extendMirrorDouble(in), input), derivative);
            } else {
                this.kernelAConvolveOps[i].compute((RandomAccessibleInterval<T>)Views.interval((RandomAccessible)Views.extendMirrorDouble(in), input), derivative);
            }
            in = derivative;
        }
        this.addOp.compute(output, in, output);
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<T> input) {
        return this.createRAI.calculate(input);
    }
}

