/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.imagemoments.centralmoments;

import net.imagej.ops.Ops;
import net.imagej.ops.imagemoments.AbstractImageMomentOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.ImageMoments.CentralMoment11.class, label="Image Moment: CentralMoment11", priority=10000.0)
public class IterableCentralMoment11<I extends RealType<I>, O extends RealType<O>>
extends AbstractImageMomentOp<I, O>
implements Ops.ImageMoments.CentralMoment11 {
    @Override
    public void compute(IterableInterval<I> input, O output) {
        double moment00 = 0.0;
        double moment01 = 0.0;
        double moment10 = 0.0;
        double moment11 = 0.0;
        Cursor cursor = input.localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double x = cursor.getDoublePosition(0);
            double y = cursor.getDoublePosition(1);
            double val = ((RealType)cursor.get()).getRealDouble();
            moment00 += val;
            moment01 += y * val;
            moment10 += x * val;
            moment11 += x * y * val;
        }
        double centerx = moment10 / moment00;
        output.setReal(moment11 - centerx * moment01);
    }
}

