/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.special;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.imagej.ops.Initializable;
import net.imagej.ops.Op;
import net.imagej.ops.OpCandidate;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpRef;
import net.imagej.ops.Threadable;
import net.imagej.ops.special.computer.NullaryComputerOp;
import net.imagej.ops.special.function.NullaryFunctionOp;
import net.imagej.ops.special.inplace.UnaryInplaceOp;
import org.scijava.InstantiableException;

public interface SpecialOp
extends Op,
Initializable,
Threadable {
    public int getArity();

    @Override
    default public SpecialOp getIndependentInstance() {
        return this;
    }

    public static <S extends SpecialOp, O> S op(OpEnvironment ops, Class<? extends Op> opType, Class<S> specialType, Class<O> outType, Object ... args) {
        OpRef ref = OpRef.createTypes(opType, specialType, outType, args);
        SpecialOp op = (SpecialOp)ops.op(ref);
        return (S)op;
    }

    public static List<OpCandidate> candidates(OpEnvironment ops, String name, Class<? extends Op> opType, int arity, Flavor flavor) {
        ArrayList<Class<Op>> types = new ArrayList<Class<Op>>();
        if (opType != null) {
            types.add(opType);
        }
        if (flavor == Flavor.COMPUTER) {
            types.add(NullaryComputerOp.class);
        } else if (flavor == Flavor.FUNCTION) {
            types.add(NullaryFunctionOp.class);
        } else if (flavor == Flavor.INPLACE) {
            types.add(UnaryInplaceOp.class);
        }
        OpRef ref = new OpRef(name, types, null, new Object[0]);
        return SpecialOp.filterArity(ops.matcher().findCandidates(ops, ref), arity);
    }

    public static List<OpCandidate> filterArity(List<OpCandidate> candidates, int arity) {
        if (arity < 0) {
            return candidates;
        }
        return candidates.stream().filter(candidate -> {
            try {
                Class opClass = candidate.cInfo().loadClass();
                if (!SpecialOp.class.isAssignableFrom(opClass)) {
                    return false;
                }
                Object o = opClass.newInstance();
                SpecialOp op = (SpecialOp)o;
                return arity == op.getArity();
            }
            catch (IllegalAccessException | InstantiationException | InstantiableException exc) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static enum Flavor {
        COMPUTER,
        FUNCTION,
        INPLACE;

    }
}

