/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import ij.IJ;
import volume.VolumeFloat;

public class SSD {
    public float[][] w;
    private int size;
    private int n;
    int[] peakloc;

    public SSD(int size, int n) {
        this.size = size;
        this.n = n;
        this.w = new float[size][size];
        this.peakloc = new int[2];
    }

    public SSD(VolumeFloat v, int size, int n, int direction, int x, int y) {
        this.peakloc = new int[2];
        if (direction != 1 && direction != -1) {
            IJ.error((String)"Error in SSD ");
            return;
        }
        this.size = size;
        this.n = n;
        this.w = new float[size][size];
        float[][][] p = v.v;
        if (direction == 1) {
            for (int l = -size / 2; l <= size / 2; ++l) {
                for (int k = -size / 2; k <= size / 2; ++k) {
                    this.w[l + size / 2][k + size / 2] = 0.0f;
                    for (int j = -n; j <= n; ++j) {
                        for (int i = -n; i <= n; ++i) {
                            float[] fArray = this.w[l + size / 2];
                            int n2 = k + size / 2;
                            fArray[n2] = (float)((double)fArray[n2] + Math.pow(p[1][y + j][x + i] - p[2][y + j + l][x + i + k], 2.0));
                        }
                    }
                }
            }
        } else {
            for (int l = -size / 2; l <= size / 2; ++l) {
                for (int k = -size / 2; k <= size / 2; ++k) {
                    this.w[size - 1 - (l + size / 2)][size - 1 - (k + size / 2)] = 0.0f;
                    for (int j = -n; j <= n; ++j) {
                        for (int i = -n; i <= n; ++i) {
                            float[] fArray = this.w[size - 1 - (l + size / 2)];
                            int n3 = size - 1 - (k + size / 2);
                            fArray[n3] = (float)((double)fArray[n3] + Math.pow(p[1][y + j][x + i] - p[0][y + j + l][x + i + k], 2.0));
                        }
                    }
                }
            }
        }
    }

    public void add(SSD ssdl, SSD ssdr) {
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                this.w[l + this.size / 2][k + this.size / 2] = ssdl.w[l + this.size / 2][k + this.size / 2] + ssdr.w[l + this.size / 2][k + this.size / 2];
            }
        }
    }

    public int[] peak(int x, int y) {
        float minp = Float.MAX_VALUE;
        float mag = 0.0f;
        this.peakloc[1] = 0;
        this.peakloc[0] = 0;
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                boolean test3;
                int lo = l + this.size / 2;
                int ko = k + this.size / 2;
                int distance = l * l + k * k;
                if (l < -this.size / 4 || l > this.size / 4 || k < -this.size / 4 || k > this.size / 4) continue;
                boolean test1 = (double)Math.abs(this.w[lo][ko] - minp) <= 0.1;
                boolean test2 = (float)distance < mag;
                boolean bl = test3 = (double)(minp - this.w[lo][ko]) > 0.1;
                if ((!test1 || !test2) && !test3) continue;
                minp = this.w[lo][ko];
                this.peakloc[1] = l;
                this.peakloc[0] = k;
                mag = distance;
            }
        }
        return this.peakloc;
    }

    public void center(SSD ssd, int[] peakloc) {
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                this.w[l + this.size / 2][k + this.size / 2] = ssd.w[l + this.size / 2 + peakloc[1] + ssd.size / 4][k + this.size / 2 + peakloc[0] + ssd.size / 4];
            }
        }
    }

    public float min() {
        float min = Float.MAX_VALUE;
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                if (!(this.w[l + this.size / 2][k + this.size / 2] < min) || this.w[l + this.size / 2][k + this.size / 2] == 0.0f) continue;
                min = this.w[l + this.size / 2][k + this.size / 2];
            }
        }
        return min;
    }

    public void recompute(float K) {
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                this.w[l + this.size / 2][k + this.size / 2] = (float)Math.exp(-K * this.w[l + this.size / 2][k + this.size / 2]);
            }
        }
    }

    public void mean(int displacement, int[] peakloc, float[] mean, float[][] covariance, int x, int y) {
        float uy;
        float ux;
        int k;
        int l;
        mean[0] = 0.0f;
        mean[1] = 0.0f;
        float sum = 0.0f;
        float inc = 2 * displacement / (this.size - 1);
        for (l = -this.size / 2; l <= this.size / 2; ++l) {
            for (k = -this.size / 2; k <= this.size / 2; ++k) {
                sum += this.w[l + this.size / 2][k + this.size / 2];
                ux = (float)(peakloc[0] - displacement) + (float)(k + this.size / 2) * inc;
                uy = (float)(peakloc[1] - displacement) + (float)(l + this.size / 2) * inc;
                mean[0] = mean[0] + this.w[l + this.size / 2][k + this.size / 2] * ux;
                mean[1] = mean[1] + this.w[l + this.size / 2][k + this.size / 2] * uy;
            }
        }
        mean[0] = mean[0] / sum;
        mean[1] = mean[1] / sum;
        covariance[1][1] = 0.0f;
        covariance[0][1] = 0.0f;
        covariance[0][0] = 0.0f;
        for (l = -this.size / 2; l <= this.size / 2; ++l) {
            for (k = -this.size / 2; k <= this.size / 2; ++k) {
                ux = (float)(peakloc[0] - displacement) + (float)(k + this.size / 2) * inc;
                uy = (float)(peakloc[1] - displacement) + (float)(l + this.size / 2) * inc;
                float[] fArray = covariance[0];
                fArray[0] = (float)((double)fArray[0] + (double)this.w[l + this.size / 2][k + this.size / 2] * Math.pow(ux - mean[0], 2.0));
                float[] fArray2 = covariance[1];
                fArray2[1] = (float)((double)fArray2[1] + (double)this.w[l + this.size / 2][k + this.size / 2] * Math.pow(uy - mean[1], 2.0));
                float[] fArray3 = covariance[0];
                fArray3[1] = fArray3[1] + this.w[l + this.size / 2][k + this.size / 2] * (ux - mean[0]) * (uy - mean[1]);
            }
        }
        covariance[1][0] = covariance[0][1];
        for (int j = 0; j < 2; ++j) {
            int i = 0;
            while (i < 2) {
                float[] fArray = covariance[j];
                int n = i++;
                fArray[n] = fArray[n] / sum;
            }
        }
    }

    public void map(float[] pixels, int width, int offset) {
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                int i = offset + l * width + k;
                pixels[i] = this.w[l + this.size / 2][k + this.size / 2];
            }
        }
    }

    public String toString() {
        String s = "";
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                s = s + "" + IJ.d2s((double)this.w[l + this.size / 2][k + this.size / 2], (int)4) + "\t";
            }
            s = s + "\n";
        }
        return s;
    }

    public void check(int x, int y, int[] loc, float startmag) {
        int r = 10;
        float[][] SSD2 = new float[this.size][this.size];
        int N = this.size / 4;
        for (int l = -this.size / 2; l <= this.size / 2; ++l) {
            for (int k = -this.size / 2; k <= this.size / 2; ++k) {
                SSD2[l + this.size / 2][k + this.size / 2] = this.w[l + this.size / 2][k + this.size / 2];
            }
        }
        IJ.log((String)("Check minima at " + x + "," + y + " max (peak)=" + loc[0] + "," + loc[1]));
        for (int i = 0; i < r; ++i) {
            float min_value = Float.MAX_VALUE;
            float SSDmag = startmag;
            int u_min = 0;
            int v_min = 0;
            for (int u = -N; u <= N; ++u) {
                for (int v = -N; v <= N; ++v) {
                    int u_index = u + N;
                    int v_index = v + N;
                    if (!((double)Math.abs(SSD2[u_index][v_index] - min_value) <= 0.1 && (float)(u * u + v * v) < SSDmag) && !((double)(min_value - SSD2[u_index][v_index]) > 0.1)) continue;
                    min_value = SSD2[u_index][v_index];
                    v_min = v;
                    u_min = u;
                    SSDmag = u * u + v * v;
                }
            }
            SSD2[u_min + N][v_min + N] = Float.MAX_VALUE;
            if (startmag < 1.0f) {
                IJ.log((String)("" + i + "th minimum: " + min_value + " at " + u_min + "," + v_min + " SSDmag: " + (u_min * u_min + v_min * v_min)));
                continue;
            }
            IJ.log((String)("" + i + "th minimum: " + min_value + " at " + u_min + "," + v_min));
        }
    }
}

