/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.Serializable;
import volume.Kernel;
import volume.Kernel1D;
import volume.Kernel3D;
import volume.Volume;
import volume.VolumeFloat;

public class HyperVolume
extends Volume
implements Serializable {
    public float[][][][] hv;
    protected int length;

    public HyperVolume() {
        this.hv = null;
    }

    public HyperVolume(int width, int height, int depth, int length) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.length = length;
        this.hv = new float[length][depth][height][width];
        this.edge = 0;
    }

    public HyperVolume(ImageStack is, int depth) {
        this(is.getWidth(), is.getHeight(), depth, is.getSize() / depth);
        this.load(is, 0);
    }

    public HyperVolume(ImageStack is, int depth, int center, int n, Kernel1D kernel) {
        this(is.getWidth(), is.getHeight(), depth, n);
        if (kernel instanceof Kernel1D && kernel.support() > 0) {
            this.loadConvolve(is, center, kernel);
        } else {
            this.load(is, center);
        }
    }

    @Override
    public Object get(int x, int y, int z) {
        return this.hv[z][y][x];
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.hv[z][y][x] = (float[])value;
    }

    public ImageStack toStack() {
        ImageStack is = new ImageStack(this.width, this.height);
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                FloatProcessor fp = new FloatProcessor(this.width, this.height);
                float[] im = (float[])fp.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int offset = y * this.width;
                    for (int x = 0; x < this.width; ++x) {
                        im[offset + x] = this.hv[t][z][y][x];
                    }
                }
                is.addSlice("" + t + ":" + (z + 1), (ImageProcessor)fp);
            }
        }
        return is;
    }

    private void loadConvolve(ImageStack is, int centralVolume, Kernel1D kernel) {
        float[][] t1 = new float[this.height][this.width];
        if ((centralVolume - this.length / 2 - kernel.halfwidth) * this.depth < 0 || (centralVolume + this.length / 2 + kernel.halfwidth + 1) * this.depth > is.getSize()) {
            IJ.error((String)("loadConvolve: slice indexOutOfBounds error" + (centralVolume - this.length / 2 - kernel.halfwidth) * this.depth + " - " + ((centralVolume + this.length / 2 + kernel.halfwidth) * this.depth + this.depth)));
            return;
        }
        for (int t = centralVolume - this.length / 2; t <= centralVolume + this.length / 2; ++t) {
            int z;
            for (z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.hv[t - (centralVolume - this.length / 2)][z][y][x] = 0.0f;
                    }
                }
            }
            for (z = 0; z < this.depth; ++z) {
                for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    this.loadSlice(t1, is, z + (t + k) * this.depth + 1);
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            float[] fArray = this.hv[t - (centralVolume - this.length / 2)][z][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)t1[y][x] * kernel.k[k + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
        this.edge = kernel.halfwidth;
    }

    private void load(ImageStack is, int start) {
        float[][] t1 = new float[this.height][this.width];
        for (int t = start; t < start + this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                this.loadSlice(t1, is, z + t * this.depth + 1);
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.hv[t - start][z][y][x] = t1[y][x];
                    }
                }
            }
        }
        this.edge = 0;
    }

    public int getLength() {
        return this.length;
    }

    public boolean valid(int x, int y, int z, int t) {
        return x >= this.edge && x < this.width - this.edge && y >= this.edge && y < this.height - this.edge && z >= this.edge && z < this.depth - this.edge && t >= this.edge && t < this.length - this.edge;
    }

    private int InitParams(HyperVolume hv, Kernel kernel) {
        if (this.width < hv.getWidth() || this.height < hv.getHeight() || this.depth < hv.getDepth() || this.length > hv.getLength()) {
            IJ.error((String)"hypervolume: convolution volume wrong size.");
            return -1;
        }
        int lengthoffset = 0;
        if (this.length < hv.getLength()) {
            lengthoffset = (hv.getLength() - this.length) / 2;
        }
        this.edge = Math.max(hv.edge, this.edge);
        this.edge = Math.max(kernel.halfwidth, this.edge);
        return lengthoffset;
    }

    public void convolvet(Kernel1D kernel) {
        this.edge = Math.max(kernel.halfwidth, this.edge);
        double[] s = new double[this.length];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int t;
                    for (t = 0; t < this.length; ++t) {
                        s[t] = 0.0;
                        if (!this.valid(x, y, z)) continue;
                        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            int n = t;
                            s[n] = s[n] + (double)this.hv[t + k][z][y][x] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    for (t = 0; t < this.length; ++t) {
                        this.hv[t][z][y][x] = (float)s[t];
                    }
                }
            }
        }
    }

    public void convolvet(HyperVolume hv1, Kernel1D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = -this.length / 2; t <= this.length / 2; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)hv1.hv[t + k + lengthoffset][z][y][x] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        this.hv[t + this.length / 2][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvez(HyperVolume hv1, Kernel1D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)hv1.hv[t + lengthoffset][z + k][y][x] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        this.hv[t][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvey(HyperVolume hv1, Kernel1D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)hv1.hv[t + lengthoffset][z][y + k][x] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        this.hv[t][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvex(HyperVolume hv1, Kernel1D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)hv1.hv[t + lengthoffset][z][y][x + k] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        this.hv[t][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvet(HyperVolume hv1, Kernel3D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = -this.length / 2; t <= this.length / 2; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                                for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                        s += (double)hv1.hv[t + lengthoffset + k][z][y + l][x + m] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth][k + kernel.halfwidth];
                                    }
                                }
                            }
                        }
                        this.hv[t + this.length / 2][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvez(HyperVolume hv1, Kernel3D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = -this.length / 2; t <= this.length / 2; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                                for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                        s += (double)hv1.hv[t + lengthoffset][z + k][y + l][x + m] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth][k + kernel.halfwidth];
                                    }
                                }
                            }
                        }
                        this.hv[t + this.length / 2][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvey(HyperVolume hv1, Kernel3D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = -this.length / 2; t <= this.length / 2; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                                for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                        s += (double)hv1.hv[t + lengthoffset][z + m][y + k][x + l] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth][k + kernel.halfwidth];
                                    }
                                }
                            }
                        }
                        this.hv[t + this.length / 2][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvex(HyperVolume hv1, Kernel3D kernel) {
        int lengthoffset = this.InitParams(hv1, kernel);
        if (lengthoffset < 0) {
            return;
        }
        for (int t = -this.length / 2; t <= this.length / 2; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        double s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                                for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                        s += (double)hv1.hv[t + lengthoffset][z + m][y + l][x + k] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth][k + kernel.halfwidth];
                                    }
                                }
                            }
                        }
                        this.hv[t + this.length / 2][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void convolvexyz(Kernel1D kernel) {
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        for (int t = 0; t < this.length; ++t) {
            int k;
            double s;
            int x;
            int y;
            int z;
            VolumeFloat t1 = new VolumeFloat(this.width, this.height, this.depth);
            VolumeFloat t2 = new VolumeFloat(this.width, this.height, this.depth);
            for (z = 0; z < this.depth; ++z) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)this.hv[t][z][y][x + k] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        t1.v[z][y][x] = (float)s;
                    }
                }
            }
            for (z = 0; z < this.depth; ++z) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)t1.v[z][y + k][x] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        t2.v[z][y][x] = (float)s;
                    }
                }
            }
            for (z = 0; z < this.depth; ++z) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        s = 0.0;
                        if (this.valid(x, y, z)) {
                            for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                s += (double)t2.v[z + k][y][x] * kernel.k[k + kernel.halfwidth];
                            }
                        }
                        this.hv[t][z][y][x] = (float)s;
                    }
                }
            }
        }
    }

    public void mul(double constant) {
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        float[] fArray = this.hv[t][z][y];
                        int n = x++;
                        fArray[n] = (float)((double)fArray[n] * constant);
                    }
                }
            }
        }
    }

    public void mul(HyperVolume a, HyperVolume b) {
        if (this.width != a.getWidth() || this.height != a.getHeight() || this.depth != a.getDepth() || this.length != a.getLength() || this.width != b.getWidth() || this.height != b.getHeight() || this.depth != b.getDepth() || this.length != a.getLength()) {
            IJ.error((String)"mul undefined.");
        }
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.hv[t][z][y][x] = (float)((double)a.hv[t][z][y][x] * (double)b.hv[t][z][y][x]);
                    }
                }
            }
        }
    }

    private void loadSlice(float[][] i, ImageStack s, int io) {
        if (io < 1 || io > s.getSize()) {
            IJ.error((String)("loadSlice: slice index out of bounds (" + io + "><1-" + s.getSize() + ")"));
            return;
        }
        ImageProcessor ip = s.getProcessor(io);
        if (ip instanceof ColorProcessor) {
            this.loadPixels(i, (ColorProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof ByteProcessor) {
            this.loadPixels(i, (ByteProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof ShortProcessor) {
            this.loadPixels(i, (ShortProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof FloatProcessor) {
            this.loadPixels(i, (FloatProcessor)ip, s.getWidth(), s.getHeight());
        }
    }

    private void loadPixels(float[][] i, ColorProcessor cp, int width, int height) {
        int[] ii = (int[])cp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int c = ii[offset + x];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                i[y][x] = (float)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
            }
        }
    }

    private void loadPixels(float[][] i, ByteProcessor bp, int width, int height) {
        byte[] b = (byte[])bp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = b[offset + x] & 0xFF;
            }
        }
    }

    private void loadPixels(float[][] i, ShortProcessor sp, int width, int height) {
        short[] u = (short[])sp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = u[offset + x];
            }
        }
    }

    private void loadPixels(float[][] i, FloatProcessor fp, int width, int height) {
        float[] f = (float[])fp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = f[offset + x];
            }
        }
    }

    public void intoStack(ImageStack is) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        if (min > this.hv[t][z][y][x]) {
                            min = this.hv[t][z][y][x];
                        }
                        if (!(max < this.hv[t][z][y][x])) continue;
                        max = this.hv[t][z][y][x];
                    }
                }
            }
        }
        float scale = 1.0f / (max - min);
        Object[] stack = is.getImageArray();
        for (int t = 0; t < this.length; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                int x;
                int offset;
                int y;
                if (stack[0] instanceof byte[]) {
                    byte[] b = (byte[])is.getPixels(t * this.depth + z + 1);
                    for (y = 0; y < this.height; ++y) {
                        offset = y * this.width;
                        for (x = 0; x < this.width; ++x) {
                            b[offset + x] = (byte)((this.hv[t][z][y][x] - min) * scale * 255.0f);
                        }
                    }
                    continue;
                }
                if (stack[0] instanceof short[]) {
                    short[] u = (short[])is.getPixels(t * this.depth + z + 1);
                    for (y = 0; y < this.height; ++y) {
                        offset = y * this.width;
                        for (x = 0; x < this.width; ++x) {
                            u[offset + x] = (short)((this.hv[t][z][y][x] - min) * scale * 32767.0f);
                        }
                    }
                    continue;
                }
                if (stack[0] instanceof float[]) {
                    float[] f = (float[])is.getPixels(t * this.depth + z + 1);
                    for (y = 0; y < this.height; ++y) {
                        offset = y * this.width;
                        for (x = 0; x < this.width; ++x) {
                            f[offset + x] = this.hv[t][z][y][x];
                        }
                    }
                    continue;
                }
                if (!(stack[0] instanceof int[])) continue;
                int[] ii = (int[])is.getPixels(t * this.depth + z + 1);
                for (y = 0; y < this.height; ++y) {
                    offset = y * this.width;
                    for (x = 0; x < this.width; ++x) {
                        int b = (int)((this.hv[t][z][y][x] - min) * scale * 255.0f);
                        ii[offset + x] = b << 16 | b << 8 | b;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Hypervolume: " + this.width + "x" + this.height + "x" + this.depth + "x" + this.length;
    }
}

