/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.NoSuchElementException;
import net.imglib2.Cursor;
import net.imglib2.predicate.Predicate;
import net.imglib2.type.Type;

public class PredicateCursor<T extends Type<T>>
implements Cursor<T> {
    protected final Predicate<T> predicate;
    protected final Cursor<T> cursor;
    protected boolean lookedForNext = false;
    protected boolean hasNext = false;

    public PredicateCursor(Cursor<T> cursor, Predicate<T> predicate) {
        this.cursor = cursor;
        this.predicate = predicate;
    }

    protected boolean findNext() {
        boolean found = false;
        while (this.cursor.hasNext()) {
            this.cursor.fwd();
            if (!this.predicate.test(this.cursor)) continue;
            found = true;
            break;
        }
        this.hasNext = found;
        return found;
    }

    public boolean hasNext() {
        if (this.lookedForNext) {
            return this.hasNext;
        }
        this.lookedForNext = true;
        return this.findNext();
    }

    public void fwd() {
        if (!this.lookedForNext) {
            this.findNext();
        }
        this.lookedForNext = false;
    }

    public void jumpFwd(long num) {
        while (num > 0L) {
            this.fwd();
        }
    }

    public T next() {
        if (this.hasNext()) {
            this.fwd();
            return this.get();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        this.cursor.remove();
    }

    public void reset() {
        this.cursor.reset();
        this.lookedForNext = false;
    }

    public double getDoublePosition(int arg0) {
        return this.cursor.getDoublePosition(arg0);
    }

    public float getFloatPosition(int arg0) {
        return this.cursor.getFloatPosition(arg0);
    }

    public void localize(float[] arg0) {
        this.cursor.localize(arg0);
    }

    public void localize(double[] arg0) {
        this.cursor.localize(arg0);
    }

    public int numDimensions() {
        return this.cursor.numDimensions();
    }

    public T get() {
        return (T)((Type)this.cursor.get());
    }

    public int getIntPosition(int arg0) {
        return this.cursor.getIntPosition(arg0);
    }

    public long getLongPosition(int arg0) {
        return this.cursor.getLongPosition(arg0);
    }

    public void localize(int[] arg0) {
        this.cursor.localize(arg0);
    }

    public void localize(long[] arg0) {
        this.cursor.localize(arg0);
    }

    public Cursor<T> copy() {
        return new PredicateCursor<T>(this.cursor.copyCursor(), this.predicate);
    }
}

