/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Point2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.point.PointSets2D;
import math.geom2d.polygon.LinearCurve2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Polylines2D {
    public static final boolean hasMultipleVertices(LinearCurve2D polyline) {
        return Polylines2D.hasMultipleVertices(polyline, false);
    }

    public static final boolean hasMultipleVertices(LinearCurve2D polyline, boolean closed) {
        Point2D p2;
        Point2D p1;
        if (PointSets2D.hasMultipleVertices(polyline.vertices)) {
            return true;
        }
        return closed && (p1 = polyline.firstPoint()).distance(p2 = polyline.lastPoint()) < 1.0E-12;
    }

    public static Collection<Point2D> intersect(LinearCurve2D poly1, LinearCurve2D poly2) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (LineSegment2D edge1 : poly1.edges()) {
            for (LineSegment2D edge2 : poly2.edges()) {
                Point2D point = edge1.intersection(edge2);
                if (point == null || points.contains(point)) continue;
                points.add(point);
            }
        }
        return points;
    }
}

