/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.Cache;
import net.imglib2.cache.iotiming.CacheIoTiming;
import net.imglib2.cache.iotiming.IoStatistics;
import net.imglib2.cache.iotiming.IoTimeBudget;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.CreateInvalid;
import net.imglib2.cache.volatiles.VolatileCache;

public class WeakRefVolatileCache<K, V>
implements VolatileCache<K, V> {
    final ConcurrentHashMap<K, Entry> map = new ConcurrentHashMap();
    final ReferenceQueue<V> queue = new ReferenceQueue();
    final Cache<K, V> backingCache;
    final BlockingFetchQueues<Callable<?>> fetchQueue;
    final CreateInvalid<? super K, ? extends V> createInvalid;
    static final int NOTLOADED = 0;
    static final int INVALID = 1;
    static final int VALID = 2;

    public WeakRefVolatileCache(Cache<K, V> backingCache, BlockingFetchQueues<Callable<?>> fetchQueue, CreateInvalid<? super K, ? extends V> createInvalid) {
        this.backingCache = backingCache;
        this.fetchQueue = fetchQueue;
        this.createInvalid = createInvalid;
    }

    @Override
    public V getIfPresent(Object key, CacheHints hints) throws ExecutionException {
        Entry entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        CacheWeakReference ref = entry.ref;
        Object v = ref.get();
        if (v != null && ref.loaded == 2) {
            return (V)v;
        }
        this.cleanUp();
        switch (hints.getLoadingStrategy()) {
            case BLOCKING: {
                return this.getBlocking(entry);
            }
            case BUDGETED: {
                if (this.estimatedBugdetTimeLeft(hints) > 0L) {
                    return this.getBudgeted(entry, hints);
                }
            }
            case VOLATILE: {
                this.enqueue(entry, hints);
            }
        }
        return (V)v;
    }

    @Override
    public V get(K key, CacheHints hints) throws ExecutionException {
        Entry entry = this.map.computeIfAbsent(key, k -> new Entry(k));
        CacheWeakReference ref = entry.ref;
        Object v = ref.get();
        if (v != null && ref.loaded == 2) {
            return (V)v;
        }
        this.cleanUp();
        switch (hints.getLoadingStrategy()) {
            case BLOCKING: {
                v = this.getBlocking(entry);
                break;
            }
            case BUDGETED: {
                v = this.getBudgeted(entry, hints);
                break;
            }
            case VOLATILE: {
                v = this.getVolatile(entry, hints);
                break;
            }
            case DONTLOAD: {
                v = this.getDontLoad(entry);
            }
        }
        if (v == null) {
            return this.get(key, hints);
        }
        return (V)v;
    }

    public void cleanUp() {
        CacheWeakReference poll;
        while ((poll = (CacheWeakReference)this.queue.poll()) != null) {
            poll.clean();
        }
    }

    @Override
    public void invalidate(K key) {
        try {
            this.fetchQueue.pause();
            Entry entry = this.map.remove(key);
            if (entry != null) {
                CacheWeakReference ref = entry.ref;
                if (ref != null) {
                    ref.clear();
                }
                entry.ref = null;
            }
            this.backingCache.invalidate(key);
            this.fetchQueue.resume();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        try {
            this.fetchQueue.pause();
            this.map.forEachValue(parallelismThreshold, entry -> {
                if (condition.test(entry.key)) {
                    entry.remove();
                    CacheWeakReference ref = entry.ref;
                    if (ref != null) {
                        ref.clear();
                    }
                    entry.ref = null;
                }
            });
            this.backingCache.invalidateIf(parallelismThreshold, condition);
            this.fetchQueue.resume();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        try {
            this.fetchQueue.pause();
            this.map.forEachValue(parallelismThreshold, entry -> {
                entry.remove();
                CacheWeakReference ref = entry.ref;
                if (ref != null) {
                    ref.clear();
                }
                entry.ref = null;
            });
            this.backingCache.invalidateAll(parallelismThreshold);
            this.fetchQueue.resume();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getDontLoad(Entry entry) throws ExecutionException {
        Entry entry2 = entry;
        synchronized (entry2) {
            CacheWeakReference ref = entry.ref;
            Object v = ref.get();
            if (v == null && ref.loaded != 0) {
                this.map.remove(entry.key, entry);
                return null;
            }
            if (ref.loaded == 2) {
                return (V)v;
            }
            Object vl = this.backingCache.getIfPresent(entry.key);
            if (vl != null) {
                entry.setValid(vl);
                return vl;
            }
            if (ref.loaded == 0) {
                v = entry.tryCreateInvalid();
                entry.setInvalid(v);
            }
            return (V)v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getVolatile(Entry entry, CacheHints hints) throws ExecutionException {
        Entry entry2 = entry;
        synchronized (entry2) {
            CacheWeakReference ref = entry.ref;
            Object v = ref.get();
            if (v == null && ref.loaded != 0) {
                this.map.remove(entry.key, entry);
                return null;
            }
            if (ref.loaded == 2) {
                return (V)v;
            }
            Object vl = this.backingCache.getIfPresent(entry.key);
            if (vl != null) {
                entry.setValid(vl);
                return vl;
            }
            if (ref.loaded == 0) {
                v = entry.tryCreateInvalid();
                entry.setInvalid(v);
            }
            this.enqueue(entry, hints);
            return (V)v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getBudgeted(Entry entry, CacheHints hints) throws ExecutionException {
        Entry entry2 = entry;
        synchronized (entry2) {
            CacheWeakReference ref = entry.ref;
            Object v = ref.get();
            if (v == null && ref.loaded != 0) {
                this.map.remove(entry.key, entry);
                return null;
            }
            if (ref.loaded == 2) {
                return (V)v;
            }
            Object vl = this.backingCache.getIfPresent(entry.key);
            if (vl != null) {
                entry.setValid(vl);
                return vl;
            }
            this.enqueue(entry, hints);
            int priority = hints.getQueuePriority();
            IoStatistics stats = CacheIoTiming.getIoStatistics();
            IoTimeBudget budget = stats.getIoTimeBudget();
            long timeLeft = budget.timeLeft(priority);
            if (timeLeft > 0L) {
                long t0 = stats.getIoNanoTime();
                stats.start();
                try {
                    entry.wait(timeLeft / 1000000L, 1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                stats.stop();
                long t = stats.getIoNanoTime() - t0;
                budget.use(t, priority);
            }
            if ((v = (ref = entry.ref).get()) == null) {
                if (ref.loaded == 0) {
                    v = entry.tryCreateInvalid();
                    entry.setInvalid(v);
                    return (V)v;
                }
                this.map.remove(entry.key, entry);
                return null;
            }
            return (V)v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getBlocking(Entry entry) throws ExecutionException {
        Entry entry2 = entry;
        synchronized (entry2) {
            CacheWeakReference ref = entry.ref;
            Object v = ref.get();
            if (v == null && ref.loaded != 0) {
                this.map.remove(entry.key, entry);
                return null;
            }
            if (ref.loaded == 2) {
                return (V)v;
            }
        }
        V vl = this.backingCache.get(entry.key);
        Entry entry3 = entry;
        synchronized (entry3) {
            CacheWeakReference ref = entry.ref;
            Object v = ref.get();
            if (v == null && ref.loaded != 0) {
                this.map.remove(entry.key, entry);
                return null;
            }
            if (ref.loaded == 2) {
                return (V)v;
            }
            entry.setValid(vl);
            return vl;
        }
    }

    private void enqueue(Entry entry, CacheHints hints) {
        long currentQueueFrame = this.fetchQueue.getCurrentFrame();
        if (entry.enqueueFrame < currentQueueFrame) {
            entry.enqueueFrame = currentQueueFrame;
            this.fetchQueue.put(new FetchEntry(entry.key), hints.getQueuePriority(), hints.isEnqueuToFront());
        }
    }

    private long estimatedBugdetTimeLeft(CacheHints hints) {
        int priority = hints.getQueuePriority();
        IoStatistics stats = CacheIoTiming.getIoStatistics();
        IoTimeBudget budget = stats.getIoTimeBudget();
        return budget.estimateTimeLeft(priority);
    }

    final class FetchEntry
    implements Callable<Void> {
        final K key;

        public FetchEntry(K key) {
            this.key = key;
        }

        @Override
        public Void call() throws ExecutionException {
            Entry entry = WeakRefVolatileCache.this.map.get(this.key);
            if (entry != null) {
                WeakRefVolatileCache.this.getBlocking(entry);
            }
            return null;
        }
    }

    final class Entry {
        final K key;
        CacheWeakReference<V> ref;
        long enqueueFrame;

        public Entry(K key) {
            this.key = key;
            this.ref = new CacheWeakReference<Object>(null);
            this.enqueueFrame = -1L;
        }

        public void setInvalid(V value) {
            this.ref = new CacheWeakReference(value, WeakRefVolatileCache.this.queue, this, 1);
        }

        public void setValid(V value) {
            this.ref = new CacheWeakReference(value, WeakRefVolatileCache.this.queue, this, 2);
            this.enqueueFrame = Long.MAX_VALUE;
            this.notifyAll();
        }

        public void remove() {
            WeakRefVolatileCache.this.map.remove(this.key, this);
        }

        public V tryCreateInvalid() throws ExecutionException {
            try {
                return WeakRefVolatileCache.this.createInvalid.createInvalid(this.key);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ExecutionException(e);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    static final class CacheWeakReference<V>
    extends WeakReference<V> {
        private final Entry entry;
        final int loaded;

        public CacheWeakReference(V referent) {
            super(referent);
            this.entry = null;
            this.loaded = 0;
        }

        public CacheWeakReference(V referent, ReferenceQueue<V> remove, Entry entry, int loaded) {
            super(referent, remove);
            this.entry = entry;
            this.loaded = loaded;
        }

        public void clean() {
            if (this.entry.ref == this) {
                this.entry.remove();
            }
        }
    }
}

