/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.window;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.View;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class FocusWindowAction
extends AbstractAction {
    public static final String ID = "window.focus";
    @Nullable
    private View view;
    private PropertyChangeListener ppc;

    public FocusWindowAction(@Nullable View view) {
        this.view = view;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
        this.setEnabled(view != null);
        this.ppc = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("title")) {
                    FocusWindowAction.this.putValue("Name", evt.getNewValue());
                }
            }
        };
        if (view != null) {
            view.addPropertyChangeListener(this.ppc);
        }
    }

    public void dispose() {
        this.setView(null);
    }

    public void setView(@Nullable View newValue) {
        if (this.view != null) {
            this.view.removePropertyChangeListener(this.ppc);
        }
        this.view = newValue;
        if (this.view != null) {
            this.view.addPropertyChangeListener(this.ppc);
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name" && this.view != null) {
            return this.getTitle();
        }
        return super.getValue(key);
    }

    private String getTitle() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        String title = labels.getString("unnamedFile");
        if (this.view != null) {
            URI uri = this.view.getURI();
            title = uri == null ? labels.getString("unnamedFile") : URIUtil.getName(uri);
            if (this.view.hasUnsavedChanges()) {
                title = title + "*";
            }
            title = labels.getFormatted("internalFrame.title", title, this.view.getApplication() == null ? "" : this.view.getApplication().getName(), this.view.getMultipleOpenId());
        }
        return title;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.view.getComponent());
    }

    private Component getRootPaneContainer() {
        return SwingUtilities.getRootPane(this.view.getComponent()).getParent();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component rpContainer = this.getRootPaneContainer();
        if (rpContainer instanceof Frame) {
            Frame frame = (Frame)rpContainer;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.toFront();
        } else if (rpContainer instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)rpContainer;
            frame.toFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.view.getComponent().requestFocusInWindow();
    }
}

