/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;

public class ConnectorHandle
extends AbstractHandle {
    @Nullable
    private ConnectionFigure createdConnection;
    private ConnectionFigure prototype;
    private Connector connector;
    @Nullable
    private Figure connectableFigure;
    @Nullable
    private Connector connectableConnector;
    protected Collection<Connector> connectors = Collections.emptyList();

    public ConnectorHandle(Connector connector, ConnectionFigure prototype) {
        super(connector.getOwner());
        this.connector = connector;
        this.prototype = prototype;
    }

    public Point2D.Double getLocationOnDrawing() {
        return this.connector.getAnchor();
    }

    public Point getLocation() {
        return this.view.drawingToView(this.connector.getAnchor());
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.transform(this.view.getDrawingToViewTransform());
        for (Connector c : this.connectors) {
            c.draw(gg);
        }
        if (this.createdConnection == null) {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.DISCONNECTED_CONNECTOR_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.DISCONNECTED_CONNECTOR_HANDLE_STROKE_COLOR));
        } else {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTOR_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTOR_HANDLE_STROKE_COLOR));
            Point p = this.view.drawingToView(this.createdConnection.getEndPoint());
            g.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTOR_HANDLE_FILL_COLOR));
            int width = this.getHandlesize();
            g.fillOval(p.x - width / 2, p.y - width / 2, width, width);
            g.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTOR_HANDLE_STROKE_COLOR));
            g.drawOval(p.x - width / 2, p.y - width / 2, width, width);
        }
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.setConnection(this.createConnection());
        Point2D.Double p = this.getLocationOnDrawing();
        this.getConnection().setStartPoint(p);
        this.getConnection().setEndPoint(p);
        this.view.getDrawing().add(this.getConnection());
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        this.fireAreaInvalidated(this.getDrawingArea());
        Figure figure = this.findConnectableFigure(p, this.view.getDrawing());
        if (figure != this.connectableFigure) {
            this.connectableFigure = figure;
            this.repaintConnectors();
        }
        this.connectableConnector = this.findConnectableConnector(figure, p);
        if (this.connectableConnector != null) {
            p = this.connectableConnector.getAnchor();
        }
        this.getConnection().willChange();
        this.getConnection().setEndPoint(p);
        this.getConnection().changed();
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    @Override
    public Rectangle getDrawingArea() {
        if (this.getConnection() != null) {
            Rectangle r = new Rectangle(this.view.drawingToView(this.getConnection().getEndPoint()));
            r.grow(this.getHandlesize(), this.getHandlesize());
            return r;
        }
        return new Rectangle();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        this.view.getConstrainer().constrainPoint(p);
        Figure f = this.findConnectableFigure(p, this.view.getDrawing());
        this.connectableConnector = this.findConnectableConnector(f, p);
        if (this.connectableConnector != null) {
            final Drawing drawing = this.view.getDrawing();
            final ConnectionFigure c = this.getConnection();
            this.getConnection().setStartConnector(this.connector);
            this.getConnection().setEndConnector(this.connectableConnector);
            this.getConnection().updateConnection();
            this.view.clearSelection();
            this.view.addToSelection(c);
            this.view.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("edit.createConnectionFigure.text");
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    drawing.remove(c);
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    drawing.add(c);
                    ConnectorHandle.this.view.clearSelection();
                    ConnectorHandle.this.view.addToSelection(c);
                }
            });
        } else {
            this.view.getDrawing().remove(this.getConnection());
            this.fireAreaInvalidated(this.getDrawingArea());
        }
        this.connectableConnector = null;
        this.connectors = Collections.emptyList();
        this.setConnection(null);
        this.setTargetFigure(null);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.prototype.clone();
    }

    protected void setConnection(@Nullable ConnectionFigure newConnection) {
        this.createdConnection = newConnection;
    }

    @Nullable
    protected ConnectionFigure getConnection() {
        return this.createdConnection;
    }

    @Nullable
    protected Figure getTargetFigure() {
        return this.connectableFigure;
    }

    protected void setTargetFigure(@Nullable Figure newTargetFigure) {
        this.connectableFigure = newTargetFigure;
    }

    @Nullable
    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure.includes(this.getConnection()) || !figure.isConnectable() || !figure.contains(p)) continue;
            return figure;
        }
        return null;
    }

    @Nullable
    protected Connector findConnectableConnector(Figure connectableFigure, Point2D.Double p) {
        Connector target;
        Connector connector = target = connectableFigure == null ? null : connectableFigure.findConnector(p, this.getConnection());
        if (connectableFigure != null && connectableFigure.isConnectable() && !connectableFigure.includes(this.getOwner()) && this.getConnection().canConnect(this.connector, target)) {
            return target;
        }
        return null;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    public void repaintConnectors() {
        Rectangle2D.Double invalidArea = null;
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        this.connectors = this.connectableFigure == null ? new LinkedList<Connector>() : this.connectableFigure.getConnectors(this.prototype);
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        if (invalidArea != null) {
            this.view.getComponent().repaint(this.view.drawingToView(invalidArea));
        }
    }
}

