/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.Pane;
import javax.swing.JFrame;
import net.imagej.Dataset;
import net.imagej.ImageJ;
import org.scijava.ui.DialogPrompt;
import sc.fiji.filamentdetector.gui.controller.Controller;

public class GUIUtils {
    public static Pane loadFXML(String fxml, Controller controller) {
        try {
            URL fxmlUrl = GUIUtils.class.getResource(fxml);
            FXMLLoader loader = new FXMLLoader(fxmlUrl);
            loader.setController((Object)controller);
            Pane pane = (Pane)loader.load();
            if (controller != null) {
                controller.setPane(pane);
            }
            return pane;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void positionWindow(JFrame gui, Component component) {
        if (null != component) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            int screenWidth = 0;
            for (int i = 0; i < gs.length; ++i) {
                DisplayMode dm = gs[i].getDisplayMode();
                screenWidth += dm.getWidth();
            }
            Point windowLoc = component.getLocation();
            Dimension windowSize = component.getSize();
            Dimension guiSize = gui.getSize();
            if (guiSize.width > windowLoc.x) {
                if (guiSize.width > screenWidth - (windowLoc.x + windowSize.width)) {
                    gui.setLocationRelativeTo(null);
                } else {
                    gui.setLocation(windowLoc.x + windowSize.width, windowLoc.y);
                }
            } else {
                gui.setLocation(windowLoc.x - guiSize.width, windowLoc.y);
            }
        } else {
            gui.setLocationRelativeTo(null);
        }
    }

    public static final void userCheckImpDimensions(ImageJ ij, Dataset dataset) {
        if (dataset.getFrames() < dataset.getDepth()) {
            String message = "It appears this image has " + dataset.getFrames() + " timepoint (T) but " + dataset.getDepth() + " slices (Z).\nIt could be that dimensions are swapped.If you think it's the case please use \"Image > Hyperstacks > Re order Hyperstacks\".";
            ij.ui().showDialog(message, "Are Z and T dimensions swapped ?", DialogPrompt.MessageType.WARNING_MESSAGE);
        }
    }
}

