/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import org.imagearchive.lsm.reader.Reader;

public class LSM_Reader
extends ImagePlus
implements PlugIn {
    public static final String VERSION = LSM_Reader.version();
    public final String infoMessage = "LSM_Reader " + VERSION + " Copyright (C) 2002-2009 P. Pirrotte, J. Mutterer, Y. Krempp\n\nLSM_Reader is a lightweight cutdown version of LSMToolbox which\nis available at imagejdocu.tudor.lu or www.image-archive.org\nand offers many more features. This software is subject to the\nGNU General Public License. Please read source code headers\n\nWorks on images generated by LSM 510 version 2.8 to 4.0, Zen 2009\nContacts :\n\npatrick@image-archive.org\njerome.mutterer@ibmp.fr\n";

    private static String version() {
        String version = null;
        Package lsmPackage = Reader.class.getPackage();
        if (lsmPackage != null) {
            version = lsmPackage.getImplementationVersion();
        }
        return version == null ? "DEV" : version;
    }

    public void run(String arg) {
        if (arg.equals("about")) {
            this.showAbout();
            return;
        }
        if (IJ.versionLessThan((String)"1.46")) {
            return;
        }
        OpenDialog od = new OpenDialog("Open LSM...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + directory + name));
        ImagePlus imp = new Reader().open(directory + name);
        if (imp == null) {
            return;
        }
        this.setStack(imp.getTitle(), imp.getStack());
        FileInfo fi = imp.getOriginalFileInfo();
        if (imp.isComposite()) {
            new FileSaver(imp).saveDisplayRangesAndLuts(imp, fi);
        }
        this.setFileInfo(fi);
        this.setCalibration(imp.getCalibration());
        this.setDimensions(imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
        if (imp.getNChannels() * imp.getNFrames() != 1) {
            this.setOpenAsHyperStack(true);
        }
        if (arg.equals("")) {
            this.show();
        }
    }

    public void showAbout() {
        IJ.showMessage((String)this.infoMessage);
    }

    public ImagePlus open(String filename, boolean verbose) {
        return new Reader().open(filename, verbose);
    }

    public ImagePlus open(String directory, String filename, boolean verbose, boolean thumb) {
        return new Reader().open(directory, filename, verbose, thumb);
    }
}

