/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ui;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.node.NodeParametersFactory;
import edu.utexas.clm.archipelago.network.shell.NodeShell;
import edu.utexas.clm.archipelago.network.shell.NodeShellParameters;
import edu.utexas.clm.archipelago.ui.ClusterUI;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;

public class NodeConfigurationUI
extends Panel
implements ActionListener {
    private final NodeParametersFactory paramFactory;
    private final Vector<NodePanel> nodePanels;
    private final Vector<Long> removedNodes;
    private final Panel centralPanel = new Panel();
    private static final int H_BUTTON = 32;
    private static final int W_BUTTON = 480;

    private NodeConfigurationUI(NodeParametersFactory factory, Collection<NodeParameters> nodeParams) {
        ScrollPane pane = new ScrollPane();
        Button addButton = new Button("Add Node...");
        Button editAllButton = new Button("Edit all...");
        Dimension buttonSize = new Dimension(480, 32);
        FijiArchipelago.debug("NodeConfigUI got " + nodeParams.size() + " existing parameters");
        this.nodePanels = new Vector();
        this.removedNodes = new Vector();
        this.paramFactory = factory;
        super.setLayout(new BoxLayout(this, 1));
        super.add(pane);
        super.add(editAllButton);
        super.add(addButton);
        addButton.addActionListener(this);
        editAllButton.addActionListener(this);
        addButton.setActionCommand("add");
        editAllButton.setActionCommand("edit");
        this.centralPanel.setLayout(new BoxLayout(this.centralPanel, 1));
        pane.add(this.centralPanel);
        super.setMinimumSize(new Dimension(512, 256));
        super.setPreferredSize(new Dimension(512, 256));
        addButton.setPreferredSize(new Dimension(buttonSize));
        addButton.setSize(new Dimension(buttonSize));
        addButton.setMaximumSize(new Dimension(buttonSize));
        addButton.setMinimumSize(new Dimension(buttonSize));
        editAllButton.setPreferredSize(new Dimension(buttonSize));
        editAllButton.setSize(new Dimension(buttonSize));
        editAllButton.setMaximumSize(new Dimension(buttonSize));
        editAllButton.setMinimumSize(new Dimension(buttonSize));
        for (NodeParameters p : nodeParams) {
            this.addNode(p);
        }
        super.validate();
    }

    private NodePanel addNode(NodeParameters p) {
        NodePanel panel = new NodePanel(p);
        this.nodePanels.add(panel);
        this.centralPanel.add(panel);
        this.centralPanel.validate();
        super.validate();
        return panel;
    }

    private void removeNodePanel(NodePanel panel) {
        this.nodePanels.remove(panel);
        this.centralPanel.remove(panel);
        this.removedNodes.add(panel.getNodeParam().getID());
        super.validate();
    }

    private boolean editParams(NodeParameters param, String title, boolean editHost) {
        GenericDialog gd = new GenericDialog(title);
        NodeShellPanel nsp = new NodeShellPanel(param);
        if (editHost) {
            gd.addStringField("Hostname", param.getHost(), Math.max(param.getHost().length(), 64));
        }
        gd.addStringField("User name", param.getUser());
        gd.addNumericField("Thread Limit", (double)param.getThreadLimit(), 0);
        gd.addStringField("Remote Fiji Root", param.getExecRoot(), 64);
        gd.addStringField("Remote File Root", param.getFileRoot(), 64);
        gd.addPanel((Panel)nsp);
        gd.validate();
        gd.showDialog();
        if (gd.wasOKed()) {
            if (editHost) {
                param.setHost(gd.getNextString());
            }
            param.setUser(gd.getNextString());
            param.setThreadLimit((int)gd.getNextNumber());
            param.setExecRoot(gd.getNextString());
            param.setFileRoot(gd.getNextString());
            nsp.syncParams();
        }
        return gd.wasOKed();
    }

    private void addNewNode() {
        NodePanel np = this.addNode(this.paramFactory.getNewParameters(""));
        if (!np.doEdit()) {
            this.removeNodePanel(np);
        }
    }

    private void setAllUser(String user) {
        for (NodePanel np : this.nodePanels) {
            np.param.setUser(user);
        }
    }

    private void setAllFileRoot(String fileRoot) {
        for (NodePanel np : this.nodePanels) {
            np.param.setFileRoot(fileRoot);
        }
    }

    private void setAllExecRoot(String execRoot) {
        for (NodePanel np : this.nodePanels) {
            np.param.setExecRoot(execRoot);
        }
    }

    private void setAllThreadLimit(int threads) {
        for (NodePanel np : this.nodePanels) {
            np.param.setThreadLimit(threads);
        }
    }

    private void setAllShell(NodeShell shell) {
        for (NodePanel np : this.nodePanels) {
            np.param.setShell(shell, shell.defaultParameters());
        }
    }

    private void setAllShellParams(NodeShellParameters paramsNew, NodeShellParameters paramsOrig) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : paramsNew.getKeys()) {
            String value = paramsNew.getStringOrEmpty(key);
            if (value.equals(paramsOrig.getStringOrEmpty(key))) continue;
            map.put(key, value);
        }
        for (NodePanel np : this.nodePanels) {
            for (String key : map.keySet()) {
                try {
                    np.param.getShellParams().putValue(key, (String)map.get(key));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void bulkEdit() {
        if (this.nodePanels.size() < 1) {
            FijiArchipelago.err("No nodes to edit");
        } else {
            NodeParameters param = new NodeParameters(this.nodePanels.get((int)0).param);
            for (NodePanel np : this.nodePanels) {
                param.merge(np.param);
            }
            NodeParameters paramClone = new NodeParameters(param);
            if (this.editParams(param, "Edit All Nodes", false)) {
                if (!param.getUser().equals(paramClone.getUser())) {
                    this.setAllUser(param.getUser());
                }
                if (!param.getFileRoot().equals(paramClone.getFileRoot())) {
                    this.setAllFileRoot(param.getFileRoot());
                }
                if (!param.getExecRoot().equals(paramClone.getExecRoot())) {
                    this.setAllExecRoot(param.getExecRoot());
                }
                if (param.getThreadLimit() != paramClone.getThreadLimit()) {
                    this.setAllThreadLimit(param.getThreadLimit());
                }
                if (!param.getShell().name().equals(paramClone.getShell().name())) {
                    this.setAllShell(param.getShell());
                }
                this.setAllShellParams(param.getShellParams(), paramClone.getShellParams());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("add")) {
            this.addNewNode();
        } else if (actionEvent.getActionCommand().equals("edit")) {
            this.bulkEdit();
        } else assert (false);
    }

    public static void nodeConfigurationUI(Cluster cluster) {
        FijiArchipelago.debug("nodeConfigurationUI called");
        GenericDialog gd = new GenericDialog("Cluster Nodes");
        ArrayList<NodeParameters> existingParameters = cluster.getNodeParameters();
        NodeConfigurationUI ui = new NodeConfigurationUI(cluster.getParametersFactory(), existingParameters);
        gd.addPanel((Panel)ui);
        gd.showDialog();
        if (gd.wasOKed()) {
            FijiArchipelago.debug("Was ok'ed. Got " + ui.nodePanels.size() + " nodes");
            for (NodePanel np : ui.nodePanels) {
                NodeParameters param = np.getNodeParam();
                if (existingParameters.contains(param)) continue;
                cluster.startNode(param);
            }
        }
    }

    private class NodePanel
    extends Panel
    implements ActionListener {
        private final Label label;
        public final NodeParameters param;

        public NodePanel(NodeParameters param) {
            this.param = param;
            this.label = new Label();
            this.init();
        }

        private void init() {
            Button editButton = new Button("Edit");
            Button rmButton = new Button("Remove");
            this.add(this.label);
            this.add(editButton);
            this.add(rmButton);
            editButton.setActionCommand("edit");
            rmButton.setActionCommand("rm");
            editButton.addActionListener(this);
            rmButton.addActionListener(this);
            this.updateLabel();
        }

        private void updateLabel() {
            this.label.setText(this.param.getUser() + "@" + this.param.getHost());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("edit")) {
                this.doEdit();
            } else if (ae.getActionCommand().equals("rm")) {
                GenericDialog gd = new GenericDialog("Really Remove?");
                gd.addMessage("Really remove this node?");
                gd.showDialog();
                if (gd.wasOKed()) {
                    NodeConfigurationUI.this.removeNodePanel(this);
                }
            }
        }

        public boolean doEdit() {
            if (NodeConfigurationUI.this.editParams(this.param, "Edit Cluster Node", true)) {
                this.updateLabel();
                this.validate();
                return true;
            }
            return false;
        }

        public NodeParameters getNodeParam() {
            return this.param;
        }
    }

    private class NodeShellPanel
    extends Panel
    implements ItemListener {
        private final Hashtable<String, NodeShellParameters> parameterMap;
        private final Hashtable<String, TextField> textMap;
        private final Choice shellChoice;
        private final Collection<NodeShell> shells;
        private NodeShellParameters currentShellParam;
        private NodeShellParameters lastShellParam;
        private final NodeParameters nodeParam;
        private final Panel shellChoicePanel;

        public NodeShellPanel(NodeParameters param) {
            this.nodeParam = param;
            this.parameterMap = new Hashtable();
            this.textMap = new Hashtable();
            this.parameterMap.put(param.getShell().name(), param.getShellParams());
            this.currentShellParam = param.getShellParams();
            this.lastShellParam = null;
            this.shells = Cluster.registeredShells();
            this.shellChoicePanel = new Panel();
            this.setLayout(new BoxLayout(this, 1));
            this.shellChoice = new Choice();
            this.shellChoice.addItemListener(this);
            for (NodeShell shell : this.shells) {
                this.shellChoice.add(shell.name());
            }
            this.shellChoice.select(param.getShell().name());
            this.shellChoicePanel.add(this.shellChoice);
            this.refresh();
        }

        public synchronized void refresh() {
            FijiArchipelago.debug("Last Shell Param: " + this.lastShellParam);
            FijiArchipelago.debug("Current Shell Param: " + this.currentShellParam);
            if (this.lastShellParam != this.currentShellParam) {
                this.lastShellParam = this.currentShellParam;
                super.removeAll();
                super.add(this.shellChoicePanel);
                this.textMap.clear();
                FijiArchipelago.debug("Refreshing...");
                for (String key : this.currentShellParam.getKeys()) {
                    Panel p = new Panel();
                    final TextField tf = new TextField(this.currentShellParam.getStringOrEmpty(key), 48);
                    FijiArchipelago.debug("Adding key " + key);
                    this.textMap.put(key, tf);
                    if (this.currentShellParam.isFile(key)) {
                        Button fileSelect = new Button("Select file...");
                        p.add(fileSelect);
                        fileSelect.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                OpenDialog od = new OpenDialog("Select a file", null);
                                String dirName = od.getDirectory();
                                String fileName = od.getFileName();
                                if (fileName != null) {
                                    tf.setText(dirName + fileName);
                                }
                            }
                        });
                        ClusterUI.doRowPanelLayout(p, 640.0f, 24, new float[]{1.0f, 3.0f, 1.0f}, new Label(key), tf, fileSelect);
                    } else {
                        ClusterUI.doRowPanelLayout(p, 640.0f, 24, new float[]{1.0f, 4.0f}, new Label(key), tf);
                    }
                    super.add(p);
                }
            }
            this.validate();
        }

        public void syncParams() {
            for (String key : this.currentShellParam.getKeys()) {
                try {
                    this.currentShellParam.putValue(key, this.textMap.get(key).getText());
                }
                catch (Exception e) {
                    this.handleKeyError(key, e);
                }
            }
            for (NodeShell shell : this.shells) {
                if (!shell.name().equals(this.shellChoice.getSelectedItem())) continue;
                this.nodeParam.setShell(shell, this.currentShellParam);
                break;
            }
        }

        private void handleKeyError(String key, Exception e) {
            FijiArchipelago.err("Could not save key " + key + ": " + e);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            String selection = this.shellChoice.getSelectedItem();
            NodeShellParameters param = this.parameterMap.get(selection);
            if (param == null) {
                for (NodeShell shell : this.shells) {
                    if (!shell.name().equals(selection)) continue;
                    param = shell.defaultParameters();
                    this.parameterMap.put(selection, param);
                    break;
                }
            }
            this.currentShellParam = param;
            this.refresh();
        }
    }
}

