/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scijava.ui.behaviour.InputTrigger;

public class InputTriggerMap {
    private final Map<InputTrigger, Set<String>> triggerToKeys = new HashMap<InputTrigger, Set<String>>();
    private InputTriggerMap parent = null;
    private int expectedParentModCount = 0;
    private int modCount = 0;

    public void setParent(InputTriggerMap map) {
        this.parent = map;
        if (map != null) {
            this.expectedParentModCount = this.parent.modCount();
        }
        ++this.modCount;
    }

    public InputTriggerMap getParent() {
        return this.parent;
    }

    public synchronized void put(InputTrigger inputTrigger, String behaviourKey) {
        Set<String> behaviourKeys = this.triggerToKeys.get(inputTrigger);
        if (behaviourKeys == null) {
            behaviourKeys = new HashSet<String>();
            this.triggerToKeys.put(inputTrigger, behaviourKeys);
        }
        behaviourKeys.add(behaviourKey);
        ++this.modCount;
    }

    public synchronized Set<String> get(InputTrigger inputTrigger) {
        Set<Object> keys = null;
        keys = this.parent != null ? this.parent.get(inputTrigger) : new HashSet();
        keys.addAll((Collection)this.triggerToKeys.get(inputTrigger));
        return keys;
    }

    public synchronized void remove(InputTrigger inputTrigger, String behaviourKey) {
        Set<String> behaviourKeys = this.triggerToKeys.get(inputTrigger);
        if (behaviourKeys == null) {
            return;
        }
        behaviourKeys.remove(behaviourKey);
        if (behaviourKeys.isEmpty()) {
            this.triggerToKeys.remove(behaviourKeys);
        }
        ++this.modCount;
    }

    public synchronized void removeAll(InputTrigger inputTrigger) {
        this.triggerToKeys.remove(inputTrigger);
        ++this.modCount;
    }

    public synchronized void clear() {
        this.triggerToKeys.clear();
        ++this.modCount;
    }

    public synchronized Map<InputTrigger, Set<String>> getAllBindings() {
        Map<InputTrigger, Set<String>> allBindings = this.parent != null ? this.parent.getAllBindings() : new HashMap<InputTrigger, Set<String>>();
        this.addBindings(allBindings);
        return allBindings;
    }

    public synchronized Map<InputTrigger, Set<String>> getBindings() {
        HashMap<InputTrigger, Set<String>> bindings = new HashMap<InputTrigger, Set<String>>();
        this.addBindings(bindings);
        return bindings;
    }

    private void addBindings(Map<InputTrigger, Set<String>> bindings) {
        for (Map.Entry<InputTrigger, Set<String>> entry : this.triggerToKeys.entrySet()) {
            InputTrigger inputTrigger = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Set<String> behaviourKeys = bindings.get(inputTrigger);
            if (behaviourKeys == null) {
                behaviourKeys = new HashSet<String>();
                bindings.put(inputTrigger, behaviourKeys);
            }
            behaviourKeys.addAll((Collection<String>)entry.getValue());
        }
    }

    public int modCount() {
        int m;
        if (this.parent != null && (m = this.parent.modCount()) != this.expectedParentModCount) {
            this.expectedParentModCount = m;
            ++this.modCount;
        }
        return this.modCount;
    }
}

