/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.JPanelTrackerSettingsMain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import javax.swing.JScrollPane;

public class LAPTrackerSettingsPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JPanelTrackerSettingsMain jPanelMain;
    private final String trackerName;
    private final String spaceUnits;
    private final Collection<String> features;
    private final Map<String, String> featureNames;

    public LAPTrackerSettingsPanel(String trackerName, String spaceUnits, Collection<String> features, Map<String, String> featureNames) {
        this.trackerName = trackerName;
        this.spaceUnits = spaceUnits;
        this.features = features;
        this.featureNames = featureNames;
        this.initGUI();
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.jPanelMain.getSettings();
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.jPanelMain.echoSettings(settings);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setPreferredSize(new Dimension(300, 500));
            this.setLayout(thisLayout);
            JScrollPane jScrollPaneMain = new JScrollPane();
            this.add((Component)jScrollPaneMain, "Center");
            jScrollPaneMain.setVerticalScrollBarPolicy(22);
            jScrollPaneMain.setHorizontalScrollBarPolicy(31);
            jScrollPaneMain.getVerticalScrollBar().setUnitIncrement(24);
            this.jPanelMain = new JPanelTrackerSettingsMain(this.trackerName, this.spaceUnits, this.features, this.featureNames);
            jScrollPaneMain.setViewportView(this.jPanelMain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clean() {
    }
}

