/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.SIFT;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.MovingLeastSquaresTransform;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Spring;
import mpicbg.models.SpringMesh;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.TransformMesh;
import mpicbg.models.Transforms;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.util.Util;

public class ElasticAlign
implements PlugIn,
KeyListener {
    static final Param p = new Param();

    public static final AbstractModel<?> createModel(int modelIndex) {
        switch (modelIndex) {
            case 0: {
                return new TranslationModel2D();
            }
            case 1: {
                return new RigidModel2D();
            }
            case 2: {
                return new SimilarityModel2D();
            }
            case 3: {
                return new AffineModel2D();
            }
            case 4: {
                return new HomographyModel2D();
            }
        }
        return null;
    }

    public final void run(String args) {
        if (IJ.versionLessThan((String)"1.41n")) {
            return;
        }
        try {
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void run() throws Exception {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            System.err.println("There are no images open");
            return;
        }
        if (!p.setup(imp)) {
            return;
        }
        final ImageStack stack = imp.getStack();
        final double displayRangeMin = imp.getDisplayRangeMin();
        final double displayRangeMax = imp.getDisplayRangeMax();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        block17: for (int i = 0; i < stack.getSize(); ++i) {
            switch (ElasticAlign.p.modelIndexOptimize) {
                case 0: {
                    tiles.add(new Tile((Model)new TranslationModel2D()));
                    continue block17;
                }
                case 1: {
                    tiles.add(new Tile((Model)new RigidModel2D()));
                    continue block17;
                }
                case 2: {
                    tiles.add(new Tile((Model)new SimilarityModel2D()));
                    continue block17;
                }
                case 3: {
                    tiles.add(new Tile((Model)new AffineModel2D()));
                    continue block17;
                }
                case 4: {
                    tiles.add(new Tile((Model)new HomographyModel2D()));
                    continue block17;
                }
                default: {
                    return;
                }
            }
        }
        ArrayList<Triple<Integer, Integer, TranslationModel2D>> pairs = new ArrayList<Triple<Integer, Integer, TranslationModel2D>>();
        if (!ElasticAlign.p.isAligned) {
            void var13_21;
            ExecutorService execSift = Executors.newFixedThreadPool(ElasticAlign.p.maxNumThreadsSift);
            final AtomicInteger counter = new AtomicInteger(0);
            ArrayList<Future<ArrayList<Feature>>> siftTasks = new ArrayList<Future<ArrayList<Feature>>>();
            int i = 1;
            while (i <= stack.getSize()) {
                final int n = i++;
                siftTasks.add(execSift.submit(new Callable<ArrayList<Feature>>(){

                    @Override
                    public ArrayList<Feature> call() {
                        IJ.showProgress((int)counter.getAndIncrement(), (int)stack.getSize());
                        String path = ElasticAlign.p.outputPath + String.format("%05d", n - 1) + ".features";
                        ArrayList<Feature> fs = null;
                        if (!ElasticAlign.p.clearCache) {
                            fs = ElasticAlign.deserializeFeatures(ElasticAlign.p.sift, path);
                        }
                        if (fs == null) {
                            FloatArray2DSIFT sift = new FloatArray2DSIFT(ElasticAlign.p.sift);
                            SIFT ijSIFT = new SIFT(sift);
                            fs = new ArrayList<Feature>();
                            ImageProcessor ip = stack.getProcessor(n);
                            ip.setMinAndMax(displayRangeMin, displayRangeMax);
                            ijSIFT.extractFeatures(ip, fs);
                            if (!ElasticAlign.serializeFeatures(ElasticAlign.p.sift, fs, path)) {
                                IJ.log((String)("FAILED to store serialized features for " + String.format("%05d", n - 1)));
                            }
                        }
                        IJ.log((String)(fs.size() + " features extracted for slice " + String.format("%05d", n - 1)));
                        return fs;
                    }
                }));
            }
            for (Future future : siftTasks) {
                future.get();
            }
            siftTasks.clear();
            execSift.shutdown();
            counter.set(0);
            int numFailures = 0;
            boolean bl = false;
            while (var13_21 < stack.getSize()) {
                ArrayList threads = new ArrayList(ElasticAlign.p.maxNumThreads);
                void var15_28 = var13_21;
                int range = Math.min(stack.getSize(), (int)(var13_21 + ElasticAlign.p.maxNumNeighbors + true));
                void j = var13_21 + true;
                block21: while (j < range) {
                    int numThreads = Math.min(ElasticAlign.p.maxNumThreads, range - j);
                    ArrayList models = new ArrayList(numThreads);
                    for (int k = 0; k < numThreads; ++k) {
                        models.add(null);
                    }
                    int t22 = 0;
                    while (t22 < numThreads && j < range) {
                        int ti = t22++;
                        void sliceB = j++;
                        Thread thread = new Thread((int)var15_28, stack, (int)sliceB, models, ti){
                            final /* synthetic */ int val$sliceA;
                            final /* synthetic */ ImageStack val$stack;
                            final /* synthetic */ int val$sliceB;
                            final /* synthetic */ ArrayList val$models;
                            final /* synthetic */ int val$ti;
                            {
                                this.val$sliceA = n;
                                this.val$stack = imageStack;
                                this.val$sliceB = n2;
                                this.val$models = arrayList;
                                this.val$ti = n3;
                            }

                            @Override
                            public void run() {
                                boolean modelFound;
                                AbstractModel<?> model;
                                IJ.showProgress((int)this.val$sliceA, (int)(this.val$stack.getSize() - 1));
                                IJ.log((String)("matching " + this.val$sliceB + " -> " + this.val$sliceA + "..."));
                                ArrayList candidates = null;
                                String path = ElasticAlign.p.outputPath + String.format("%05d", this.val$sliceB) + "-" + String.format("%05d", this.val$sliceA) + ".pointmatches";
                                if (!ElasticAlign.p.clearCache) {
                                    candidates = ElasticAlign.deserializePointMatches(p, path);
                                }
                                if (null == candidates) {
                                    ArrayList fs1 = ElasticAlign.deserializeFeatures(ElasticAlign.p.sift, ElasticAlign.p.outputPath + String.format("%05d", this.val$sliceA) + ".features");
                                    ArrayList fs2 = ElasticAlign.deserializeFeatures(ElasticAlign.p.sift, ElasticAlign.p.outputPath + String.format("%05d", this.val$sliceB) + ".features");
                                    candidates = new ArrayList(FloatArray2DSIFT.createMatches((List)fs2, (List)fs1, (float)ElasticAlign.p.rod));
                                    if (!ElasticAlign.serializePointMatches(p, candidates, path)) {
                                        IJ.log((String)"Could not store point matches!");
                                    }
                                }
                                if ((model = ElasticAlign.createModel(ElasticAlign.p.modelIndex)) == null) {
                                    return;
                                }
                                ArrayList inliers = new ArrayList();
                                boolean again = false;
                                try {
                                    do {
                                        if (!(modelFound = model.filterRansac((List)candidates, inliers, 1000, (double)ElasticAlign.p.maxEpsilon, (double)ElasticAlign.p.minInlierRatio, ElasticAlign.p.minNumInliers, 3.0)) || !ElasticAlign.p.rejectIdentity) continue;
                                        ArrayList points = new ArrayList();
                                        PointMatch.sourcePoints(inliers, points);
                                        if (!Transforms.isIdentity(model, points, (double)ElasticAlign.p.identityTolerance)) continue;
                                        IJ.log((String)("Identity transform for " + inliers.size() + " matches rejected."));
                                        candidates.removeAll(inliers);
                                        inliers.clear();
                                        again = true;
                                    } while (again);
                                }
                                catch (Exception e) {
                                    modelFound = false;
                                    System.err.println(e.getMessage());
                                }
                                if (!modelFound) {
                                    IJ.log((String)(this.val$sliceB + " -> " + this.val$sliceA + ": no correspondences found."));
                                    return;
                                }
                                IJ.log((String)(this.val$sliceB + " -> " + this.val$sliceA + ": " + inliers.size() + " corresponding features with an average displacement of " + PointMatch.meanDistance(inliers) + "px identified."));
                                IJ.log((String)("Estimated transformation model: " + model));
                                this.val$models.set(this.val$ti, new Triple(this.val$sliceA, this.val$sliceB, model));
                            }
                        };
                        threads.add(thread);
                        thread.start();
                    }
                    try {
                        Iterator t22 = threads.iterator();
                        while (t22.hasNext()) {
                            Thread thread232 = (Thread)t22.next();
                            thread232.join();
                        }
                    }
                    catch (InterruptedException e) {
                        IJ.log((String)"Establishing feature correspondences interrupted.");
                        Iterator thread232 = threads.iterator();
                        while (thread232.hasNext()) {
                            Thread thread = (Thread)thread232.next();
                            thread.interrupt();
                        }
                        try {
                            thread232 = threads.iterator();
                            while (thread232.hasNext()) {
                                Thread thread = (Thread)thread232.next();
                                thread.join();
                            }
                        }
                        catch (InterruptedException thread232) {
                            // empty catch block
                        }
                        return;
                    }
                    threads.clear();
                    for (int t = 0; t < models.size(); ++t) {
                        Triple pair = (Triple)models.get(t);
                        if (pair == null) {
                            if (++numFailures <= ElasticAlign.p.maxNumFailures) continue;
                            break block21;
                        }
                        numFailures = 0;
                        pairs.add(pair);
                    }
                }
                ++var13_21;
            }
        } else {
            for (int i = 0; i < stack.getSize(); ++i) {
                int range = Math.min(stack.getSize(), i + ElasticAlign.p.maxNumNeighbors + 1);
                for (int j = i + 1; j < range; ++j) {
                    pairs.add(new Triple<Integer, Integer, TranslationModel2D>(i, j, new TranslationModel2D()));
                }
            }
        }
        TileConfiguration initMeshes = new TileConfiguration();
        ArrayList<SpringMesh> meshes = new ArrayList<SpringMesh>(stack.getSize());
        for (int i = 0; i < stack.getSize(); ++i) {
            meshes.add(new SpringMesh(ElasticAlign.p.resolutionSpringMesh, (double)stack.getWidth(), (double)stack.getHeight(), ElasticAlign.p.stiffnessSpringMesh, ElasticAlign.p.maxStretchSpringMesh, ElasticAlign.p.dampSpringMesh));
        }
        int blockRadius = Math.max(Util.roundPos((double)(16.0 / ElasticAlign.p.sectionScale)), ElasticAlign.p.blockRadius);
        int searchRadius = ElasticAlign.p.searchRadius;
        AbstractModel<?> abstractModel = ElasticAlign.createModel(ElasticAlign.p.localModelIndex);
        for (Triple triple : pairs) {
            Vertex p2;
            Vertex p1;
            FloatProcessor ip2Mask;
            FloatProcessor ip1Mask;
            SpringMesh m1 = (SpringMesh)meshes.get((Integer)triple.a);
            SpringMesh m2 = (SpringMesh)meshes.get((Integer)triple.b);
            ArrayList pm12 = new ArrayList();
            ArrayList pm21 = new ArrayList();
            ArrayList v1 = m1.getVertices();
            ArrayList v2 = m2.getVertices();
            FloatProcessor ip1 = (FloatProcessor)stack.getProcessor((Integer)triple.a + 1).convertToFloat().duplicate();
            FloatProcessor ip2 = (FloatProcessor)stack.getProcessor((Integer)triple.b + 1).convertToFloat().duplicate();
            if (imp.getType() == 4 && ElasticAlign.p.mask) {
                ip1Mask = ElasticAlign.createMask(stack.getProcessor((Integer)triple.a + 1));
                ip2Mask = ElasticAlign.createMask(stack.getProcessor((Integer)triple.b + 1));
            } else {
                ip1Mask = null;
                ip2Mask = null;
            }
            try {
                BlockMatching.matchByMaximalPMCC((FloatProcessor)ip1, (FloatProcessor)ip2, (FloatProcessor)ip1Mask, (FloatProcessor)ip2Mask, (double)Math.min(1.0, ElasticAlign.p.sectionScale), (CoordinateTransform)((InvertibleCoordinateTransform)triple.c).createInverse(), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)ElasticAlign.p.minR, (float)ElasticAlign.p.rodR, (float)ElasticAlign.p.maxCurvatureR, (Collection)v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
            }
            catch (InterruptedException e) {
                IJ.log((String)"Block matching interrupted.");
                IJ.showProgress((double)1.0);
                return;
            }
            if (Thread.interrupted()) {
                IJ.log((String)"Block matching interrupted.");
                IJ.showProgress((double)1.0);
                return;
            }
            if (ElasticAlign.p.useLocalSmoothnessFilter) {
                IJ.log((String)(triple.a + " > " + triple.b + ": found " + pm12.size() + " correspondence candidates."));
                abstractModel.localSmoothnessFilter(pm12, pm12, (double)ElasticAlign.p.localRegionSigma, (double)ElasticAlign.p.maxLocalEpsilon, (double)ElasticAlign.p.maxLocalTrust);
                IJ.log((String)(triple.a + " > " + triple.b + ": " + pm12.size() + " candidates passed local smoothness filter."));
            } else {
                IJ.log((String)(triple.a + " > " + triple.b + ": found " + pm12.size() + " correspondences."));
            }
            try {
                BlockMatching.matchByMaximalPMCC((FloatProcessor)ip2, (FloatProcessor)ip1, (FloatProcessor)ip2Mask, (FloatProcessor)ip1Mask, (double)Math.min(1.0, ElasticAlign.p.sectionScale), (CoordinateTransform)((CoordinateTransform)triple.c), (int)blockRadius, (int)blockRadius, (int)searchRadius, (int)searchRadius, (float)ElasticAlign.p.minR, (float)ElasticAlign.p.rodR, (float)ElasticAlign.p.maxCurvatureR, (Collection)v2, pm21, (ErrorStatistic)new ErrorStatistic(1));
            }
            catch (InterruptedException e) {
                IJ.log((String)"Block matching interrupted.");
                IJ.showProgress((double)1.0);
                return;
            }
            if (Thread.interrupted()) {
                IJ.log((String)"Block matching interrupted.");
                IJ.showProgress((double)1.0);
                return;
            }
            if (ElasticAlign.p.useLocalSmoothnessFilter) {
                IJ.log((String)(triple.a + " < " + triple.b + ": found " + pm21.size() + " correspondence candidates."));
                abstractModel.localSmoothnessFilter(pm21, pm21, (double)ElasticAlign.p.localRegionSigma, (double)ElasticAlign.p.maxLocalEpsilon, (double)ElasticAlign.p.maxLocalTrust);
                IJ.log((String)(triple.a + " < " + triple.b + ": " + pm21.size() + " candidates passed local smoothness filter."));
            } else {
                IJ.log((String)(triple.a + " < " + triple.b + ": found " + pm21.size() + " correspondences."));
            }
            double springConstant = 1.0 / (double)((Integer)triple.b - (Integer)triple.a);
            IJ.log((String)(triple.a + " <> " + triple.b + " spring constant = " + springConstant));
            for (PointMatch pm : pm12) {
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, springConstant));
                m2.addPassiveVertex(p2);
            }
            for (PointMatch pm : pm21) {
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, springConstant));
                m1.addPassiveVertex(p2);
            }
            Tile t1 = (Tile)tiles.get((Integer)triple.a);
            Tile t2 = (Tile)tiles.get((Integer)triple.b);
            if (pm12.size() > ((AbstractModel)triple.c).getMinNumMatches()) {
                initMeshes.addTile(t1);
                initMeshes.addTile(t2);
                t1.connect(t2, pm12);
            }
            if (pm21.size() <= ((AbstractModel)triple.c).getMinNumMatches()) continue;
            initMeshes.addTile(t1);
            initMeshes.addTile(t2);
            t2.connect(t1, pm21);
        }
        initMeshes.optimize((double)ElasticAlign.p.maxEpsilon, ElasticAlign.p.maxIterationsSpringMesh, ElasticAlign.p.maxPlateauwidthSpringMesh);
        for (int i = 0; i < stack.getSize(); ++i) {
            ((SpringMesh)meshes.get(i)).init((CoordinateTransform)((Tile)tiles.get(i)).getModel());
        }
        try {
            long t0 = System.currentTimeMillis();
            IJ.log((String)"Optimizing spring meshes...");
            SpringMesh.optimizeMeshes(meshes, (double)ElasticAlign.p.maxEpsilon, (int)ElasticAlign.p.maxIterationsSpringMesh, (int)ElasticAlign.p.maxPlateauwidthSpringMesh, (boolean)ElasticAlign.p.visualize);
            IJ.log((String)("Done optimizing spring meshes. Took " + (System.currentTimeMillis() - t0) + " ms"));
        }
        catch (NotEnoughDataPointsException e) {
            IJ.log((String)"There were not enough data points to get the spring mesh optimizing.");
            e.printStackTrace();
            return;
        }
        double[] min = new double[2];
        double[] dArray = new double[2];
        for (SpringMesh mesh : meshes) {
            double[] meshMin = new double[2];
            double[] meshMax = new double[2];
            mesh.bounds(meshMin, meshMax);
            Util.min((double[])min, (double[])meshMin);
            Util.max((double[])dArray, (double[])meshMax);
        }
        for (SpringMesh mesh : meshes) {
            for (Vertex vertex : mesh.getVertices()) {
                double[] w = vertex.getW();
                w[0] = w[0] - min[0];
                w[1] = w[1] - min[1];
            }
            mesh.updateAffines();
            mesh.updatePassiveVertices();
        }
        int width = (int)Math.ceil(dArray[0] - min[0]);
        int height = (int)Math.ceil(dArray[1] - min[1]);
        for (int i = 0; i < stack.getSize(); ++i) {
            ImageProcessor source;
            ColorProcessor target;
            int slice = i + 1;
            MovingLeastSquaresTransform mlt = new MovingLeastSquaresTransform();
            mlt.setModel(AffineModel2D.class);
            mlt.setAlpha(2.0);
            mlt.setMatches(((SpringMesh)meshes.get(i)).getVA().keySet());
            CoordinateTransformMesh mltMesh = new CoordinateTransformMesh((CoordinateTransform)mlt, ElasticAlign.p.resolutionOutput, (double)stack.getWidth(), (double)stack.getHeight());
            TransformMeshMapping mltMapping = new TransformMeshMapping((TransformMesh)mltMesh);
            if (ElasticAlign.p.rgbWithGreenBackground) {
                target = new ColorProcessor(width, height);
                for (int j = width * height - 1; j >= 0; --j) {
                    target.set(j, -16711936);
                }
                source = stack.getProcessor(slice).convertToRGB();
            } else {
                target = stack.getProcessor(slice).createProcessor(width, height);
                source = stack.getProcessor(slice);
            }
            if (ElasticAlign.p.interpolate) {
                mltMapping.mapInterpolated(source, (ImageProcessor)target);
            } else {
                mltMapping.map(source, (ImageProcessor)target);
            }
            ImagePlus impTarget = new ImagePlus("elastic mlt " + i, (ImageProcessor)target);
            if (ElasticAlign.p.visualize) {
                Shape shape = mltMesh.illustrateMesh();
                impTarget.setOverlay(shape, IJ.getInstance().getForeground(), new BasicStroke(1.0f));
            }
            IJ.save((ImagePlus)impTarget, (String)(ElasticAlign.p.outputPath + "elastic-" + String.format("%05d", i) + ".tif"));
        }
        IJ.log((String)"Done.");
    }

    private static FloatProcessor createMask(ImageProcessor source) {
        FloatProcessor mask = new FloatProcessor(source.getWidth(), source.getHeight());
        int maskColor = 65280;
        int n = source.getWidth() * source.getHeight();
        float[] maskPixels = (float[])mask.getPixels();
        for (int i = 0; i < n; ++i) {
            int sourcePixel = source.get(i) & 0xFFFFFF;
            maskPixels[i] = sourcePixel == 65280 ? 0.0f : 1.0f;
        }
        return mask;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 112 || e.getSource() instanceof TextField) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static final boolean serializeFeatures(FloatArray2DSIFT.Param param, ArrayList<Feature> fs, String path) {
        return ElasticAlign.serialize(new Features(param, fs), path);
    }

    private static final ArrayList<Feature> deserializeFeatures(FloatArray2DSIFT.Param param, String path) {
        Object o = ElasticAlign.deserialize(path);
        if (null == o) {
            return null;
        }
        Features fs = (Features)o;
        if (param.equals(fs.param)) {
            return fs.features;
        }
        return null;
    }

    private static final boolean serializePointMatches(Param param, ArrayList<PointMatch> pms, String path) {
        return ElasticAlign.serialize(new PointMatches(param, pms), path);
    }

    private static final ArrayList<PointMatch> deserializePointMatches(Param param, String path) {
        Object o = ElasticAlign.deserialize(path);
        if (null == o) {
            return null;
        }
        PointMatches pms = (PointMatches)o;
        if (param.equalSiftPointMatchParams(pms.param)) {
            return pms.pointMatches;
        }
        return null;
    }

    public static boolean serialize(Object ob, String path) {
        try {
            File fdir = new File(path).getParentFile();
            if (null == fdir) {
                return false;
            }
            fdir.mkdirs();
            if (!fdir.exists()) {
                IJ.log((String)("Could not create folder " + fdir.getAbsolutePath()));
                return false;
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path));
            out.writeObject(ob);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Object deserialize(String path) {
        try {
            if (!new File(path).exists()) {
                return null;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
            Object ob = in.readObject();
            in.close();
            return ob;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final class PointMatches
    implements Serializable {
        private static final long serialVersionUID = 3718614767497404447L;
        Param param;
        ArrayList<PointMatch> pointMatches;

        PointMatches(Param p, ArrayList<PointMatch> pointMatches) {
            this.param = p;
            this.pointMatches = pointMatches;
        }
    }

    private static final class Features
    implements Serializable {
        private static final long serialVersionUID = 2668666732018368958L;
        final FloatArray2DSIFT.Param param;
        final ArrayList<Feature> features;

        Features(FloatArray2DSIFT.Param p, ArrayList<Feature> features) {
            this.param = p;
            this.features = features;
        }
    }

    private static final class Param
    implements Serializable {
        private static final long serialVersionUID = -4772614223784150836L;
        public String outputPath = "";
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public int maxNumThreadsSift;
        public float rod;
        public float maxEpsilon;
        public float minInlierRatio;
        public int minNumInliers;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine", "Perspective"};
        public int modelIndex;
        public boolean rejectIdentity;
        public float identityTolerance;
        public int maxNumNeighbors;
        public int maxNumFailures;
        public double sectionScale;
        public float minR;
        public float maxCurvatureR;
        public float rodR;
        public int searchRadius;
        public int blockRadius;
        public boolean useLocalSmoothnessFilter;
        public int localModelIndex;
        public float localRegionSigma;
        public float maxLocalEpsilon;
        public float maxLocalTrust;
        public boolean mask;
        public int modelIndexOptimize;
        public int maxIterationsOptimize;
        public int maxPlateauwidthOptimize;
        public int resolutionSpringMesh;
        public double stiffnessSpringMesh;
        public double dampSpringMesh;
        public double maxStretchSpringMesh;
        public int maxIterationsSpringMesh;
        public int maxPlateauwidthSpringMesh;
        public boolean interpolate;
        public boolean visualize;
        public int resolutionOutput;
        public boolean rgbWithGreenBackground;
        public boolean clearCache;
        public int maxNumThreads;
        public boolean isAligned;

        private Param() {
            this.sift.fdSize = 8;
            this.maxNumThreadsSift = Runtime.getRuntime().availableProcessors();
            this.rod = 0.92f;
            this.maxEpsilon = 200.0f;
            this.minInlierRatio = 0.0f;
            this.minNumInliers = 12;
            this.modelIndex = 3;
            this.rejectIdentity = true;
            this.identityTolerance = 5.0f;
            this.maxNumNeighbors = 10;
            this.maxNumFailures = 3;
            this.sectionScale = -1.0;
            this.minR = 0.8f;
            this.maxCurvatureR = 3.0f;
            this.rodR = 0.8f;
            this.searchRadius = 200;
            this.blockRadius = -1;
            this.useLocalSmoothnessFilter = true;
            this.localModelIndex = 1;
            this.localRegionSigma = this.searchRadius / 4;
            this.maxLocalEpsilon = this.searchRadius / 4;
            this.maxLocalTrust = 3.0f;
            this.mask = false;
            this.modelIndexOptimize = 1;
            this.maxIterationsOptimize = 1000;
            this.maxPlateauwidthOptimize = 200;
            this.resolutionSpringMesh = 16;
            this.stiffnessSpringMesh = 0.1;
            this.dampSpringMesh = 0.9;
            this.maxStretchSpringMesh = 2000.0;
            this.maxIterationsSpringMesh = 1000;
            this.maxPlateauwidthSpringMesh = 200;
            this.interpolate = true;
            this.visualize = true;
            this.resolutionOutput = 128;
            this.rgbWithGreenBackground = false;
            this.clearCache = true;
            this.maxNumThreads = Runtime.getRuntime().availableProcessors();
            this.isAligned = false;
        }

        public boolean setup(ImagePlus imp) {
            DirectoryChooser.setDefaultDirectory((String)this.outputPath);
            DirectoryChooser dc = new DirectoryChooser("Elastically align stack: Output directory");
            this.outputPath = dc.getDirectory();
            if (this.outputPath == null) {
                this.outputPath = "";
                return false;
            }
            File d = new File(this.outputPath);
            if (!d.exists() || !d.isDirectory()) {
                return false;
            }
            this.outputPath = this.outputPath + "/";
            GenericDialog gdOutput = new GenericDialog("Elastically align stack: Output");
            gdOutput.addCheckbox("interpolate", this.interpolate);
            gdOutput.addCheckbox("visualize", this.visualize);
            gdOutput.addNumericField("resolution :", (double)this.resolutionOutput, 0);
            gdOutput.addCheckbox("render RGB with green background", this.rgbWithGreenBackground);
            gdOutput.showDialog();
            if (gdOutput.wasCanceled()) {
                return false;
            }
            this.interpolate = gdOutput.getNextBoolean();
            this.visualize = gdOutput.getNextBoolean();
            this.resolutionOutput = (int)gdOutput.getNextNumber();
            this.rgbWithGreenBackground = gdOutput.getNextBoolean();
            if (this.sectionScale < 0.0) {
                Calibration calib = imp.getCalibration();
                this.sectionScale = calib.pixelWidth / calib.pixelDepth;
            }
            if (this.blockRadius < 0) {
                this.blockRadius = imp.getWidth() / this.resolutionSpringMesh / 2;
            }
            GenericDialog gdBlockMatching = new GenericDialog("Elastically align stack: Block Matching parameters");
            gdBlockMatching.addMessage("Block Matching:");
            gdBlockMatching.addNumericField("scale :", this.sectionScale, 2);
            gdBlockMatching.addNumericField("search_radius :", (double)this.searchRadius, 0, 6, "px");
            gdBlockMatching.addNumericField("block_radius :", (double)this.blockRadius, 0, 6, "px");
            gdBlockMatching.addNumericField("resolution :", (double)this.resolutionSpringMesh, 0);
            gdBlockMatching.addMessage("Correlation Filters:");
            gdBlockMatching.addNumericField("minimal_PMCC_r :", (double)this.minR, 2);
            gdBlockMatching.addNumericField("maximal_curvature_ratio :", (double)this.maxCurvatureR, 2);
            gdBlockMatching.addNumericField("maximal_second_best_r/best_r :", (double)this.rodR, 2);
            gdBlockMatching.addMessage("Local Smoothness Filter:");
            gdBlockMatching.addCheckbox("use_local_smoothness_filter", this.useLocalSmoothnessFilter);
            gdBlockMatching.addChoice("approximate_local_transformation :", modelStrings, modelStrings[this.localModelIndex]);
            gdBlockMatching.addNumericField("local_region_sigma:", (double)this.localRegionSigma, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (absolute):", (double)this.maxLocalEpsilon, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (relative):", (double)this.maxLocalTrust, 2);
            gdBlockMatching.addMessage("Miscellaneous:");
            gdBlockMatching.addCheckbox("green_mask_(TODO_more_colors)", this.mask);
            gdBlockMatching.addCheckbox("series_is_aligned", this.isAligned);
            gdBlockMatching.addNumericField("test_maximally :", (double)this.maxNumNeighbors, 0, 6, "layers");
            gdBlockMatching.showDialog();
            if (gdBlockMatching.wasCanceled()) {
                return false;
            }
            this.sectionScale = gdBlockMatching.getNextNumber();
            this.searchRadius = (int)gdBlockMatching.getNextNumber();
            this.blockRadius = (int)gdBlockMatching.getNextNumber();
            this.resolutionSpringMesh = (int)gdBlockMatching.getNextNumber();
            this.minR = (float)gdBlockMatching.getNextNumber();
            this.maxCurvatureR = (float)gdBlockMatching.getNextNumber();
            this.rodR = (float)gdBlockMatching.getNextNumber();
            this.useLocalSmoothnessFilter = gdBlockMatching.getNextBoolean();
            this.localModelIndex = gdBlockMatching.getNextChoiceIndex();
            this.localRegionSigma = (float)gdBlockMatching.getNextNumber();
            this.maxLocalEpsilon = (float)gdBlockMatching.getNextNumber();
            this.maxLocalTrust = (float)gdBlockMatching.getNextNumber();
            this.mask = gdBlockMatching.getNextBoolean();
            this.isAligned = gdBlockMatching.getNextBoolean();
            this.maxNumNeighbors = (int)gdBlockMatching.getNextNumber();
            if (!this.isAligned) {
                GenericDialog gdSIFT = new GenericDialog("Elastically align stack: SIFT parameters");
                SIFT.addFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.sift);
                gdSIFT.addMessage("Local Descriptor Matching:");
                gdSIFT.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
                gdSIFT.addMessage("Miscellaneous:");
                gdSIFT.addCheckbox("clear_cache", this.clearCache);
                gdSIFT.addNumericField("feature_extraction_threads :", (double)this.maxNumThreadsSift, 0);
                gdSIFT.showDialog();
                if (gdSIFT.wasCanceled()) {
                    return false;
                }
                SIFT.readFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.sift);
                this.rod = (float)gdSIFT.getNextNumber();
                this.clearCache = gdSIFT.getNextBoolean();
                this.maxNumThreadsSift = (int)gdSIFT.getNextNumber();
                GenericDialog gdGeom = new GenericDialog("Elastically align stack: Geometric filters");
                gdGeom.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
                gdGeom.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
                gdGeom.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
                gdGeom.addChoice("approximate_transformation :", modelStrings, modelStrings[this.modelIndex]);
                gdGeom.addCheckbox("ignore constant background", this.rejectIdentity);
                gdGeom.addNumericField("tolerance :", (double)this.identityTolerance, 2, 6, "px");
                gdGeom.addNumericField("give_up_after :", (double)this.maxNumFailures, 0, 6, "failures");
                gdGeom.showDialog();
                if (gdGeom.wasCanceled()) {
                    return false;
                }
                this.maxEpsilon = (float)gdGeom.getNextNumber();
                this.minInlierRatio = (float)gdGeom.getNextNumber();
                this.minNumInliers = (int)gdGeom.getNextNumber();
                this.modelIndex = gdGeom.getNextChoiceIndex();
                this.rejectIdentity = gdGeom.getNextBoolean();
                this.identityTolerance = (float)gdGeom.getNextNumber();
                this.maxNumFailures = (int)gdGeom.getNextNumber();
            }
            GenericDialog gdOptimize = new GenericDialog("Elastically align stack: Optimization");
            gdOptimize.addMessage("Approximate Optimizer:");
            gdOptimize.addChoice("approximate_transformation :", modelStrings, modelStrings[this.modelIndexOptimize]);
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsOptimize, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthOptimize, 0);
            gdOptimize.addMessage("Spring Mesh:");
            gdOptimize.addNumericField("stiffness :", this.stiffnessSpringMesh, 2);
            gdOptimize.addNumericField("maximal_stretch :", this.maxStretchSpringMesh, 2, 6, "px");
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsSpringMesh, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthSpringMesh, 0);
            gdOptimize.showDialog();
            if (gdOptimize.wasCanceled()) {
                return false;
            }
            this.modelIndexOptimize = gdOptimize.getNextChoiceIndex();
            this.maxIterationsOptimize = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthOptimize = (int)gdOptimize.getNextNumber();
            this.stiffnessSpringMesh = gdOptimize.getNextNumber();
            this.maxStretchSpringMesh = gdOptimize.getNextNumber();
            this.maxIterationsSpringMesh = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthSpringMesh = (int)gdOptimize.getNextNumber();
            return true;
        }

        public boolean equalSiftPointMatchParams(Param param) {
            return this.sift.equals(param.sift) && this.maxEpsilon == param.maxEpsilon && this.minInlierRatio == param.minInlierRatio && this.minNumInliers == param.minNumInliers && this.modelIndex == param.modelIndex && this.rejectIdentity == param.rejectIdentity && this.identityTolerance == param.identityTolerance && this.maxNumNeighbors == param.maxNumNeighbors && this.maxNumFailures == param.maxNumFailures;
        }
    }

    private static final class Triple<A, B, C> {
        public final A a;
        public final B b;
        public final C c;

        Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }
}

