/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.TextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Util;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;

public class Specify_Calibration
implements PlugIn {
    public void run(String arg0) {
        Cal maxCal;
        ArrayList<ViewId> viewIds;
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("specifying calibration", true, true, true, true)) {
            return;
        }
        SpimData2 data = (SpimData2)((Object)result.getData());
        ArrayList<Cal> calibrations = Specify_Calibration.findCalibrations(data, viewIds = SpimData2.getAllViewIdsSorted(data, result.getViewSetupsToProcess(), result.getTimePointsToProcess()));
        if (!Specify_Calibration.queryNewCal(calibrations, maxCal = Specify_Calibration.mostPresentCal(calibrations))) {
            return;
        }
        Specify_Calibration.applyCal(maxCal, data, viewIds);
        SpimData2.saveXML(data, result.getXMLFileName(), result.getClusterExtension());
    }

    public static boolean queryNewCal(ArrayList<Cal> calibrations, Cal maxCal) {
        GenericDialog gd = new GenericDialog("Define new calibration");
        gd.addNumericField("Calibration_x", maxCal.getCal()[0], 40, 20, "");
        ((TextField)gd.getNumericFields().lastElement()).setText("" + maxCal.getCal()[0]);
        gd.addNumericField("Calibration_y", maxCal.getCal()[1], 40, 20, "");
        ((TextField)gd.getNumericFields().lastElement()).setText("" + maxCal.getCal()[1]);
        gd.addNumericField("Calibration_z", maxCal.getCal()[2], 40, 20, "");
        ((TextField)gd.getNumericFields().lastElement()).setText("" + maxCal.getCal()[2]);
        gd.addStringField("Unit", maxCal.unit());
        if (calibrations.size() > 1) {
            gd.addMessage("WARNING: Calibrations are not the same for all\nview setups! All calibrations will be overwritten\nfor all view setups if defined here.", GUIHelper.mediumstatusfont, GUIHelper.warning);
        }
        gd.addMessage("Note: These values will be applied to selected view\nsetups, existing registration are not affected and\nwill need to be recomputed if necessary.", GUIHelper.mediumstatusfont);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        maxCal.getCal()[0] = gd.getNextNumber();
        maxCal.getCal()[1] = gd.getNextNumber();
        maxCal.getCal()[2] = gd.getNextNumber();
        maxCal.setUnit(gd.getNextString());
        return true;
    }

    public static void applyCal(Cal maxCal, SpimData spimData, List<ViewId> viewIds) {
        TimePoint t = (TimePoint)((SequenceDescription)spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered().get(0);
        for (ViewId viewId : viewIds) {
            if (viewId.getTimePointId() != t.getId()) continue;
            ViewDescription desc = (ViewDescription)((SequenceDescription)spimData.getSequenceDescription()).getViewDescriptions().get(viewId);
            ViewSetup viewSetup = (ViewSetup)desc.getViewSetup();
            viewSetup.setVoxelSize((VoxelDimensions)new FinalVoxelDimensions(maxCal.unit(), new double[]{maxCal.getCal()[0], maxCal.getCal()[1], maxCal.getCal()[2]}));
        }
    }

    public static ArrayList<Cal> findCalibrations(AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>> spimData, List<ViewId> viewIds) {
        TimePoint t = (TimePoint)spimData.getSequenceDescription().getTimePoints().getTimePointsOrdered().get(0);
        ArrayList<Cal> calibrations = new ArrayList<Cal>();
        for (ViewId viewId : viewIds) {
            if (viewId.getTimePointId() != t.getId()) continue;
            BasicViewDescription vd = (BasicViewDescription)spimData.getSequenceDescription().getViewDescriptions().get(viewId);
            BasicViewSetup vs = vd.getViewSetup();
            String name = ViewSetup.class.isInstance(vs) ? "angle: " + ((ViewSetup)vs).getAngle().getName() + " channel: " + ((ViewSetup)vs).getChannel().getName() + " illum: " + ((ViewSetup)vs).getIllumination().getName() + ", present at timepoint: " + t.getName() + ": " + vd.isPresent() : "viewsetup: " + vs.getId() + ", present at timepoint: " + t.getName() + ": " + vd.isPresent();
            VoxelDimensions voxelSize = ViewSetupUtils.getVoxelSize(vs);
            if (voxelSize == null) {
                voxelSize = new FinalVoxelDimensions("", new double[]{1.0, 1.0, 1.0});
            }
            double x = voxelSize.dimension(0);
            double y = voxelSize.dimension(1);
            double z = voxelSize.dimension(2);
            String unit = voxelSize.unit();
            if (unit == null) {
                unit = "";
            }
            IOFunctions.println("cal: [" + x + ", " + y + ", " + z + "] " + unit + "  -- " + name);
            Cal calTmp = new Cal(new double[]{x, y, z}, unit);
            boolean foundMatch = false;
            for (int j = 0; j < calibrations.size() && !foundMatch; ++j) {
                Cal cal = calibrations.get(j);
                if (!cal.equals(calTmp)) continue;
                cal.increaseCount();
                foundMatch = true;
            }
            if (foundMatch) continue;
            calibrations.add(calTmp);
        }
        return calibrations;
    }

    public static Cal mostPresentCal(Collection<Cal> calibrations) {
        int max = 0;
        Cal maxCal = null;
        for (Cal cal : calibrations) {
            if (cal.getCount() <= max) continue;
            max = cal.getCount();
            maxCal = cal;
        }
        IOFunctions.println("Number of calibrations: " + calibrations.size());
        IOFunctions.println("Calibration most often present: " + Util.printCoordinates((double[])maxCal.getCal()) + " (" + maxCal.getCount() + " times)");
        return maxCal;
    }

    public static void main(String[] args) {
        IOFunctions.printIJLog = true;
        new ImageJ();
        new Specify_Calibration().run(null);
    }

    public static class Cal {
        final double[] cal;
        int count;
        String unit;

        public Cal(double[] cal, String unit) {
            this.cal = cal;
            this.count = 1;
            this.unit = unit;
        }

        public void increaseCount() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public double[] getCal() {
            return this.cal;
        }

        public String unit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o instanceof Cal) {
                Cal c2 = (Cal)o;
                if (c2.cal.length != this.cal.length) {
                    return false;
                }
                for (int d = 0; d < this.cal.length; ++d) {
                    if (c2.cal[d] == this.cal[d]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

