/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.registration;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.registration.RegistrationExplorerPanel;

public class RegistrationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1263388435427674269L;
    ViewRegistrations viewRegistrations;
    final ArrayList<String> columnNames = new ArrayList();
    final RegistrationExplorerPanel panel;
    BasicViewDescription<?> currentVD;

    public RegistrationTableModel(ViewRegistrations viewRegistrations, RegistrationExplorerPanel panel) {
        this.panel = panel;
        this.columnNames.add("Transformation Name");
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                this.columnNames.add("m" + row + "" + col);
            }
        }
        this.viewRegistrations = viewRegistrations;
        this.currentVD = null;
    }

    protected void update(ViewRegistrations viewRegistrations) {
        this.viewRegistrations = viewRegistrations;
    }

    protected ViewRegistrations getViewRegistrations() {
        return this.viewRegistrations;
    }

    protected BasicViewDescription<?> getCurrentViewDescription() {
        return this.currentVD;
    }

    protected void updateViewDescription(BasicViewDescription<?> vd) {
        this.currentVD = vd;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        if (this.currentVD == null) {
            return 1;
        }
        return Math.max(1, this.viewRegistrations.getViewRegistration(this.currentVD).getTransformList().size());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        List vtList = this.viewRegistrations.getViewRegistration(this.currentVD).getTransformList();
        ViewTransform vt = (ViewTransform)vtList.get(row);
        if (column == 0) {
            String newName = value.toString();
            vtList.set(row, RegistrationExplorerPanel.newName(vt, newName));
        } else {
            try {
                double v = Double.parseDouble(value.toString());
                vtList.set(row, RegistrationExplorerPanel.newMatrixEntry(vt, v, column - 1));
            }
            catch (Exception e) {
                System.out.println("Cannot parse: " + value);
            }
        }
        this.viewRegistrations.getViewRegistration(this.currentVD).updateModel();
        ViewSetupExplorerPanel.bdvPopup().updateBDV();
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.currentVD == null) {
            return column == 0 ? "No View Description selected" : "";
        }
        ViewRegistration vr = this.viewRegistrations.getViewRegistration(this.currentVD);
        if (vr.getTransformList().isEmpty()) {
            return column == 0 ? "No transformations present" : "";
        }
        if (column == 0) {
            return ((ViewTransform)vr.getTransformList().get(row)).getName();
        }
        return ((ViewTransform)vr.getTransformList().get(row)).asAffine3D().getRowPackedCopy()[column - 1];
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }
}

