/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointdetection;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.math.ImageCalculatorInPlace;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal1;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.segmentation.InteractiveIntegral;
import mpicbg.spim.segmentation.SimplePeak;

public class DifferenceOfGaussianNewPeakFinder
extends DifferenceOfGaussianReal1<FloatType> {
    ArrayList<SimplePeak> simplePeaks;
    final double min;
    final double[] s1;
    final double[] s2;

    public DifferenceOfGaussianNewPeakFinder(Image<FloatType> img, OutOfBoundsStrategyFactory<FloatType> outOfBoundsFactory, double[] sigma1, double[] sigma2, double minPeakValue, double normalizationFactor) {
        super(img, outOfBoundsFactory, sigma1, sigma2, minPeakValue, normalizationFactor);
        this.s1 = sigma1;
        this.s2 = sigma2;
        this.min = minPeakValue;
    }

    public ArrayList<SimplePeak> getSimplePeaks() {
        return this.simplePeaks;
    }

    public ArrayList<DifferenceOfGaussianPeak<FloatType>> findPeaks(Image<FloatType> laPlace) {
        IOFunctions.println(new Date(System.currentTimeMillis()) + ": Detecting peaks.");
        this.simplePeaks = InteractiveIntegral.findPeaks(laPlace, (float)this.min);
        return new ArrayList<DifferenceOfGaussianPeak<FloatType>>();
    }

    public boolean process() {
        Thread[] threads;
        int divisor = this.getComputeConvolutionsParalell() ? 2 : 1;
        final OutputAlgorithm conv1 = this.getGaussianConvolution(this.s1, Math.max(1, this.getNumThreads() / divisor));
        final OutputAlgorithm conv2 = this.getGaussianConvolution(this.s2, Math.max(1, this.getNumThreads() / divisor));
        if (conv1.checkInput() && conv2.checkInput()) {
            final AtomicInteger ai = new AtomicInteger(0);
            threads = SimpleMultiThreading.newThreads((int)divisor);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        if (!(myNumber != 0 && DifferenceOfGaussianNewPeakFinder.this.getComputeConvolutionsParalell() || conv1.process())) {
                            System.out.println("Cannot compute gaussian convolution 1: " + conv1.getErrorMessage());
                        }
                        if (!(myNumber != 1 && DifferenceOfGaussianNewPeakFinder.this.getComputeConvolutionsParalell() || conv2.process())) {
                            System.out.println("Cannot compute gaussian convolution 2: " + conv2.getErrorMessage());
                        }
                    }
                });
            }
        } else {
            Object gauss2 = null;
            Object gauss1 = null;
            return false;
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (conv1.getErrorMessage().length() != 0 || conv2.getErrorMessage().length() != 0) {
            Object gauss2 = null;
            Object gauss1 = null;
            return false;
        }
        Image gauss1 = conv1.getResult();
        Image gauss2 = conv2.getResult();
        Function function = this.getNormalizedSubtraction();
        ImageCalculatorInPlace imageCalc = new ImageCalculatorInPlace(gauss2, gauss1, function);
        imageCalc.setNumThreads(this.getNumThreads());
        if (!imageCalc.checkInput() || !imageCalc.process()) {
            gauss1.close();
            gauss2.close();
            return false;
        }
        gauss1.close();
        this.peaks.clear();
        this.peaks.addAll(this.findPeaks((Image<FloatType>)gauss2));
        if (this.getKeepDoGImage()) {
            this.dogImage = gauss2;
        } else {
            gauss2.close();
        }
        return true;
    }
}

