/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.task.AbstractDeterminator;
import org.ojalgo.matrix.task.SolverTask;

abstract class AbstractSolver
implements SolverTask<Double> {
    static final SolverTask<Double> FULL_1X1 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.full1X1(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> FULL_2X2 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.full2X2(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> FULL_3X3 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.full3X3(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> FULL_4X4 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.full4X4(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> FULL_5X5 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.full5X5(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> LEAST_SQUARES = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.leastSquares(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> SYMMETRIC_2X2 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.symmetric2X2(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> SYMMETRIC_3X3 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.symmetric3X3(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> SYMMETRIC_4X4 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.symmetric4X4(body, rhs, preallocated);
            return preallocated;
        }
    };
    static final SolverTask<Double> SYMMETRIC_5X5 = new AbstractSolver(){

        @Override
        public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
            AbstractSolver.symmetric5X5(body, rhs, preallocated);
            return preallocated;
        }
    };

    static void full1X1(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        solution.set(0L, rhs.doubleValue(0L) / body.doubleValue(0L));
    }

    static void full2X2(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp01 = body.doubleValue(2L);
        double tmp11 = body.doubleValue(3L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1);
        double tmpDet = AbstractDeterminator.calculate(tmp00 /= tmpScale, tmp10 /= tmpScale, tmp01 /= tmpScale, tmp11 /= tmpScale);
        solution.set(0L, AbstractDeterminator.calculate(tmp0 /= tmpScale, tmp1 /= tmpScale, tmp01, tmp11) / tmpDet);
        solution.set(1L, AbstractDeterminator.calculate(tmp00, tmp10, tmp0, tmp1) / tmpDet);
    }

    static void full3X3(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp01 = body.doubleValue(3L);
        double tmp11 = body.doubleValue(4L);
        double tmp21 = body.doubleValue(5L);
        double tmp02 = body.doubleValue(6L);
        double tmp12 = body.doubleValue(7L);
        double tmp22 = body.doubleValue(8L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp20 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11 /= tmpScale, tmp21 /= tmpScale, tmp12 /= tmpScale, tmp22 /= tmpScale);
        double tmpMin10 = AbstractDeterminator.calculate(tmp01 /= tmpScale, tmp21, tmp02 /= tmpScale, tmp22);
        double tmpMin20 = AbstractDeterminator.calculate(tmp01, tmp11, tmp02, tmp12);
        double tmpMin01 = AbstractDeterminator.calculate(tmp10, tmp20, tmp12, tmp22);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp02, tmp22);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp02, tmp12);
        double tmpMin02 = AbstractDeterminator.calculate(tmp10, tmp20, tmp11, tmp21);
        double tmpMin12 = AbstractDeterminator.calculate(tmp00, tmp20, tmp01, tmp21);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp01, tmp11);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin01 - tmp1 * tmpMin11 + tmp2 * tmpMin21) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin02 - tmp1 * tmpMin12 + tmp2 * tmpMin22) / tmpDet);
    }

    static void full4X4(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp30 = body.doubleValue(3L);
        double tmp01 = body.doubleValue(4L);
        double tmp11 = body.doubleValue(5L);
        double tmp21 = body.doubleValue(6L);
        double tmp31 = body.doubleValue(7L);
        double tmp02 = body.doubleValue(8L);
        double tmp12 = body.doubleValue(9L);
        double tmp22 = body.doubleValue(10L);
        double tmp32 = body.doubleValue(11L);
        double tmp03 = body.doubleValue(12L);
        double tmp13 = body.doubleValue(13L);
        double tmp23 = body.doubleValue(14L);
        double tmp33 = body.doubleValue(15L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmp3 = rhs.doubleValue(3L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2, tmp3);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp20 /= tmpScale;
        tmp30 /= tmpScale;
        tmp01 /= tmpScale;
        tmp11 /= tmpScale;
        tmp21 /= tmpScale;
        tmp31 /= tmpScale;
        tmp02 /= tmpScale;
        tmp12 /= tmpScale;
        tmp22 /= tmpScale;
        tmp32 /= tmpScale;
        tmp03 /= tmpScale;
        tmp13 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        tmp3 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11, tmp21, tmp31, tmp12, tmp22, tmp32, tmp13, tmp23 /= tmpScale, tmp33 /= tmpScale);
        double tmpMin10 = AbstractDeterminator.calculate(tmp01, tmp21, tmp31, tmp02, tmp22, tmp32, tmp03, tmp23, tmp33);
        double tmpMin20 = AbstractDeterminator.calculate(tmp01, tmp11, tmp31, tmp02, tmp12, tmp32, tmp03, tmp13, tmp33);
        double tmpMin30 = AbstractDeterminator.calculate(tmp01, tmp11, tmp21, tmp02, tmp12, tmp22, tmp03, tmp13, tmp23);
        double tmpMin01 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp12, tmp22, tmp32, tmp13, tmp23, tmp33);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp02, tmp22, tmp32, tmp03, tmp23, tmp33);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp02, tmp12, tmp32, tmp03, tmp13, tmp33);
        double tmpMin31 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp02, tmp12, tmp22, tmp03, tmp13, tmp23);
        double tmpMin02 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp11, tmp21, tmp31, tmp13, tmp23, tmp33);
        double tmpMin12 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp01, tmp21, tmp31, tmp03, tmp23, tmp33);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp01, tmp11, tmp31, tmp03, tmp13, tmp33);
        double tmpMin32 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp01, tmp11, tmp21, tmp03, tmp13, tmp23);
        double tmpMin03 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp11, tmp21, tmp31, tmp12, tmp22, tmp32);
        double tmpMin13 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp01, tmp21, tmp31, tmp02, tmp22, tmp32);
        double tmpMin23 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp01, tmp11, tmp31, tmp02, tmp12, tmp32);
        double tmpMin33 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp01, tmp11, tmp21, tmp02, tmp12, tmp22);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20 - tmp30 * tmpMin30;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20 - tmp3 * tmpMin30) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin01 - tmp1 * tmpMin11 + tmp2 * tmpMin21 - tmp3 * tmpMin31) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin02 - tmp1 * tmpMin12 + tmp2 * tmpMin22 - tmp3 * tmpMin32) / tmpDet);
        solution.set(3L, -(tmp0 * tmpMin03 - tmp1 * tmpMin13 + tmp2 * tmpMin23 - tmp3 * tmpMin33) / tmpDet);
    }

    static void full5X5(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp30 = body.doubleValue(3L);
        double tmp40 = body.doubleValue(4L);
        double tmp01 = body.doubleValue(5L);
        double tmp11 = body.doubleValue(6L);
        double tmp21 = body.doubleValue(7L);
        double tmp31 = body.doubleValue(8L);
        double tmp41 = body.doubleValue(9L);
        double tmp02 = body.doubleValue(10L);
        double tmp12 = body.doubleValue(11L);
        double tmp22 = body.doubleValue(12L);
        double tmp32 = body.doubleValue(13L);
        double tmp42 = body.doubleValue(14L);
        double tmp03 = body.doubleValue(15L);
        double tmp13 = body.doubleValue(16L);
        double tmp23 = body.doubleValue(17L);
        double tmp33 = body.doubleValue(18L);
        double tmp43 = body.doubleValue(19L);
        double tmp04 = body.doubleValue(20L);
        double tmp14 = body.doubleValue(21L);
        double tmp24 = body.doubleValue(22L);
        double tmp34 = body.doubleValue(23L);
        double tmp44 = body.doubleValue(24L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmp3 = rhs.doubleValue(3L);
        double tmp4 = rhs.doubleValue(4L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2, tmp3, tmp4);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp20 /= tmpScale;
        tmp30 /= tmpScale;
        tmp40 /= tmpScale;
        tmp01 /= tmpScale;
        tmp11 /= tmpScale;
        tmp21 /= tmpScale;
        tmp31 /= tmpScale;
        tmp41 /= tmpScale;
        tmp02 /= tmpScale;
        tmp12 /= tmpScale;
        tmp22 /= tmpScale;
        tmp32 /= tmpScale;
        tmp42 /= tmpScale;
        tmp03 /= tmpScale;
        tmp13 /= tmpScale;
        tmp23 /= tmpScale;
        tmp33 /= tmpScale;
        tmp43 /= tmpScale;
        tmp04 /= tmpScale;
        tmp14 /= tmpScale;
        tmp24 /= tmpScale;
        tmp34 /= tmpScale;
        tmp44 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        tmp3 /= tmpScale;
        tmp4 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11, tmp21, tmp31, tmp41, tmp12, tmp22, tmp32, tmp42, tmp13, tmp23, tmp33, tmp43, tmp14, tmp24, tmp34, tmp44);
        double tmpMin10 = AbstractDeterminator.calculate(tmp01, tmp21, tmp31, tmp41, tmp02, tmp22, tmp32, tmp42, tmp03, tmp23, tmp33, tmp43, tmp04, tmp24, tmp34, tmp44);
        double tmpMin20 = AbstractDeterminator.calculate(tmp01, tmp11, tmp31, tmp41, tmp02, tmp12, tmp32, tmp42, tmp03, tmp13, tmp33, tmp43, tmp04, tmp14, tmp34, tmp44);
        double tmpMin30 = AbstractDeterminator.calculate(tmp01, tmp11, tmp21, tmp41, tmp02, tmp12, tmp22, tmp42, tmp03, tmp13, tmp23, tmp43, tmp04, tmp14, tmp24, tmp44);
        double tmpMin40 = AbstractDeterminator.calculate(tmp01, tmp11, tmp21, tmp31, tmp02, tmp12, tmp22, tmp32, tmp03, tmp13, tmp23, tmp33, tmp04, tmp14, tmp24, tmp34);
        double tmpMin01 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp40, tmp12, tmp22, tmp32, tmp42, tmp13, tmp23, tmp33, tmp43, tmp14, tmp24, tmp34, tmp44);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp40, tmp02, tmp22, tmp32, tmp42, tmp03, tmp23, tmp33, tmp43, tmp04, tmp24, tmp34, tmp44);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp02, tmp12, tmp32, tmp42, tmp03, tmp13, tmp33, tmp43, tmp04, tmp14, tmp34, tmp44);
        double tmpMin31 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp02, tmp12, tmp22, tmp42, tmp03, tmp13, tmp23, tmp43, tmp04, tmp14, tmp24, tmp44);
        double tmpMin41 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp02, tmp12, tmp22, tmp32, tmp03, tmp13, tmp23, tmp33, tmp04, tmp14, tmp24, tmp34);
        double tmpMin02 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp40, tmp11, tmp21, tmp31, tmp41, tmp13, tmp23, tmp33, tmp43, tmp14, tmp24, tmp34, tmp44);
        double tmpMin12 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp40, tmp01, tmp21, tmp31, tmp41, tmp03, tmp23, tmp33, tmp43, tmp04, tmp24, tmp34, tmp44);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp01, tmp11, tmp31, tmp41, tmp03, tmp13, tmp33, tmp43, tmp04, tmp14, tmp34, tmp44);
        double tmpMin32 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp01, tmp11, tmp21, tmp41, tmp03, tmp13, tmp23, tmp43, tmp04, tmp14, tmp24, tmp44);
        double tmpMin42 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp01, tmp11, tmp21, tmp31, tmp03, tmp13, tmp23, tmp33, tmp04, tmp14, tmp24, tmp34);
        double tmpMin03 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp40, tmp11, tmp21, tmp31, tmp41, tmp12, tmp22, tmp32, tmp42, tmp14, tmp24, tmp34, tmp44);
        double tmpMin13 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp40, tmp01, tmp21, tmp31, tmp41, tmp02, tmp22, tmp32, tmp42, tmp04, tmp24, tmp34, tmp44);
        double tmpMin23 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp01, tmp11, tmp31, tmp41, tmp02, tmp12, tmp32, tmp42, tmp04, tmp14, tmp34, tmp44);
        double tmpMin33 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp01, tmp11, tmp21, tmp41, tmp02, tmp12, tmp22, tmp42, tmp04, tmp14, tmp24, tmp44);
        double tmpMin43 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp01, tmp11, tmp21, tmp31, tmp02, tmp12, tmp22, tmp32, tmp04, tmp14, tmp24, tmp34);
        double tmpMin04 = AbstractDeterminator.calculate(tmp10, tmp20, tmp30, tmp40, tmp11, tmp21, tmp31, tmp41, tmp12, tmp22, tmp32, tmp42, tmp13, tmp23, tmp33, tmp43);
        double tmpMin14 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp40, tmp01, tmp21, tmp31, tmp41, tmp02, tmp22, tmp32, tmp42, tmp03, tmp23, tmp33, tmp43);
        double tmpMin24 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp01, tmp11, tmp31, tmp41, tmp02, tmp12, tmp32, tmp42, tmp03, tmp13, tmp33, tmp43);
        double tmpMin34 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp01, tmp11, tmp21, tmp41, tmp02, tmp12, tmp22, tmp42, tmp03, tmp13, tmp23, tmp43);
        double tmpMin44 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp01, tmp11, tmp21, tmp31, tmp02, tmp12, tmp22, tmp32, tmp03, tmp13, tmp23, tmp33);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20 - tmp30 * tmpMin30 + tmp40 * tmpMin40;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20 - tmp3 * tmpMin30 + tmp4 * tmpMin40) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin01 - tmp1 * tmpMin11 + tmp2 * tmpMin21 - tmp3 * tmpMin31 + tmp4 * tmpMin41) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin02 - tmp1 * tmpMin12 + tmp2 * tmpMin22 - tmp3 * tmpMin32 + tmp4 * tmpMin42) / tmpDet);
        solution.set(3L, -(tmp0 * tmpMin03 - tmp1 * tmpMin13 + tmp2 * tmpMin23 - tmp3 * tmpMin33 + tmp4 * tmpMin43) / tmpDet);
        solution.set(4L, (tmp0 * tmpMin04 - tmp1 * tmpMin14 + tmp2 * tmpMin24 - tmp3 * tmpMin34 + tmp4 * tmpMin44) / tmpDet);
    }

    static void leastSquares(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        PrimitiveDenseStore tmpTranspBody = PrimitiveDenseStore.FACTORY.transpose(body);
        int tmpCountRows = (int)tmpTranspBody.countRows();
        PrimitiveDenseStore tmpBody = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountRows, tmpCountRows);
        tmpTranspBody.multiply(tmpTranspBody.transpose(), tmpBody);
        PrimitiveDenseStore tmpRHS = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountRows, solution.countColumns());
        tmpTranspBody.multiply(rhs, tmpRHS);
        switch (tmpCountRows) {
            case 1: {
                AbstractSolver.full1X1(tmpBody, tmpRHS, solution);
                break;
            }
            case 2: {
                AbstractSolver.symmetric2X2(tmpBody, tmpRHS, solution);
                break;
            }
            case 3: {
                AbstractSolver.symmetric3X3(tmpBody, tmpRHS, solution);
                break;
            }
            case 4: {
                AbstractSolver.symmetric4X4(tmpBody, tmpRHS, solution);
                break;
            }
            case 5: {
                AbstractSolver.symmetric5X5(tmpBody, tmpRHS, solution);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static void symmetric2X2(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp11 = body.doubleValue(3L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1);
        double tmpDet = AbstractDeterminator.calculate(tmp00 /= tmpScale, tmp10 /= tmpScale, tmp10, tmp11 /= tmpScale);
        solution.set(0L, AbstractDeterminator.calculate(tmp0 /= tmpScale, tmp1 /= tmpScale, tmp10, tmp11) / tmpDet);
        solution.set(1L, AbstractDeterminator.calculate(tmp00, tmp10, tmp0, tmp1) / tmpDet);
    }

    static void symmetric3X3(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp11 = body.doubleValue(4L);
        double tmp21 = body.doubleValue(5L);
        double tmp22 = body.doubleValue(8L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11 /= tmpScale, tmp21 /= tmpScale, tmp21, tmp22 /= tmpScale);
        double tmpMin10 = AbstractDeterminator.calculate(tmp10, tmp21, tmp20 /= tmpScale, tmp22);
        double tmpMin20 = AbstractDeterminator.calculate(tmp10, tmp11, tmp20, tmp21);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp20, tmp22);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp21);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp10, tmp11);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin10 - tmp1 * tmpMin11 + tmp2 * tmpMin21) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin20 - tmp1 * tmpMin21 + tmp2 * tmpMin22) / tmpDet);
    }

    static void symmetric4X4(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp30 = body.doubleValue(3L);
        double tmp11 = body.doubleValue(5L);
        double tmp21 = body.doubleValue(6L);
        double tmp31 = body.doubleValue(7L);
        double tmp22 = body.doubleValue(10L);
        double tmp32 = body.doubleValue(11L);
        double tmp33 = body.doubleValue(15L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmp3 = rhs.doubleValue(3L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2, tmp3);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp20 /= tmpScale;
        tmp30 /= tmpScale;
        tmp11 /= tmpScale;
        tmp21 /= tmpScale;
        tmp31 /= tmpScale;
        tmp22 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        tmp3 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11, tmp21, tmp31, tmp21, tmp22, tmp32 /= tmpScale, tmp31, tmp32, tmp33 /= tmpScale);
        double tmpMin10 = AbstractDeterminator.calculate(tmp10, tmp21, tmp31, tmp20, tmp22, tmp32, tmp30, tmp32, tmp33);
        double tmpMin20 = AbstractDeterminator.calculate(tmp10, tmp11, tmp31, tmp20, tmp21, tmp32, tmp30, tmp31, tmp33);
        double tmpMin30 = AbstractDeterminator.calculate(tmp10, tmp11, tmp21, tmp20, tmp21, tmp22, tmp30, tmp31, tmp32);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp20, tmp22, tmp32, tmp30, tmp32, tmp33);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp20, tmp21, tmp32, tmp30, tmp31, tmp33);
        double tmpMin31 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp20, tmp21, tmp22, tmp30, tmp31, tmp32);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp10, tmp11, tmp31, tmp30, tmp31, tmp33);
        double tmpMin32 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp10, tmp11, tmp21, tmp30, tmp31, tmp32);
        double tmpMin33 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp10, tmp11, tmp21, tmp20, tmp21, tmp22);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20 - tmp30 * tmpMin30;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20 - tmp3 * tmpMin30) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin10 - tmp1 * tmpMin11 + tmp2 * tmpMin21 - tmp3 * tmpMin31) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin20 - tmp1 * tmpMin21 + tmp2 * tmpMin22 - tmp3 * tmpMin32) / tmpDet);
        solution.set(3L, -(tmp0 * tmpMin30 - tmp1 * tmpMin31 + tmp2 * tmpMin32 - tmp3 * tmpMin33) / tmpDet);
    }

    static void symmetric5X5(Access2D<?> body, Access1D<?> rhs, PhysicalStore<?> solution) {
        double tmp00 = body.doubleValue(0L);
        double tmp10 = body.doubleValue(1L);
        double tmp20 = body.doubleValue(2L);
        double tmp30 = body.doubleValue(3L);
        double tmp40 = body.doubleValue(4L);
        double tmp11 = body.doubleValue(6L);
        double tmp21 = body.doubleValue(7L);
        double tmp31 = body.doubleValue(8L);
        double tmp41 = body.doubleValue(9L);
        double tmp22 = body.doubleValue(12L);
        double tmp32 = body.doubleValue(13L);
        double tmp42 = body.doubleValue(14L);
        double tmp33 = body.doubleValue(18L);
        double tmp43 = body.doubleValue(19L);
        double tmp44 = body.doubleValue(24L);
        double tmp0 = rhs.doubleValue(0L);
        double tmp1 = rhs.doubleValue(1L);
        double tmp2 = rhs.doubleValue(2L);
        double tmp3 = rhs.doubleValue(3L);
        double tmp4 = rhs.doubleValue(4L);
        double tmpScale = FunctionUtils.norm(tmp0, tmp1, tmp2, tmp3, tmp4);
        tmp00 /= tmpScale;
        tmp10 /= tmpScale;
        tmp20 /= tmpScale;
        tmp30 /= tmpScale;
        tmp40 /= tmpScale;
        tmp11 /= tmpScale;
        tmp21 /= tmpScale;
        tmp31 /= tmpScale;
        tmp41 /= tmpScale;
        tmp22 /= tmpScale;
        tmp32 /= tmpScale;
        tmp42 /= tmpScale;
        tmp33 /= tmpScale;
        tmp43 /= tmpScale;
        tmp44 /= tmpScale;
        tmp0 /= tmpScale;
        tmp1 /= tmpScale;
        tmp2 /= tmpScale;
        tmp3 /= tmpScale;
        tmp4 /= tmpScale;
        double tmpMin00 = AbstractDeterminator.calculate(tmp11, tmp21, tmp31, tmp41, tmp21, tmp22, tmp32, tmp42, tmp31, tmp32, tmp33, tmp43, tmp41, tmp42, tmp43, tmp44);
        double tmpMin10 = AbstractDeterminator.calculate(tmp10, tmp21, tmp31, tmp41, tmp20, tmp22, tmp32, tmp42, tmp30, tmp32, tmp33, tmp43, tmp40, tmp42, tmp43, tmp44);
        double tmpMin20 = AbstractDeterminator.calculate(tmp10, tmp11, tmp31, tmp41, tmp20, tmp21, tmp32, tmp42, tmp30, tmp31, tmp33, tmp43, tmp40, tmp41, tmp43, tmp44);
        double tmpMin30 = AbstractDeterminator.calculate(tmp10, tmp11, tmp21, tmp41, tmp20, tmp21, tmp22, tmp42, tmp30, tmp31, tmp32, tmp43, tmp40, tmp41, tmp42, tmp44);
        double tmpMin40 = AbstractDeterminator.calculate(tmp10, tmp11, tmp21, tmp31, tmp20, tmp21, tmp22, tmp32, tmp30, tmp31, tmp32, tmp33, tmp40, tmp41, tmp42, tmp43);
        double tmpMin11 = AbstractDeterminator.calculate(tmp00, tmp20, tmp30, tmp40, tmp20, tmp22, tmp32, tmp42, tmp30, tmp32, tmp33, tmp43, tmp40, tmp42, tmp43, tmp44);
        double tmpMin21 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp20, tmp21, tmp32, tmp42, tmp30, tmp31, tmp33, tmp43, tmp40, tmp41, tmp43, tmp44);
        double tmpMin31 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp20, tmp21, tmp22, tmp42, tmp30, tmp31, tmp32, tmp43, tmp40, tmp41, tmp42, tmp44);
        double tmpMin41 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp20, tmp21, tmp22, tmp32, tmp30, tmp31, tmp32, tmp33, tmp40, tmp41, tmp42, tmp43);
        double tmpMin22 = AbstractDeterminator.calculate(tmp00, tmp10, tmp30, tmp40, tmp10, tmp11, tmp31, tmp41, tmp30, tmp31, tmp33, tmp43, tmp40, tmp41, tmp43, tmp44);
        double tmpMin32 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp10, tmp11, tmp21, tmp41, tmp30, tmp31, tmp32, tmp43, tmp40, tmp41, tmp42, tmp44);
        double tmpMin42 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp10, tmp11, tmp21, tmp31, tmp30, tmp31, tmp32, tmp33, tmp40, tmp41, tmp42, tmp43);
        double tmpMin33 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp40, tmp10, tmp11, tmp21, tmp41, tmp20, tmp21, tmp22, tmp42, tmp40, tmp41, tmp42, tmp44);
        double tmpMin43 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp10, tmp11, tmp21, tmp31, tmp20, tmp21, tmp22, tmp32, tmp40, tmp41, tmp42, tmp43);
        double tmpMin44 = AbstractDeterminator.calculate(tmp00, tmp10, tmp20, tmp30, tmp10, tmp11, tmp21, tmp31, tmp20, tmp21, tmp22, tmp32, tmp30, tmp31, tmp32, tmp33);
        double tmpDet = tmp00 * tmpMin00 - tmp10 * tmpMin10 + tmp20 * tmpMin20 - tmp30 * tmpMin30 + tmp40 * tmpMin40;
        solution.set(0L, (tmp0 * tmpMin00 - tmp1 * tmpMin10 + tmp2 * tmpMin20 - tmp3 * tmpMin30 + tmp4 * tmpMin40) / tmpDet);
        solution.set(1L, -(tmp0 * tmpMin10 - tmp1 * tmpMin11 + tmp2 * tmpMin21 - tmp3 * tmpMin31 + tmp4 * tmpMin41) / tmpDet);
        solution.set(2L, (tmp0 * tmpMin20 - tmp1 * tmpMin21 + tmp2 * tmpMin22 - tmp3 * tmpMin32 + tmp4 * tmpMin42) / tmpDet);
        solution.set(3L, -(tmp0 * tmpMin30 - tmp1 * tmpMin31 + tmp2 * tmpMin32 - tmp3 * tmpMin33 + tmp4 * tmpMin43) / tmpDet);
        solution.set(4L, (tmp0 * tmpMin40 - tmp1 * tmpMin41 + tmp2 * tmpMin42 - tmp3 * tmpMin43 + tmp4 * tmpMin44) / tmpDet);
    }

    AbstractSolver() {
    }

    @Override
    public final PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(templateBody.countColumns(), 1L);
    }
}

