/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.type.numeric.RealType;

public final class DoubleConvolverRealType
implements Runnable {
    private final double[] kernel;
    private final RandomAccess<? extends RealType<?>> in;
    private final RandomAccess<? extends RealType<?>> out;
    private final int d;
    private final int k1k;
    private final int k1k1;
    private final long linelen;
    private final double[] buffer;

    public DoubleConvolverRealType(Kernel1D kernel, RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, int d, long lineLength) {
        this.in = in;
        this.out = out;
        this.d = d;
        this.kernel = (double[])kernel.fullKernel().clone();
        this.k1k = this.kernel.length;
        this.k1k1 = this.k1k - 1;
        this.linelen = lineLength;
        this.buffer = new double[this.k1k + 1];
    }

    private void prefill() {
        double w = ((RealType)this.in.get()).getRealDouble();
        this.process(w);
        this.in.fwd(this.d);
    }

    private void next() {
        double w = ((RealType)this.in.get()).getRealDouble();
        ((RealType)this.out.get()).setReal(w * this.kernel[0] + this.buffer[1]);
        this.process(w);
        this.in.fwd(this.d);
        this.out.fwd(this.d);
    }

    private void process(double w) {
        for (int i = 1; i < this.k1k; ++i) {
            this.buffer[i] = w * this.kernel[i] + this.buffer[i + 1];
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.prefill();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
        }
    }
}

