/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.DiamondNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public abstract class DiamondNeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessible<T> source;
    protected final Interval sourceInterval;
    protected final long radius;
    protected final DiamondNeighborhoodFactory<T> factory;
    protected final long[] currentPos;
    protected final Neighborhood<T> currentNeighborhood;

    public DiamondNeighborhoodLocalizableSampler(RandomAccessible<T> source, long radius, DiamondNeighborhoodFactory<T> factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.radius = radius;
        this.factory = factory;
        this.currentPos = new long[this.n];
        if (accessInterval == null && source instanceof Interval) {
            accessInterval = (Interval)((Object)source);
        }
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            for (int d = 0; d < this.n; ++d) {
                accessMin[d] = this.currentPos[d] - radius;
                accessMax[d] = this.currentPos[d] + radius;
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = factory.create(this.currentPos, radius, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected DiamondNeighborhoodLocalizableSampler(DiamondNeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.sourceInterval = c.sourceInterval;
        this.radius = c.radius;
        this.factory = c.factory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.factory.create(this.currentPos, this.radius, this.sourceInterval == null ? this.source.randomAccess() : this.source.randomAccess(this.sourceInterval));
    }

    @Override
    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }

    @Override
    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    @Override
    public Neighborhood<T> getType() {
        return this.currentNeighborhood;
    }

    @Override
    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }
}

