/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import ij.IJ;
import ij.Menus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MenuItemHelper {
    Map<String, List<String>> lastWord2Label;

    public MenuItemHelper() {
        this.populateMap();
    }

    protected void populateMap() {
        this.lastWord2Label = new HashMap<String, List<String>>();
        for (Object label : Menus.getCommands().keySet()) {
            String lastWord = this.getLastWord((String)label);
            List<String> list = this.lastWord2Label.get(lastWord);
            if (list == null) {
                list = new ArrayList<String>();
                this.lastWord2Label.put(lastWord, list);
            }
            list.add((String)label);
        }
    }

    protected String getLastWord(String text) {
        int start;
        int end;
        for (end = text.length(); end > 0 && !Character.isLetterOrDigit(text.charAt(end - 1)); --end) {
        }
        if (end == 0) {
            return null;
        }
        for (start = end - 1; start > 0 && Character.isLetterOrDigit(text.charAt(start - 1)); --start) {
        }
        return text.substring(start, end);
    }

    public String getJarForItem(String label) {
        String className = (String)Menus.getCommands().get(label);
        int paren = className.indexOf(40);
        if (paren > 0) {
            className = className.substring(0, paren);
        }
        try {
            String ijDir;
            Class<?> clazz = IJ.getClassLoader().loadClass(className);
            int dot = className.lastIndexOf(46);
            String fileName = className.substring(dot + 1) + ".class";
            String resource = clazz.getResource(fileName).toString();
            String path = className.substring(0, dot + 1).replace('.', '/') + fileName;
            if (resource.startsWith("jar:") && resource.endsWith("!/" + path)) {
                resource = resource.substring(4, resource.length() - path.length() - 2);
            }
            if (resource.startsWith("file:")) {
                resource = resource.substring(5);
            }
            if (!(ijDir = System.getProperty("ij.dir")).endsWith("/")) {
                ijDir = ijDir + "/";
            }
            if (resource.startsWith(ijDir)) {
                resource = resource.substring(ijDir.length());
            }
            return resource;
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
            return null;
        }
    }

    public String getJarForSuffix(String text) {
        String lastWord = this.getLastWord(text);
        List<String> list = this.lastWord2Label.get(lastWord);
        if (list == null) {
            return null;
        }
        for (String label : list) {
            int pos2 = label.lastIndexOf(lastWord);
            if (pos2 == 0) {
                return this.getJarForItem(label);
            }
            int pos1 = text.lastIndexOf(lastWord);
            if (pos1 < pos2 || !text.substring(pos1 - pos2, pos1).equals(label.substring(0, pos2))) continue;
            return this.getJarForItem(label);
        }
        return null;
    }

    public static void main(String[] args) {
        MenuItemHelper helper = new MenuItemHelper();
        IJ.log((String)("1: " + helper.getJarForSuffix("Hello Open...")));
        IJ.log((String)("2: " + helper.getJarForSuffix("Hello Openn...")));
        IJ.log((String)("3: " + helper.getJarForSuffix(" . ! ...")));
    }
}

