/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.complex;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.ComplexTypePowerSpectrumDisplay;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.TypeImpl;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.util.Util;

public abstract class ComplexTypeImpl<T extends ComplexTypeImpl<T>>
extends TypeImpl<T>
implements ComplexType<T> {
    int realI = 0;
    int complexI = 1;

    @Override
    public int getEntitiesPerPixel() {
        return 2;
    }

    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new ComplexTypePowerSpectrumDisplay<T>(image);
    }

    @Override
    public void set(T c) {
        this.setReal(c.getRealDouble());
        this.setComplex(c.getComplexDouble());
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealFloat() * c);
        this.setComplex(this.getComplexFloat() * c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
        this.setComplex(this.getComplexDouble() * c);
    }

    @Override
    public void add(T c) {
        this.setReal(this.getRealDouble() + c.getRealDouble());
        this.setComplex(this.getComplexDouble() + c.getComplexDouble());
    }

    @Override
    public void div(T c) {
        double a1 = this.getRealDouble();
        double b1 = this.getComplexDouble();
        double c1 = c.getRealDouble();
        double d1 = c.getComplexDouble();
        this.setReal((a1 * c1 + b1 * d1) / (c1 * c1 + d1 * d1));
        this.setComplex((b1 * c1 - a1 * d1) / (c1 * c1 + d1 * d1));
    }

    @Override
    public void mul(T t) {
        double a = this.getRealDouble();
        double b = this.getComplexDouble();
        double c = t.getRealDouble();
        double d = t.getComplexDouble();
        this.setReal(a * c - b * d);
        this.setComplex(a * d + b * c);
    }

    @Override
    public void sub(T c) {
        this.setReal(this.getRealDouble() - c.getRealDouble());
        this.setComplex(this.getComplexDouble() - c.getComplexDouble());
    }

    @Override
    public void complexConjugate() {
        this.setComplex(-this.getComplexDouble());
    }

    @Override
    public float getPowerFloat() {
        float real = this.getRealFloat();
        float complex = this.getComplexFloat();
        return (float)Util.gLog(Math.sqrt(real * real + complex * complex), 2.0);
    }

    @Override
    public double getPowerDouble() {
        double real = this.getRealDouble();
        double complex = this.getComplexDouble();
        return Util.gLog(Math.sqrt(real * real + complex * complex), 2.0);
    }

    @Override
    public float getPhaseFloat() {
        float real = this.getRealFloat();
        float complex = this.getComplexFloat();
        if ((double)real != 0.0 || complex != 0.0f) {
            return (float)Math.atan2(complex, real);
        }
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        double real = this.getRealDouble();
        double complex = this.getComplexDouble();
        if (real != 0.0 || complex != 0.0) {
            return (float)Math.atan2(complex, real);
        }
        return 0.0;
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
        this.setComplex(0.0f);
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
        this.setComplex(0.0f);
    }

    @Override
    public void setComplexNumber(float real, float complex) {
        this.setReal(real);
        this.setComplex(complex);
    }

    @Override
    public void setComplexNumber(double real, double complex) {
        this.setReal(real);
        this.setComplex(complex);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Double;
    }

    @Override
    public void updateIndex(int i) {
        this.i = i;
        this.realI = i * 2;
        this.complexI = i * 2 + 1;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.realI += 2;
        this.complexI += 2;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc2 = 2 * increment;
        this.realI += inc2;
        this.complexI += inc2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.realI -= 2;
        this.complexI -= 2;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec2 = 2 * decrement;
        this.realI -= dec2;
        this.complexI -= dec2;
    }

    @Override
    public String toString() {
        return "(" + this.getRealDouble() + ") + (" + this.getComplexDouble() + ")i";
    }
}

