/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.real;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.RealTypeDisplay;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexTypeImpl;

public abstract class RealTypeImpl<T extends RealTypeImpl<T>>
extends ComplexTypeImpl<T>
implements RealType<T> {
    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new RealTypeDisplay<T>(image);
    }

    @Override
    public float getComplexFloat() {
        return 0.0f;
    }

    @Override
    public double getComplexDouble() {
        return 0.0;
    }

    @Override
    public void setComplex(float complex) {
    }

    @Override
    public void setComplex(double complex) {
    }

    @Override
    public void inc() {
        this.setReal(this.getRealDouble() + 1.0);
    }

    @Override
    public void dec() {
        this.setReal(this.getRealDouble() - 1.0);
    }

    @Override
    public void set(T c) {
        this.setReal(c.getRealDouble());
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealDouble() * (double)c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
    }

    @Override
    public void add(T c) {
        this.setReal(this.getRealDouble() + c.getRealDouble());
    }

    @Override
    public void div(T c) {
        this.setReal(this.getRealDouble() / c.getRealDouble());
    }

    @Override
    public void mul(T c) {
        this.setReal(this.getRealDouble() * c.getRealDouble());
    }

    @Override
    public void sub(T c) {
        this.setReal(this.getRealDouble() - c.getRealDouble());
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
    }

    @Override
    public int compareTo(T c) {
        double b;
        double a = this.getRealDouble();
        if (a > (b = c.getRealDouble())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public String toString() {
        return "" + this.getRealDouble();
    }
}

