/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.analysis;

import java.util.ArrayList;
import java.util.List;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Point4f;
import script.imglib.algorithm.fn.AlgorithmUtil;

public class DoGPeaks<N extends RealType<N>>
extends ArrayList<float[]> {
    private static final long serialVersionUID = 7614417748092214062L;
    private final List<DifferenceOfGaussianPeak<FloatType>> peaks;

    public DoGPeaks(Object fn, Number sigmaLarge, Number sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        this(AlgorithmUtil.wrapS(fn), sigmaLarge, sigmaSmall, minPeakValue, normalizationFactor);
    }

    public DoGPeaks(Image<N> img, Number sigmaLarge, Number sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        this(img, AlgorithmUtil.asArray(img.getNumDimensions(), sigmaLarge.doubleValue()), AlgorithmUtil.asArray(img.getNumDimensions(), sigmaSmall.doubleValue()), minPeakValue, normalizationFactor);
    }

    public DoGPeaks(Object fn, List<Number> sigmaLarge, List<Number> sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        this(fn, AlgorithmUtil.asDoubleArray(sigmaLarge), AlgorithmUtil.asDoubleArray(sigmaSmall), minPeakValue, normalizationFactor);
    }

    public DoGPeaks(Object fn, float[] sigmaLarge, float[] sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        this(fn, AlgorithmUtil.asDoubleArray(sigmaLarge), AlgorithmUtil.asDoubleArray(sigmaSmall), minPeakValue, normalizationFactor);
    }

    public DoGPeaks(Object fn, double[] sigmaLarge, double[] sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        this(AlgorithmUtil.wrapS(fn), sigmaLarge, sigmaSmall, minPeakValue, normalizationFactor);
    }

    public DoGPeaks(Image<N> img, double[] sigmaLarge, double[] sigmaSmall, Number minPeakValue, Number normalizationFactor) throws Exception {
        DifferenceOfGaussian<N, FloatType> dog = new DifferenceOfGaussian<N, FloatType>(img, new ImageFactory<FloatType>(new FloatType(), new ArrayContainerFactory()), new RealTypeConverter(), new OutOfBoundsStrategyMirrorFactory(), sigmaLarge, sigmaSmall, new FloatType(minPeakValue.floatValue()), new FloatType(normalizationFactor.floatValue()));
        if (!dog.process()) {
            throw new Exception("Could not process DifferenceOfGaussian: " + dog.getErrorMessage());
        }
        this.peaks = dog.getPeaks();
        for (DifferenceOfGaussianPeak<FloatType> p : this.peaks) {
            this.add(p.getSubPixelPosition());
        }
    }

    public List<DifferenceOfGaussianPeak<FloatType>> getPeaks() {
        return new ArrayList<DifferenceOfGaussianPeak<FloatType>>(this.peaks);
    }

    public List<Object> asPoints(float[] scalingFactor) throws Exception {
        ArrayList<Object> points = new ArrayList<Object>();
        if (this.isEmpty()) {
            return points;
        }
        int len = ((float[])this.get(0)).length;
        if (len < 2 || len > 4) {
            throw new Exception("Dimensions of the peak coordinates are not 2, 3 or 4. Use getDoGPeaks() instead.");
        }
        if (scalingFactor.length != len) {
            throw new IllegalArgumentException("scalingFactor dimensions does not match with the dimensions of the peaks.");
        }
        switch (len) {
            case 2: {
                for (float[] p : this) {
                    points.add(new Point2f(DoGPeaks.scaled(p, scalingFactor)));
                }
                break;
            }
            case 3: {
                for (float[] p : this) {
                    points.add(new Point3f(DoGPeaks.scaled(p, scalingFactor)));
                }
                break;
            }
            case 4: {
                for (float[] p : this) {
                    points.add(new Point4f(DoGPeaks.scaled(p, scalingFactor)));
                }
                break;
            }
        }
        return points;
    }

    public List<Object> asPoints() throws Exception {
        return this.asPoints(1);
    }

    public List<Object> asPoints(Number scalingFactor) throws Exception {
        if (this.isEmpty()) {
            return new ArrayList<Object>();
        }
        float[] s = new float[((float[])this.get(0)).length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = scalingFactor.floatValue();
        }
        return this.asPoints(s);
    }

    private static final float[] scaled(float[] peak, float[] scalingFactor) {
        float[] p = new float[peak.length];
        for (int i = 0; i < peak.length; ++i) {
            p[i] = peak[i] * scalingFactor[i];
        }
        return p;
    }
}

