/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.action;

import java.util.Collection;
import java.util.Collections;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.GroupAction;
import net.imagej.updater.UpdateSite;

public class Upload
implements GroupAction {
    private String updateSite;

    public Upload(String updateSite) {
        this.updateSite = updateSite;
    }

    @Override
    public boolean isValid(FilesCollection files, FileObject file) {
        boolean shadowing;
        FileObject.Status status = file.getStatus();
        boolean canUpload = status.isValid(FileObject.Action.UPLOAD);
        boolean bl = shadowing = file.updateSite != null && !this.updateSite.equals(file.updateSite);
        if (!canUpload && status != FileObject.Status.INSTALLED) {
            return false;
        }
        Collection<String> sites = files.getSiteNamesToUpload();
        if (sites.size() > 0 && !sites.contains(this.updateSite)) {
            return false;
        }
        if (shadowing) {
            UpdateSite shadowingSite = files.getUpdateSite(this.updateSite, false);
            UpdateSite shadowedSite = files.getUpdateSite(file.updateSite, false);
            if (shadowingSite.getRank() < shadowedSite.getRank()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setAction(FilesCollection files, FileObject file) {
        if (file.updateSite != null && !file.updateSite.equals(this.updateSite) && file.originalUpdateSite == null) {
            file.originalUpdateSite = file.updateSite;
        }
        file.updateSite = this.updateSite;
        if (file.getStatus() == FileObject.Status.INSTALLED) {
            file.setStatus(FileObject.Status.MODIFIED);
        }
        file.setAction(files, FileObject.Action.UPLOAD);
    }

    @Override
    public String getLabel(FilesCollection files, Iterable<FileObject> selected) {
        boolean shadowing = false;
        for (FileObject file : selected) {
            FileObject.Status status = file.getStatus();
            if (!status.isValid(FileObject.Action.UPLOAD) && status != FileObject.Status.INSTALLED || file.updateSite == null || file.updateSite.equals(this.updateSite)) continue;
            shadowing = true;
        }
        return "Upload" + (shadowing ? " (shadowing)" : "") + " to " + this.updateSite;
    }

    public String toString() {
        return this.getLabel(null, Collections.emptyList());
    }
}

