/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.RenderAtomListInfo;
import org.scijava.java3d.RenderMethod;
import org.scijava.java3d.RenderMolecule;
import org.scijava.java3d.VirtualUniverse;

class VertexArrayRenderMethod
implements RenderMethod {
    VertexArrayRenderMethod() {
    }

    @Override
    public boolean render(RenderMolecule rm, Canvas3D cv, RenderAtomListInfo ra, int dirtyBits) {
        GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
        geo.setVertexFormat(rm.useAlpha && (geo.vertexFormat & 4) != 0, rm.textureBin.attributeBin.ignoreVertexColors, cv.ctx);
        if (rm.doInfinite) {
            cv.updateState(dirtyBits);
            while (ra != null) {
                this.renderGeo(ra, rm, cv);
                ra = ra.next;
            }
            return true;
        }
        boolean isVisible = false;
        while (ra != null) {
            if (cv.ra == ra.renderAtom) {
                if (cv.raIsVisible) {
                    cv.updateState(dirtyBits);
                    this.renderGeo(ra, rm, cv);
                    isVisible = true;
                }
            } else {
                if (!VirtualUniverse.mc.viewFrustumCulling || ra.renderAtom.localeVwcBounds.intersect(cv.viewFrustum)) {
                    cv.updateState(dirtyBits);
                    cv.raIsVisible = true;
                    this.renderGeo(ra, rm, cv);
                    isVisible = true;
                } else {
                    cv.raIsVisible = false;
                }
                cv.ra = ra.renderAtom;
            }
            ra = ra.next;
        }
        return isVisible;
    }

    void renderGeo(RenderAtomListInfo ra, RenderMolecule rm, Canvas3D cv) {
        boolean useAlpha = rm.useAlpha;
        GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
        geo.execute(cv, ra.renderAtom, rm.isNonUniformScale, useAlpha && (geo.vertexFormat & 4) != 0, rm.alpha, cv.screen.screen, rm.textureBin.attributeBin.ignoreVertexColors);
    }
}

