/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.PointMatch;

public class TransformMesh
extends mpicbg.models.TransformMesh {
    protected final Rectangle boundingBox;

    public final Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public TransformMesh(CoordinateTransform t, int numX, double width, double height) {
        super(numX, TransformMesh.numY((int)numX, (double)width, (double)height), width, height);
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        Set vertices = this.va.keySet();
        for (PointMatch vertex : vertices) {
            double[] w = vertex.getP2().getW();
            t.applyInPlace(w);
            if (w[0] < xMin) {
                xMin = w[0];
            }
            if (w[0] > xMax) {
                xMax = w[0];
            }
            if (w[1] < yMin) {
                yMin = w[1];
            }
            if (!(w[1] > yMax)) continue;
            yMax = w[1];
        }
        for (PointMatch vertex : vertices) {
            int tx = (int)xMin;
            int ty = (int)yMin;
            double[] w = vertex.getP2().getW();
            w[0] = w[0] - (double)tx;
            w[1] = w[1] - (double)ty;
        }
        this.updateAffines();
        double fw = xMax - xMin;
        double fh = yMax - yMin;
        int w = (int)fw;
        int h = (int)fh;
        this.boundingBox = new Rectangle((int)xMin, (int)yMin, (double)w == fw ? w : w + 1, (double)h == fh ? h : h + 1);
    }

    public void applyInverseInPlace(double[] location) throws NoninvertibleModelException {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            if (!TransformMesh.isInConvexTargetPolygon((ArrayList)pm, (double[])location)) continue;
            ai.applyInverseInPlace(location);
            return;
        }
        double dMin = Double.MAX_VALUE;
        AffineModel2D closestAffine = new AffineModel2D();
        double x = location[0];
        double y = location[1];
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            double d = 0.0;
            for (PointMatch p : pm) {
                double[] w = p.getP2().getW();
                double dx = w[0] - x;
                double dy = w[1] - y;
                d += Math.sqrt(dx * dx + dy * dy);
            }
            if (!(d < dMin)) continue;
            dMin = d;
            closestAffine = ai;
        }
        closestAffine.applyInverseInPlace(location);
        throw new NoninvertibleModelException("Mesh external location ( " + x + ", " + y + " ) transferred to ( " + location[0] + ", " + location[1] + " ) by closest affine.");
    }

    public AffineModel2D closestSourceAffine(double[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            if (!TransformMesh.isInSourcePolygon((ArrayList)pm, (double[])location)) continue;
            return ai;
        }
        double dMin = Double.MAX_VALUE;
        AffineModel2D closestAffine = new AffineModel2D();
        double x = location[0];
        double y = location[1];
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            double d = 0.0;
            for (PointMatch p : pm) {
                double[] l = p.getP1().getL();
                double dx = l[0] - x;
                double dy = l[1] - y;
                d += Math.sqrt(dx * dx + dy * dy);
            }
            if (!(d < dMin)) continue;
            dMin = d;
            closestAffine = ai;
        }
        return closestAffine;
    }

    public AffineModel2D closestTargetAffine(double[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            if (!TransformMesh.isInConvexTargetPolygon((ArrayList)pm, (double[])location)) continue;
            return ai;
        }
        double dMin = Double.MAX_VALUE;
        AffineModel2D closestAffine = new AffineModel2D();
        double x = location[0];
        double y = location[1];
        for (AffineModel2D ai : s) {
            ArrayList pm = (ArrayList)this.av.get(ai);
            double d = 0.0;
            for (PointMatch p : pm) {
                double[] w = p.getP2().getW();
                double dx = w[0] - x;
                double dy = w[1] - y;
                d += Math.sqrt(dx * dx + dy * dy);
            }
            if (!(d < dMin)) continue;
            dMin = d;
            closestAffine = ai;
        }
        return closestAffine;
    }
}

