/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ColorProcessor;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.util.Util;

public final class LongRGBIntegralImage
implements IntegralImage {
    protected final int width;
    protected final int height;
    protected final int w;
    protected final int w1;
    protected final long[] sumR;
    protected final long[] sumG;
    protected final long[] sumB;

    LongRGBIntegralImage(int[] pixels, int width, int height) {
        this.width = width;
        this.height = height;
        this.w = width + 1;
        this.w1 = this.w + 1;
        int w2 = this.w + this.w;
        int n = this.w * height + this.w;
        int n1 = n - this.w1;
        int n2 = n1 - this.w + 2;
        this.sumR = new long[n];
        this.sumG = new long[n];
        this.sumB = new long[n];
        int i = 0;
        for (int j = this.w1; j < n; ++j) {
            int end = i + width;
            int rgb = pixels[i];
            long sR = this.sumR[j] = (long)(rgb >> 16 & 0xFF);
            long sG = this.sumG[j] = (long)(rgb >> 8 & 0xFF);
            long sB = this.sumB[j] = (long)(rgb & 0xFF);
            ++i;
            ++j;
            while (i < end) {
                rgb = pixels[i];
                this.sumR[j] = sR += (long)(rgb >> 16 & 0xFF);
                this.sumG[j] = sG += (long)(rgb >> 8 & 0xFF);
                this.sumB[j] = sB += (long)(rgb & 0xFF);
                ++i;
                ++j;
            }
        }
        for (int j = this.w1; j < w2; j -= n1) {
            int end = j + n2;
            long sR = this.sumR[j];
            long sG = this.sumG[j];
            long sB = this.sumB[j];
            j += this.w;
            while (j < end) {
                this.sumR[j] = sR += this.sumR[j];
                this.sumG[j] = sG += this.sumG[j];
                this.sumB[j] = sB += this.sumB[j];
                j += this.w;
            }
        }
    }

    public LongRGBIntegralImage(ColorProcessor ip) {
        this((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final void longSums(long[] sums, int x, int y) {
        int i = y * this.w + this.w1 + x;
        sums[0] = this.sumR[i];
        sums[1] = this.sumG[i];
        sums[2] = this.sumB[i];
    }

    public final void longSums(long[] sums, int xMin, int yMin, int xMax, int yMax) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        int a = y1w + xMin;
        int b = y2w + xMax;
        int c = y1w + xMax;
        int d = y2w + xMin;
        sums[0] = this.sumR[a] + this.sumR[b] - this.sumR[c] - this.sumR[d];
        sums[1] = this.sumG[a] + this.sumG[b] - this.sumG[c] - this.sumG[d];
        sums[2] = this.sumB[a] + this.sumB[b] - this.sumB[c] - this.sumB[d];
    }

    @Override
    public final int getSum(int xMin, int yMin, int xMax, int yMax) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        int a = y1w + xMin;
        int b = y2w + xMax;
        int c = y1w + xMax;
        int d = y2w + xMin;
        int r = (int)(this.sumR[a] + this.sumR[b] - this.sumR[c] - this.sumR[d]);
        int g = (int)(this.sumG[a] + this.sumG[b] - this.sumG[c] - this.sumG[d]);
        int x = (int)(this.sumB[a] + this.sumB[b] - this.sumB[c] - this.sumB[d]);
        return (r << 8 | g) << 8 | x;
    }

    @Override
    public final int getScaledSum(int xMin, int yMin, int xMax, int yMax, float scale) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        int a = y1w + xMin;
        int b = y2w + xMax;
        int c = y1w + xMax;
        int d = y2w + xMin;
        int r = Util.roundPos((float)(this.sumR[a] + this.sumR[b] - this.sumR[c] - this.sumR[d]) * scale);
        int g = Util.roundPos((float)(this.sumG[a] + this.sumG[b] - this.sumG[c] - this.sumG[d]) * scale);
        int x = Util.roundPos((float)(this.sumB[a] + this.sumB[b] - this.sumB[c] - this.sumB[d]) * scale);
        return (r << 8 | g) << 8 | x;
    }
}

