/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.util.Vector;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.util.Matrix3x3;

public class FloatArray2DScaleOctaveDoGDetector {
    private static final float MIN_CONTRAST = 0.025f;
    private static final float MAX_CURVATURE = 10.0f;
    private static final float MAX_CURVATURE_RATIO = 12.1f;
    private FloatArray2DScaleOctave octave = null;
    private Vector<double[]> candidates = null;

    public Vector<double[]> getCandidates() {
        return this.candidates;
    }

    public void run(FloatArray2DScaleOctave o) {
        this.octave = o;
        this.candidates = new Vector();
        this.detectCandidates();
    }

    private void detectCandidates() {
        FloatArray2D[] d = this.octave.getD();
        for (int i = d.length - 2; i >= 1; --i) {
            int ia = i - 1;
            int ib = i + 1;
            for (int y = d[i].height - 2; y >= 1; --y) {
                int r = y * d[i].width;
                int ra = r - d[i].width;
                int rb = r + d[i].width;
                block2: for (int x = d[i].width - 2; x >= 1; --x) {
                    double det;
                    double trace;
                    double oi;
                    double oy;
                    double ox;
                    double dyy;
                    double dxy;
                    double dxx;
                    double di;
                    double dy;
                    double dx;
                    double e222;
                    double e122;
                    double e022;
                    double e212;
                    double e112;
                    double e012;
                    double e202;
                    double e102;
                    double e002;
                    double e221;
                    double e121;
                    double e021;
                    double e211;
                    double e011;
                    double e201;
                    double e101;
                    double e001;
                    double e220;
                    double e120;
                    double e020;
                    double e210;
                    double e110;
                    double e010;
                    double e200;
                    double e100;
                    boolean isMin;
                    int ic = i;
                    int iac = ia;
                    int ibc = ib;
                    int yc = y;
                    int rc = r;
                    int rac = ra;
                    int rbc = rb;
                    int xc = x;
                    int xa = xc - 1;
                    int xb = xc + 1;
                    double e000 = d[iac].data[rac + xa];
                    double e111 = d[ic].data[r + xc];
                    boolean isMax = e000 < e111;
                    boolean bl = isMin = e000 > e111;
                    if (!isMax && !isMin || !(isMax &= (e100 = (double)d[iac].data[rac + xc]) < e111) && !(isMin &= e100 > e111) || !(isMax &= (e200 = (double)d[iac].data[rac + xb]) < e111) && !(isMin &= e200 > e111) || !(isMax &= (e010 = (double)d[iac].data[rc + xa]) < e111) && !(isMin &= e010 > e111) || !(isMax &= (e110 = (double)d[iac].data[rc + xc]) < e111) && !(isMin &= e110 > e111) || !(isMax &= (e210 = (double)d[iac].data[rc + xb]) < e111) && !(isMin &= e210 > e111) || !(isMax &= (e020 = (double)d[iac].data[rbc + xa]) < e111) && !(isMin &= e020 > e111) || !(isMax &= (e120 = (double)d[iac].data[rbc + xc]) < e111) && !(isMin &= e120 > e111) || !(isMax &= (e220 = (double)d[iac].data[rbc + xb]) < e111) && !(isMin &= e220 > e111) || !(isMax &= (e001 = (double)d[ic].data[rac + xa]) < e111) && !(isMin &= e001 > e111) || !(isMax &= (e101 = (double)d[ic].data[rac + xc]) < e111) && !(isMin &= e101 > e111) || !(isMax &= (e201 = (double)d[ic].data[rac + xb]) < e111) && !(isMin &= e201 > e111) || !(isMax &= (e011 = (double)d[ic].data[rc + xa]) < e111) && !(isMin &= e011 > e111) || !(isMax &= (e211 = (double)d[ic].data[rc + xb]) < e111) && !(isMin &= e211 > e111) || !(isMax &= (e021 = (double)d[ic].data[rbc + xa]) < e111) && !(isMin &= e021 > e111) || !(isMax &= (e121 = (double)d[ic].data[rbc + xc]) < e111) && !(isMin &= e121 > e111) || !(isMax &= (e221 = (double)d[ic].data[rbc + xb]) < e111) && !(isMin &= e221 > e111) || !(isMax &= (e002 = (double)d[ibc].data[rac + xa]) < e111) && !(isMin &= e002 > e111) || !(isMax &= (e102 = (double)d[ibc].data[rac + xc]) < e111) && !(isMin &= e102 > e111) || !(isMax &= (e202 = (double)d[ibc].data[rac + xb]) < e111) && !(isMin &= e202 > e111) || !(isMax &= (e012 = (double)d[ibc].data[rc + xa]) < e111) && !(isMin &= e012 > e111) || !(isMax &= (e112 = (double)d[ibc].data[rc + xc]) < e111) && !(isMin &= e112 > e111) || !(isMax &= (e212 = (double)d[ibc].data[rc + xb]) < e111) && !(isMin &= e212 > e111) || !(isMax &= (e022 = (double)d[ibc].data[rbc + xa]) < e111) && !(isMin &= e022 > e111) || !(isMax &= (e122 = (double)d[ibc].data[rbc + xc]) < e111) && !(isMin &= e122 > e111) || !(isMax &= (e222 = (double)d[ibc].data[rbc + xb]) < e111) && !(isMin &= e222 > e111)) continue;
                    boolean isLocalized = false;
                    boolean isLocalizable = true;
                    double od = Double.MAX_VALUE;
                    double fx = 0.0;
                    double fy = 0.0;
                    double fi = 0.0;
                    int t = 5;
                    do {
                        --t;
                        dx = (e211 - e011) / 2.0;
                        dy = (e121 - e101) / 2.0;
                        di = (e112 - e110) / 2.0;
                        double e111_2 = 2.0 * e111;
                        dxx = e011 - e111_2 + e211;
                        dxy = (e221 - e021 - e201 + e001) / 4.0;
                        double dxi = (e212 - e012 - e210 + e010) / 4.0;
                        dyy = e101 - e111_2 + e121;
                        double dyi = (e122 - e102 - e120 + e100) / 4.0;
                        double dii = e110 - e111_2 + e112;
                        double det2 = Matrix3x3.det(dxx, dxy, dxi, dxy, dyy, dyi, dxi, dyi, dii);
                        if (det2 == 0.0) continue block2;
                        double det1 = 1.0 / det2;
                        double hixx = (dyy * dii - dyi * dyi) * det1;
                        double hixy = (dxi * dyi - dxy * dii) * det1;
                        double hixi = (dxy * dyi - dxi * dyy) * det1;
                        ox = -hixx * dx - hixy * dy - hixi * di;
                        double hiyy = (dxx * dii - dxi * dxi) * det1;
                        double hiyi = (dxi * dxy - dxx * dyi) * det1;
                        oy = -hixy * dx - hiyy * dy - hiyi * di;
                        double hiii = (dxx * dyy - dxy * dxy) * det1;
                        oi = -hixi * dx - hiyi * dy - hiii * di;
                        double odc = ox * ox + oy * oy + oi * oi;
                        if (odc < 2.0) {
                            if ((Math.abs(ox) > 0.5 || Math.abs(oy) > 0.5 || Math.abs(oi) > 0.5) && odc < od) {
                                od = odc;
                                xc = (int)Math.round((double)xc + ox);
                                yc = (int)Math.round((double)yc + oy);
                                ic = (int)Math.round((double)ic + oi);
                                if (xc < 1 || yc < 1 || ic < 1 || xc > d[0].width - 2 || yc > d[0].height - 2 || ic > d.length - 2) {
                                    isLocalizable = false;
                                    continue;
                                }
                                xa = xc - 1;
                                xb = xc + 1;
                                rc = yc * d[ic].width;
                                rac = rc - d[ic].width;
                                rbc = rc + d[ic].width;
                                iac = ic - 1;
                                ibc = ic + 1;
                                e000 = d[iac].data[rac + xa];
                                e100 = d[iac].data[rac + xc];
                                e200 = d[iac].data[rac + xb];
                                e010 = d[iac].data[rc + xa];
                                e110 = d[iac].data[rc + xc];
                                e210 = d[iac].data[rc + xb];
                                e020 = d[iac].data[rbc + xa];
                                e120 = d[iac].data[rbc + xc];
                                e220 = d[iac].data[rbc + xb];
                                e001 = d[ic].data[rac + xa];
                                e101 = d[ic].data[rac + xc];
                                e201 = d[ic].data[rac + xb];
                                e011 = d[ic].data[rc + xa];
                                e111 = d[ic].data[rc + xc];
                                e211 = d[ic].data[rc + xb];
                                e021 = d[ic].data[rbc + xa];
                                e121 = d[ic].data[rbc + xc];
                                e221 = d[ic].data[rbc + xb];
                                e002 = d[ibc].data[rac + xa];
                                e102 = d[ibc].data[rac + xc];
                                e202 = d[ibc].data[rac + xb];
                                e012 = d[ibc].data[rc + xa];
                                e112 = d[ibc].data[rc + xc];
                                e212 = d[ibc].data[rc + xb];
                                e022 = d[ibc].data[rbc + xa];
                                e122 = d[ibc].data[rbc + xc];
                                e222 = d[ibc].data[rbc + xb];
                                continue;
                            }
                            fx = (double)xc + ox;
                            fy = (double)yc + oy;
                            fi = (double)ic + oi;
                            if (fx < 0.0 || fy < 0.0 || fi < 0.0 || fx > (double)(d[0].width - 1) || fy > (double)(d[0].height - 1) || fi > (double)(d.length - 1)) {
                                isLocalizable = false;
                                continue;
                            }
                            isLocalized = true;
                            continue;
                        }
                        isLocalizable = false;
                    } while (!isLocalized && isLocalizable && t >= 0);
                    if (!isLocalized || Math.abs(e111 + 0.5 * (dx * ox + dy * oy + di * oi)) < (double)0.025f || (trace = dxx + dyy) * trace / (det = dxx * dyy - dxy * dxy) > (double)12.1f) continue;
                    this.candidates.addElement(new double[]{fx, fy, fi});
                }
            }
        }
    }
}

